/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.options;

import io.micronaut.core.annotation.NonNull;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.grails.forge.application.Project;
import org.grails.forge.build.gradle.GradleDsl;

public enum BuildTool {
    GRADLE("build/libs", "build.gradle", "-*-all.jar");

    public static final BuildTool DEFAULT_OPTION;
    private final String jarDirectory;
    private final String fileName;
    private final String shadeJarPattern;

    private BuildTool(String jarDirectory, String fileName, String shadeJarPattern) {
        this.jarDirectory = jarDirectory;
        this.fileName = fileName;
        this.shadeJarPattern = shadeJarPattern;
    }

    public String getJarDirectory() {
        return this.jarDirectory;
    }

    public String getShadeJarDirectoryPattern(Project project) {
        Objects.requireNonNull(project, "Project should not be null");
        return this.getJarDirectory() + "/" + project.getName() + this.shadeJarPattern;
    }

    public String getBuildFileName() {
        return this.fileName;
    }

    public String toString() {
        return this.getName();
    }

    @NonNull
    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public boolean isGradle() {
        return this == GRADLE;
    }

    public Optional<GradleDsl> getGradleDsl() {
        if (this.isGradle() && this == GRADLE) {
            return Optional.of(GradleDsl.GROOVY);
        }
        return Optional.empty();
    }

    static {
        DEFAULT_OPTION = GRADLE;
    }
}

