/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.AotException;
import org.springframework.beans.factory.aot.AotProcessingException;
import org.springframework.beans.factory.aot.AotServices;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.aot.RuntimeHintsBeanFactoryInitializationAotProcessor;
import org.springframework.lang.Nullable;

class BeanFactoryInitializationAotContributions {
    private final List<BeanFactoryInitializationAotContribution> contributions;

    BeanFactoryInitializationAotContributions(DefaultListableBeanFactory beanFactory) {
        this(beanFactory, AotServices.factoriesAndBeans(beanFactory));
    }

    BeanFactoryInitializationAotContributions(DefaultListableBeanFactory beanFactory, AotServices.Loader loader) {
        this.contributions = this.getContributions(beanFactory, BeanFactoryInitializationAotContributions.getProcessors(loader));
    }

    private static List<BeanFactoryInitializationAotProcessor> getProcessors(AotServices.Loader loader) {
        ArrayList<BeanFactoryInitializationAotProcessor> processors = new ArrayList<BeanFactoryInitializationAotProcessor>(loader.load(BeanFactoryInitializationAotProcessor.class).asList());
        processors.add(new RuntimeHintsBeanFactoryInitializationAotProcessor());
        return Collections.unmodifiableList(processors);
    }

    private List<BeanFactoryInitializationAotContribution> getContributions(DefaultListableBeanFactory beanFactory, List<BeanFactoryInitializationAotProcessor> processors) {
        ArrayList<BeanFactoryInitializationAotContribution> contributions = new ArrayList<BeanFactoryInitializationAotContribution>();
        for (BeanFactoryInitializationAotProcessor processor : processors) {
            BeanFactoryInitializationAotContribution contribution = this.processAheadOfTime(processor, beanFactory);
            if (contribution == null) continue;
            contributions.add(contribution);
        }
        return Collections.unmodifiableList(contributions);
    }

    @Nullable
    private BeanFactoryInitializationAotContribution processAheadOfTime(BeanFactoryInitializationAotProcessor processor, DefaultListableBeanFactory beanFactory) {
        try {
            return processor.processAheadOfTime(beanFactory);
        }
        catch (AotException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AotProcessingException("Error executing '" + processor.getClass().getName() + "': " + ex.getMessage(), ex);
        }
    }

    void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
        for (BeanFactoryInitializationAotContribution contribution : this.contributions) {
            contribution.applyTo(generationContext, beanFactoryInitializationCode);
        }
    }
}

