/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;

public class ByteArrayHttpMessageConverter
extends AbstractHttpMessageConverter<byte[]> {
    public ByteArrayHttpMessageConverter() {
        super(MediaType.APPLICATION_OCTET_STREAM, MediaType.ALL);
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return byte[].class == clazz;
    }

    @Override
    public byte[] readInternal(Class<? extends byte[]> clazz, HttpInputMessage message) throws IOException {
        long length = message.getHeaders().getContentLength();
        return length >= 0L && length < Integer.MAX_VALUE ? message.getBody().readNBytes((int)length) : message.getBody().readAllBytes();
    }

    @Override
    protected Long getContentLength(byte[] bytes, @Nullable MediaType contentType) {
        return bytes.length;
    }

    @Override
    protected void writeInternal(byte[] bytes, HttpOutputMessage outputMessage) throws IOException {
        StreamUtils.copy(bytes, outputMessage.getBody());
    }

    @Override
    protected boolean supportsRepeatableWrites(byte[] bytes) {
        return true;
    }
}

