/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.conf;

import com.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.enums.HandleSystemErrorStrategy;
import org.apache.iotdb.commons.enums.PipeRateAverage;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.KillPoint.KillPoint;
import org.apache.tsfile.fileSystem.FSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonConfig {
    public static final String OLD_CONFIG_NODE_CONFIG_NAME = "iotdb-confignode.properties";
    public static final String OLD_DATA_NODE_CONFIG_NAME = "iotdb-datanode.properties";
    public static final String OLD_COMMON_CONFIG_NAME = "iotdb-common.properties";
    public static final String SYSTEM_CONFIG_NAME = "iotdb-system.properties";
    public static final String SYSTEM_CONFIG_TEMPLATE_NAME = "iotdb-system.properties.template";
    private static final Logger logger = LoggerFactory.getLogger(CommonConfig.class);
    private String openIdProviderUrl = "";
    private String authorizerProvider = "org.apache.iotdb.commons.auth.authorizer.LocalFileAuthorizer";
    private String encryptDecryptProvider = "org.apache.iotdb.commons.security.encrypt.MessageDigestEncrypt";
    private String encryptDecryptProviderParameter;
    private String adminName = "root";
    private String adminPassword = "root";
    private String oldUserFolder = IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "system" + File.separator + "users";
    private String oldRoleFolder = IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "system" + File.separator + "roles";
    private String oldProcedureWalFolder = IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "system" + File.separator + "procedure";
    private String userFolder = IoTDBConstant.CN_DEFAULT_DATA_DIR + File.separator + "system" + File.separator + "users";
    private String roleFolder = IoTDBConstant.CN_DEFAULT_DATA_DIR + File.separator + "system" + File.separator + "roles";
    private String procedureWalFolder = IoTDBConstant.CN_DEFAULT_DATA_DIR + File.separator + "system" + File.separator + "procedure";
    private String syncDir = IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "sync";
    private String[] walDirs = new String[]{IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "wal"};
    private FSType systemFileStorageFs = FSType.LOCAL;
    private long[] tierTTLInMs = new long[]{Long.MAX_VALUE};
    private int ttlRuleCapacity = 1000;
    private long ttlCheckInterval = 0x6DDD00L;
    private int cnConnectionTimeoutInMS = (int)TimeUnit.SECONDS.toMillis(60L);
    private int dnConnectionTimeoutInMS = (int)TimeUnit.SECONDS.toMillis(60L);
    private int selectorNumOfClientManager = 1;
    private boolean isRpcThriftCompressionEnabled = false;
    private int maxClientNumForEachNode = 1000;
    private HandleSystemErrorStrategy handleSystemErrorStrategy = HandleSystemErrorStrategy.CHANGE_TO_READ_ONLY;
    private volatile NodeStatus status = NodeStatus.Running;
    private NodeStatus lastStatus = NodeStatus.Unknown;
    private String lastStatusReason = "";
    private volatile boolean isStopping = false;
    private volatile String statusReason = null;
    private final int TTimePartitionSlotTransmitLimit = 1000;
    private double diskSpaceWarningThreshold = 0.05;
    private TEndPoint targetAINodeEndPoint = new TEndPoint("127.0.0.1", 10810);
    private long timePartitionOrigin = 0L;
    private long timePartitionInterval = 604800000L;
    private String timestampPrecision = "ms";
    private boolean timestampPrecisionCheckEnabled = true;
    private int modelInferenceExecutionThreadCount = 5;
    private String pipeHardlinkBaseDirName = "pipe";
    private String pipeHardlinkTsFileDirName = "tsfile";
    private boolean pipeFileReceiverFsyncEnabled = true;
    private int pipeRealTimeQueuePollTsFileThreshold = 10;
    private int pipeRealTimeQueuePollHistoricalTsFileThreshold = 1;
    private int pipeRealTimeQueueMaxWaitingTsFileSize = 1;
    private int pipeSubtaskExecutorMaxThreadNum = Math.max(5, Runtime.getRuntime().availableProcessors() / 2);
    private boolean pipeRetryLocallyForParallelOrUserConflict = true;
    private int pipeDataStructureTabletRowSize = 2048;
    private int pipeDataStructureTabletSizeInBytes = 0x200000;
    private double pipeDataStructureTabletMemoryBlockAllocationRejectThreshold = 0.3;
    private double pipeDataStructureTsFileMemoryBlockAllocationRejectThreshold = 0.3;
    private volatile double pipeTotalFloatingMemoryProportion = 0.5;
    private boolean isPipeEnableMemoryCheck = true;
    private long pipeInsertNodeQueueMemory = 0xF00000L;
    private long pipeTsFileParserMemory = 0x1100000L;
    private long pipeSinkBatchMemoryInsertNode = 0xF00000L;
    private long pipeSinkBatchMemoryTsFile = 0xF00000L;
    private long pipeSendTsFileReadBuffer = 0xF00000L;
    private double pipeReservedMemoryPercentage = 0.15;
    private long pipeMinimumReceiverMemory = 0x2600000L;
    private int pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount = 10000;
    private long pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration = 10000L;
    private long pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs = 50L;
    private volatile long pipeSinkSubtaskSleepIntervalInitMs = 250L;
    private volatile long pipeSinkSubtaskSleepIntervalMaxMs = 1000L;
    private long pipeSubtaskExecutorCronHeartbeatEventIntervalSeconds = 20L;
    private long pipeMaxWaitFinishTime = 10000L;
    private int pipeSourceAssignerDisruptorRingBufferSize = 128;
    private long pipeSourceAssignerDisruptorRingBufferEntrySizeInBytes = 73728L;
    private long pipeSourceMatcherCacheSize = 1024L;
    private int pipeSinkHandshakeTimeoutMs = 10000;
    private int pipeConnectorTransferTimeoutMs = 900000;
    private int pipeConnectorReadFileBufferSize = 0x500000;
    private boolean isPipeConnectorReadFileBufferMemoryControlEnabled = false;
    private long pipeConnectorRetryIntervalMs = 1000L;
    private boolean pipeConnectorRPCThriftCompressionEnabled = false;
    private int pipeAsyncSinkForcedRetryTsFileEventQueueSize = 5;
    private int pipeAsyncSinkForcedRetryTabletEventQueueSize = 20;
    private int pipeAsyncSinkForcedRetryTotalEventQueueSize = 30;
    private long pipeAsyncConnectorMaxRetryExecutionTimeMsPerCall = 500L;
    private int pipeAsyncConnectorSelectorNumber = Math.max(4, Runtime.getRuntime().availableProcessors() / 2);
    private int pipeAsyncConnectorMaxClientNumber = Math.max(32, Runtime.getRuntime().availableProcessors() * 2);
    private int pipeAsyncConnectorMaxTsFileClientNumber = Math.max(16, Runtime.getRuntime().availableProcessors());
    private double pipeSendTsFileRateLimitBytesPerSecond = 3.3554432E7;
    private double pipeAllSinksRateLimitBytesPerSecond = -1.0;
    private int rateLimiterHotReloadCheckIntervalMs = 1000;
    private int pipeConnectorRequestSliceThresholdBytes = 0x19999999;
    private boolean isSeperatedPipeHeartbeatEnabled = true;
    private int pipeHeartbeatIntervalSecondsForCollectingPipeMeta = 3;
    private long pipeMetaSyncerInitialSyncDelayMinutes = 3L;
    private long pipeMetaSyncerSyncIntervalMinutes = 3L;
    private long pipeMetaSyncerAutoRestartPipeCheckIntervalRound = 1L;
    private boolean pipeAutoRestartEnabled = true;
    private boolean pipeAirGapReceiverEnabled = false;
    private int pipeAirGapReceiverPort = 9780;
    private long pipeReceiverLoginPeriodicVerificationIntervalMs = -1L;
    private double pipeReceiverActualToEstimatedMemoryRatio = 3.0;
    private int pipeReceiverReqDecompressedMaxLengthInBytes = 0x40000000;
    private boolean pipeReceiverLoadConversionEnabled = false;
    private volatile long pipePeriodicalLogMinIntervalSeconds = 60L;
    private volatile long pipeLoggerCacheMaxSizeInBytes = 0x1000000L;
    private volatile double pipeMetaReportMaxLogNumPerRound = 0.1;
    private volatile int pipeMetaReportMaxLogIntervalRounds = 360;
    private volatile int pipeTsFilePinMaxLogNumPerRound = 10;
    private volatile int pipeTsFilePinMaxLogIntervalRounds = 90;
    private volatile boolean pipeMemoryManagementEnabled = true;
    private volatile long pipeMemoryAllocateRetryIntervalMs = 50L;
    private volatile int pipeMemoryAllocateMaxRetries = 10;
    private volatile long pipeMemoryAllocateMinSizeInBytes = 32L;
    private volatile long pipeMemoryAllocateForTsFileSequenceReaderInBytes = 0x200000L;
    private volatile long pipeMemoryExpanderIntervalSeconds = 180L;
    private volatile long pipeCheckMemoryEnoughIntervalMs = 10L;
    private volatile float pipeLeaderCacheMemoryUsagePercentage = 0.1f;
    private volatile long pipeMaxReaderChunkSize = 0x1000000L;
    private volatile long pipeListeningQueueTransferSnapshotThreshold = 1000L;
    private volatile int pipeSnapshotExecutionMaxBatchSize = 1000;
    private volatile long pipeRemainingTimeCommitRateAutoSwitchSeconds = 30L;
    private volatile PipeRateAverage pipeRemainingTimeCommitRateAverageTime = PipeRateAverage.FIVE_MINUTES;
    private volatile double pipeRemainingInsertNodeCountEMAAlpha = 0.1;
    private volatile double pipeTsFileScanParsingThreshold = 0.05;
    private volatile double pipeDynamicMemoryHistoryWeight = 0.5;
    private volatile double pipeDynamicMemoryAdjustmentThreshold = 0.05;
    private volatile double pipeThresholdAllocationStrategyMaximumMemoryIncrementRatio = 0.1;
    private volatile double pipeThresholdAllocationStrategyLowUsageThreshold = 0.2;
    private volatile double pipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold = 0.8;
    private volatile boolean pipeTransferTsFileSync = false;
    private volatile long pipeCheckAllSyncClientLiveTimeIntervalMs = 300000L;
    private int pipeTsFileResourceSegmentLockNum = -1;
    private long twoStageAggregateMaxCombinerLiveTimeInMs = 480000L;
    private long twoStageAggregateDataRegionInfoCacheTimeInMs = 180000L;
    private long twoStageAggregateSenderEndPointsCacheInMs = 180000L;
    private boolean pipeEventReferenceTrackingEnabled = true;
    private long pipeEventReferenceEliminateIntervalSeconds = 10L;
    private boolean pipeAutoSplitFullEnabled = true;
    private boolean subscriptionEnabled = false;
    private float subscriptionCacheMemoryUsagePercentage = 0.2f;
    private int subscriptionSubtaskExecutorMaxThreadNum = 2;
    private int subscriptionPrefetchTabletBatchMaxDelayInMs = 20;
    private long subscriptionPrefetchTabletBatchMaxSizeInBytes = 0x100000L;
    private int subscriptionPrefetchTsFileBatchMaxDelayInMs = 1000;
    private long subscriptionPrefetchTsFileBatchMaxSizeInBytes = 0x200000L;
    private int subscriptionPollMaxBlockingTimeMs = 500;
    private int subscriptionDefaultTimeoutInMs = 10000;
    private long subscriptionLaunchRetryIntervalMs = 1000L;
    private int subscriptionRecycleUncommittedEventIntervalMs = 600000;
    private long subscriptionReadFileBufferSize = 0x800000L;
    private long subscriptionReadTabletBufferSize = 0x800000L;
    private long subscriptionTsFileDeduplicationWindowSeconds = 120L;
    private volatile long subscriptionCheckMemoryEnoughIntervalMs = 10L;
    private long subscriptionEstimatedInsertNodeTabletInsertionEventSize = 65536L;
    private long subscriptionEstimatedRawTabletInsertionEventSize = 16384L;
    private long subscriptionMaxAllowedEventCountInTabletBatch = 100L;
    private long subscriptionLogManagerWindowSeconds = 120L;
    private long subscriptionLogManagerBaseIntervalMs = 1000L;
    private boolean subscriptionPrefetchEnabled = false;
    private float subscriptionPrefetchMemoryThreshold = 0.5f;
    private float subscriptionPrefetchMissingRateThreshold = 0.9f;
    private int subscriptionPrefetchEventLocalCountThreshold = 10;
    private int subscriptionPrefetchEventGlobalCountThreshold = 100;
    private long subscriptionMetaSyncerInitialSyncDelayMinutes = 3L;
    private long subscriptionMetaSyncerSyncIntervalMinutes = 3L;
    private String schemaEngineMode = "Memory";
    private boolean lastCacheEnable = true;
    private int tagAttributeTotalSize = 700;
    private int databaseLimitThreshold = -1;
    private long datanodeTokenTimeoutMS = 180000L;
    private long seriesLimitThreshold = -1L;
    private long deviceLimitThreshold = -1L;
    private boolean enableBinaryAllocator = true;
    private int arenaNum = 4;
    private int minAllocateSize = 4096;
    private int maxAllocateSize = 0x100000;
    private int log2SizeClassGroup = 3;
    private final long startUpNanosecond = System.nanoTime();
    private final boolean isIntegrationTest = System.getProperties().containsKey("integrationTestKillPoints");
    private final Set<String> enabledKillPoints = KillPoint.parseKillPoints(System.getProperty("integrationTestKillPoints"));
    private volatile boolean retryForUnknownErrors = false;
    private volatile long remoteWriteMaxRetryDurationInMs = 60000L;
    private final RateLimiter querySamplingRateLimiter = RateLimiter.create((double)160.0);
    private volatile boolean querySamplingHasRateLimit = true;
    private volatile boolean enableQuerySampling = true;
    private volatile Pattern trustedUriPattern = Pattern.compile("file:.*");
    private int pathLogMaxSize = 100;

    CommonConfig() {
    }

    public void updatePath(String homeDir) {
        if (homeDir == null) {
            return;
        }
        File homeFile = new File(homeDir);
        try {
            homeDir = homeFile.getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("Fail to get canonical path of {}", (Object)homeFile, (Object)e);
        }
        this.userFolder = FileUtils.addPrefix2FilePath(homeDir, this.userFolder);
        this.roleFolder = FileUtils.addPrefix2FilePath(homeDir, this.roleFolder);
        this.procedureWalFolder = FileUtils.addPrefix2FilePath(homeDir, this.procedureWalFolder);
        this.syncDir = FileUtils.addPrefix2FilePath(homeDir, this.syncDir);
        for (int i = 0; i < this.walDirs.length; ++i) {
            this.walDirs[i] = FileUtils.addPrefix2FilePath(homeDir, this.walDirs[i]);
        }
    }

    public String getEncryptDecryptProvider() {
        return this.encryptDecryptProvider;
    }

    public void setEncryptDecryptProvider(String encryptDecryptProvider) {
        this.encryptDecryptProvider = encryptDecryptProvider;
    }

    public String getEncryptDecryptProviderParameter() {
        return this.encryptDecryptProviderParameter;
    }

    public void setEncryptDecryptProviderParameter(String encryptDecryptProviderParameter) {
        this.encryptDecryptProviderParameter = encryptDecryptProviderParameter;
    }

    public String getOpenIdProviderUrl() {
        return this.openIdProviderUrl;
    }

    public void setOpenIdProviderUrl(String openIdProviderUrl) {
        this.openIdProviderUrl = openIdProviderUrl;
    }

    public String getAuthorizerProvider() {
        return this.authorizerProvider;
    }

    public void setAuthorizerProvider(String authorizerProvider) {
        this.authorizerProvider = authorizerProvider;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getOldUserFolder() {
        return this.oldUserFolder;
    }

    public String getOldRoleFolder() {
        return this.oldRoleFolder;
    }

    public String getOldProcedureWalFolder() {
        return this.oldProcedureWalFolder;
    }

    public String getUserFolder() {
        return this.userFolder;
    }

    public void setUserFolder(String userFolder) {
        this.userFolder = userFolder;
    }

    public String getRoleFolder() {
        return this.roleFolder;
    }

    public void setRoleFolder(String roleFolder) {
        this.roleFolder = roleFolder;
    }

    public String getProcedureWalFolder() {
        return this.procedureWalFolder;
    }

    public void setProcedureWalFolder(String procedureWalFolder) {
        this.procedureWalFolder = procedureWalFolder;
    }

    public String getSyncDir() {
        return this.syncDir;
    }

    public void setSyncDir(String syncDir) {
        this.syncDir = syncDir;
    }

    public String[] getWalDirs() {
        return this.walDirs;
    }

    public void setWalDirs(String[] walDirs) {
        this.walDirs = walDirs;
    }

    public FSType getSystemFileStorageFs() {
        return this.systemFileStorageFs;
    }

    public void setSystemFileStorageFs(FSType systemFileStorageFs) {
        this.systemFileStorageFs = systemFileStorageFs;
    }

    public long[] getTierTTLInMs() {
        return this.tierTTLInMs;
    }

    public void setTierTTLInMs(long[] tierTTLInMs) {
        this.tierTTLInMs = tierTTLInMs;
    }

    public int getTTlRuleCapacity() {
        return this.ttlRuleCapacity;
    }

    public void setTTlRuleCapacity(int ttlRuleCapacity) {
        this.ttlRuleCapacity = ttlRuleCapacity;
    }

    public long getTTLCheckInterval() {
        return this.ttlCheckInterval;
    }

    public void setTTLCheckInterval(long ttlCheckInterval) {
        this.ttlCheckInterval = ttlCheckInterval;
    }

    public int getCnConnectionTimeoutInMS() {
        return this.cnConnectionTimeoutInMS;
    }

    public void setCnConnectionTimeoutInMS(int cnConnectionTimeoutInMS) {
        this.cnConnectionTimeoutInMS = cnConnectionTimeoutInMS;
    }

    public int getDnConnectionTimeoutInMS() {
        return this.dnConnectionTimeoutInMS;
    }

    public void setDnConnectionTimeoutInMS(int dnConnectionTimeoutInMS) {
        this.dnConnectionTimeoutInMS = dnConnectionTimeoutInMS;
    }

    public int getSelectorNumOfClientManager() {
        return this.selectorNumOfClientManager;
    }

    public void setSelectorNumOfClientManager(int selectorNumOfClientManager) {
        this.selectorNumOfClientManager = selectorNumOfClientManager;
    }

    public boolean isRpcThriftCompressionEnabled() {
        return this.isRpcThriftCompressionEnabled;
    }

    public void setRpcThriftCompressionEnabled(boolean rpcThriftCompressionEnabled) {
        this.isRpcThriftCompressionEnabled = rpcThriftCompressionEnabled;
    }

    public int getMaxClientNumForEachNode() {
        return this.maxClientNumForEachNode;
    }

    public void setMaxClientNumForEachNode(int maxClientNumForEachNode) {
        this.maxClientNumForEachNode = maxClientNumForEachNode;
    }

    HandleSystemErrorStrategy getHandleSystemErrorStrategy() {
        return this.handleSystemErrorStrategy;
    }

    void setHandleSystemErrorStrategy(HandleSystemErrorStrategy handleSystemErrorStrategy) {
        this.handleSystemErrorStrategy = handleSystemErrorStrategy;
    }

    public void handleUnrecoverableError() {
        this.handleSystemErrorStrategy.handle();
    }

    public double getDiskSpaceWarningThreshold() {
        return this.diskSpaceWarningThreshold;
    }

    public void setDiskSpaceWarningThreshold(double diskSpaceWarningThreshold) {
        this.diskSpaceWarningThreshold = diskSpaceWarningThreshold;
    }

    public boolean isReadOnly() {
        return this.status == NodeStatus.ReadOnly;
    }

    public boolean isRunning() {
        return this.status == NodeStatus.Running;
    }

    public NodeStatus getNodeStatus() {
        return this.status;
    }

    public void setNodeStatus(NodeStatus newStatus) {
        logger.info("Set system mode from {} to {}.", (Object)this.status, (Object)newStatus);
        this.status = newStatus;
        this.statusReason = null;
        switch (newStatus) {
            case ReadOnly: {
                logger.warn("Change system status to ReadOnly! Only query statements are permitted!");
                break;
            }
            case Removing: {
                logger.info("Change system status to Removing! The current Node is being removed from cluster!");
                break;
            }
        }
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public TEndPoint getTargetAINodeEndPoint() {
        return this.targetAINodeEndPoint;
    }

    public void setTargetAINodeEndPoint(TEndPoint targetAINodeEndPoint) {
        this.targetAINodeEndPoint = targetAINodeEndPoint;
    }

    public int getTTimePartitionSlotTransmitLimit() {
        return 1000;
    }

    public boolean isStopping() {
        return this.isStopping;
    }

    public void setStopping(boolean stopping) {
        this.isStopping = stopping;
    }

    public long getTimePartitionOrigin() {
        return this.timePartitionOrigin;
    }

    public void setTimePartitionOrigin(long timePartitionOrigin) {
        this.timePartitionOrigin = timePartitionOrigin;
    }

    public long getTimePartitionInterval() {
        return this.timePartitionInterval;
    }

    public void setTimePartitionInterval(long timePartitionInterval) {
        this.timePartitionInterval = timePartitionInterval;
    }

    public void setTimestampPrecision(String timestampPrecision) {
        if (!("ms".equals(timestampPrecision) || "us".equals(timestampPrecision) || "ns".equals(timestampPrecision))) {
            logger.error("Wrong timestamp precision, please set as: ms, us or ns ! Current is: {}", (Object)timestampPrecision);
            System.exit(-1);
        }
        this.timestampPrecision = timestampPrecision;
    }

    public String getTimestampPrecision() {
        return this.timestampPrecision;
    }

    public void setTimestampPrecisionCheckEnabled(boolean timestampPrecisionCheckEnabled) {
        this.timestampPrecisionCheckEnabled = timestampPrecisionCheckEnabled;
    }

    public boolean isTimestampPrecisionCheckEnabled() {
        return this.timestampPrecisionCheckEnabled;
    }

    public String getPipeHardlinkBaseDirName() {
        return this.pipeHardlinkBaseDirName;
    }

    public void setPipeHardlinkBaseDirName(String pipeHardlinkBaseDirName) {
        if (Objects.equals(pipeHardlinkBaseDirName, this.pipeHardlinkBaseDirName)) {
            return;
        }
        this.pipeHardlinkBaseDirName = pipeHardlinkBaseDirName;
        logger.info("pipeHardlinkBaseDirName is set to {}.", (Object)pipeHardlinkBaseDirName);
    }

    public String getPipeHardlinkTsFileDirName() {
        return this.pipeHardlinkTsFileDirName;
    }

    public void setPipeHardlinkTsFileDirName(String pipeTsFileDirName) {
        if (Objects.equals(this.pipeHardlinkTsFileDirName, pipeTsFileDirName)) {
            return;
        }
        this.pipeHardlinkTsFileDirName = pipeTsFileDirName;
        logger.info("pipeHardlinkTsFileDirName is set to {}.", (Object)pipeTsFileDirName);
    }

    public boolean getPipeFileReceiverFsyncEnabled() {
        return this.pipeFileReceiverFsyncEnabled;
    }

    public void setPipeFileReceiverFsyncEnabled(boolean pipeFileReceiverFsyncEnabled) {
        if (this.pipeFileReceiverFsyncEnabled == pipeFileReceiverFsyncEnabled) {
            return;
        }
        this.pipeFileReceiverFsyncEnabled = pipeFileReceiverFsyncEnabled;
        logger.info("pipeFileReceiverFsyncEnabled is set to {}.", (Object)pipeFileReceiverFsyncEnabled);
    }

    public int getPipeDataStructureTabletRowSize() {
        return this.pipeDataStructureTabletRowSize;
    }

    public void setPipeDataStructureTabletRowSize(int pipeDataStructureTabletRowSize) {
        if (this.pipeDataStructureTabletRowSize == pipeDataStructureTabletRowSize) {
            return;
        }
        this.pipeDataStructureTabletRowSize = pipeDataStructureTabletRowSize;
        logger.info("pipeDataStructureTabletRowSize is set to {}.", (Object)pipeDataStructureTabletRowSize);
    }

    public int getPipeDataStructureTabletSizeInBytes() {
        return this.pipeDataStructureTabletSizeInBytes;
    }

    public void setPipeDataStructureTabletSizeInBytes(int pipeDataStructureTabletSizeInBytes) {
        if (this.pipeDataStructureTabletSizeInBytes == pipeDataStructureTabletSizeInBytes) {
            return;
        }
        this.pipeDataStructureTabletSizeInBytes = pipeDataStructureTabletSizeInBytes;
        logger.info("pipeDataStructureTabletSizeInBytes is set to {}.", (Object)pipeDataStructureTabletSizeInBytes);
    }

    public double getPipeDataStructureTabletMemoryBlockAllocationRejectThreshold() {
        return this.pipeDataStructureTabletMemoryBlockAllocationRejectThreshold;
    }

    public void setPipeDataStructureTabletMemoryBlockAllocationRejectThreshold(double pipeDataStructureTabletMemoryBlockAllocationRejectThreshold) {
        if (this.pipeDataStructureTabletMemoryBlockAllocationRejectThreshold == pipeDataStructureTabletMemoryBlockAllocationRejectThreshold) {
            return;
        }
        this.pipeDataStructureTabletMemoryBlockAllocationRejectThreshold = pipeDataStructureTabletMemoryBlockAllocationRejectThreshold;
        logger.info("pipeDataStructureTabletMemoryBlockAllocationRejectThreshold is set to {}.", (Object)pipeDataStructureTabletMemoryBlockAllocationRejectThreshold);
    }

    public double getPipeDataStructureTsFileMemoryBlockAllocationRejectThreshold() {
        return this.pipeDataStructureTsFileMemoryBlockAllocationRejectThreshold;
    }

    public void setPipeDataStructureTsFileMemoryBlockAllocationRejectThreshold(double pipeDataStructureTsFileMemoryBlockAllocationRejectThreshold) {
        if (this.pipeDataStructureTsFileMemoryBlockAllocationRejectThreshold == pipeDataStructureTsFileMemoryBlockAllocationRejectThreshold) {
            return;
        }
        this.pipeDataStructureTsFileMemoryBlockAllocationRejectThreshold = pipeDataStructureTsFileMemoryBlockAllocationRejectThreshold;
        logger.info("pipeDataStructureTsFileMemoryBlockAllocationRejectThreshold is set to {}.", (Object)pipeDataStructureTsFileMemoryBlockAllocationRejectThreshold);
    }

    public boolean isPipeEnableMemoryChecked() {
        return this.isPipeEnableMemoryCheck;
    }

    public void setIsPipeEnableMemoryChecked(boolean isPipeEnableMemoryChecked) {
        if (this.isPipeEnableMemoryCheck == isPipeEnableMemoryChecked) {
            return;
        }
        this.isPipeEnableMemoryCheck = isPipeEnableMemoryChecked;
        logger.info("isPipeEnableMemoryChecked is set to {}.", (Object)isPipeEnableMemoryChecked);
    }

    public long getPipeInsertNodeQueueMemory() {
        return this.pipeInsertNodeQueueMemory;
    }

    public void setPipeInsertNodeQueueMemory(long pipeInsertNodeQueueMemory) {
        if (this.pipeInsertNodeQueueMemory == pipeInsertNodeQueueMemory) {
            return;
        }
        this.pipeInsertNodeQueueMemory = pipeInsertNodeQueueMemory;
        logger.info("pipeInsertNodeQueueMemory is set to {}.", (Object)pipeInsertNodeQueueMemory);
    }

    public long getPipeTsFileParserMemory() {
        return this.pipeTsFileParserMemory;
    }

    public void setPipeTsFileParserMemory(long pipeTsFileParserMemory) {
        if (this.pipeTsFileParserMemory == pipeTsFileParserMemory) {
            return;
        }
        this.pipeTsFileParserMemory = pipeTsFileParserMemory;
        logger.info("pipeTsFileParserMemory is set to {}.", (Object)pipeTsFileParserMemory);
    }

    public long getPipeSinkBatchMemoryInsertNode() {
        return this.pipeSinkBatchMemoryInsertNode;
    }

    public void setPipeSinkBatchMemoryInsertNode(long pipeSinkBatchMemoryInsertNode) {
        if (this.pipeSinkBatchMemoryInsertNode == pipeSinkBatchMemoryInsertNode) {
            return;
        }
        this.pipeSinkBatchMemoryInsertNode = pipeSinkBatchMemoryInsertNode;
        logger.info("pipeSinkBatchMemoryInsertNode is set to {}.", (Object)pipeSinkBatchMemoryInsertNode);
    }

    public long getPipeSinkBatchMemoryTsFile() {
        return this.pipeSinkBatchMemoryTsFile;
    }

    public void setPipeSinkBatchMemoryTsFile(long pipeSinkBatchMemoryTsFile) {
        if (this.pipeSinkBatchMemoryTsFile == pipeSinkBatchMemoryTsFile) {
            return;
        }
        this.pipeSinkBatchMemoryTsFile = pipeSinkBatchMemoryTsFile;
        logger.info("pipeSinkBatchMemoryTsFile is set to {}.", (Object)pipeSinkBatchMemoryTsFile);
    }

    public long getPipeSendTsFileReadBuffer() {
        return this.pipeSendTsFileReadBuffer;
    }

    public void setPipeSendTsFileReadBuffer(long pipeSendTsFileReadBuffer) {
        if (this.pipeSendTsFileReadBuffer == pipeSendTsFileReadBuffer) {
            return;
        }
        this.pipeSendTsFileReadBuffer = pipeSendTsFileReadBuffer;
        logger.info("pipeSendTsFileReadBuffer is set to {}.", (Object)pipeSendTsFileReadBuffer);
    }

    public double getPipeReservedMemoryPercentage() {
        return this.pipeReservedMemoryPercentage;
    }

    public void setPipeReservedMemoryPercentage(double pipeReservedMemoryPercentage) {
        if (this.pipeReservedMemoryPercentage == pipeReservedMemoryPercentage) {
            return;
        }
        this.pipeReservedMemoryPercentage = pipeReservedMemoryPercentage;
        logger.info("pipeReservedMemoryPercentage is set to {}.", (Object)pipeReservedMemoryPercentage);
    }

    public long getPipeMinimumReceiverMemory() {
        return this.pipeMinimumReceiverMemory;
    }

    public void setPipeMinimumReceiverMemory(long pipeMinimumReceiverMemory) {
        if (this.pipeMinimumReceiverMemory == pipeMinimumReceiverMemory) {
            return;
        }
        this.pipeMinimumReceiverMemory = pipeMinimumReceiverMemory;
        logger.info("pipeMinimumReceiverMemory is set to {}.", (Object)pipeMinimumReceiverMemory);
    }

    public double getPipeTotalFloatingMemoryProportion() {
        return this.pipeTotalFloatingMemoryProportion;
    }

    public void setPipeTotalFloatingMemoryProportion(double pipeTotalFloatingMemoryProportion) {
        if (this.pipeTotalFloatingMemoryProportion == pipeTotalFloatingMemoryProportion) {
            return;
        }
        this.pipeTotalFloatingMemoryProportion = pipeTotalFloatingMemoryProportion;
        logger.info("pipeTotalFloatingMemoryProportion is set to {}.", (Object)pipeTotalFloatingMemoryProportion);
    }

    public int getPipeSourceAssignerDisruptorRingBufferSize() {
        return this.pipeSourceAssignerDisruptorRingBufferSize;
    }

    public void setPipeSourceAssignerDisruptorRingBufferSize(int pipeSourceAssignerDisruptorRingBufferSize) {
        if (this.pipeSourceAssignerDisruptorRingBufferSize == pipeSourceAssignerDisruptorRingBufferSize) {
            return;
        }
        this.pipeSourceAssignerDisruptorRingBufferSize = pipeSourceAssignerDisruptorRingBufferSize;
        logger.info("pipeSourceAssignerDisruptorRingBufferSize is set to {}.", (Object)pipeSourceAssignerDisruptorRingBufferSize);
    }

    public long getPipeSourceAssignerDisruptorRingBufferEntrySizeInBytes() {
        return this.pipeSourceAssignerDisruptorRingBufferEntrySizeInBytes;
    }

    public void setPipeSourceAssignerDisruptorRingBufferEntrySizeInBytes(long pipeSourceAssignerDisruptorRingBufferEntrySize) {
        if (this.pipeSourceAssignerDisruptorRingBufferEntrySizeInBytes == pipeSourceAssignerDisruptorRingBufferEntrySize) {
            return;
        }
        this.pipeSourceAssignerDisruptorRingBufferEntrySizeInBytes = pipeSourceAssignerDisruptorRingBufferEntrySize;
        logger.info("pipeSourceAssignerDisruptorRingBufferEntrySize is set to {}.", (Object)pipeSourceAssignerDisruptorRingBufferEntrySize);
    }

    public long getPipeSourceMatcherCacheSize() {
        return this.pipeSourceMatcherCacheSize;
    }

    public void setPipeSourceMatcherCacheSize(long pipeSourceMatcherCacheSize) {
        if (this.pipeSourceMatcherCacheSize == pipeSourceMatcherCacheSize) {
            return;
        }
        this.pipeSourceMatcherCacheSize = pipeSourceMatcherCacheSize;
        logger.info("pipeExtractorMatcherCacheSize is set to {}.", (Object)pipeSourceMatcherCacheSize);
    }

    public int getPipeSinkHandshakeTimeoutMs() {
        return this.pipeSinkHandshakeTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPipeSinkHandshakeTimeoutMs(long pipeSinkHandshakeTimeoutMs) {
        int fPipeConnectorHandshakeTimeoutMs = this.pipeSinkHandshakeTimeoutMs;
        try {
            this.pipeSinkHandshakeTimeoutMs = Math.toIntExact(pipeSinkHandshakeTimeoutMs);
        }
        catch (ArithmeticException e) {
            this.pipeSinkHandshakeTimeoutMs = Integer.MAX_VALUE;
            logger.warn("Given pipe connector handshake timeout is too large, set to {} ms.", (Object)Integer.MAX_VALUE);
        }
        finally {
            if (fPipeConnectorHandshakeTimeoutMs != this.pipeSinkHandshakeTimeoutMs) {
                logger.info("pipeSinkHandshakeTimeoutMs is set to {}.", (Object)this.pipeSinkHandshakeTimeoutMs);
            }
        }
    }

    public int getPipeConnectorTransferTimeoutMs() {
        return this.pipeConnectorTransferTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPipeConnectorTransferTimeoutMs(long pipeConnectorTransferTimeoutMs) {
        int fPipeConnectorTransferTimeoutMs = this.pipeConnectorTransferTimeoutMs;
        try {
            this.pipeConnectorTransferTimeoutMs = Math.toIntExact(pipeConnectorTransferTimeoutMs);
        }
        catch (ArithmeticException e) {
            this.pipeConnectorTransferTimeoutMs = Integer.MAX_VALUE;
            logger.warn("Given pipe connector transfer timeout is too large, set to {} ms.", (Object)Integer.MAX_VALUE);
        }
        finally {
            if (fPipeConnectorTransferTimeoutMs != this.pipeConnectorTransferTimeoutMs) {
                logger.info("pipeConnectorTransferTimeoutMs is set to {}.", (Object)pipeConnectorTransferTimeoutMs);
            }
        }
    }

    public int getPipeConnectorReadFileBufferSize() {
        return this.pipeConnectorReadFileBufferSize;
    }

    public void setPipeConnectorReadFileBufferSize(int pipeConnectorReadFileBufferSize) {
        if (this.pipeConnectorReadFileBufferSize == pipeConnectorReadFileBufferSize) {
            return;
        }
        this.pipeConnectorReadFileBufferSize = pipeConnectorReadFileBufferSize;
        logger.info("pipeConnectorReadFileBufferSize is set to {}.", (Object)pipeConnectorReadFileBufferSize);
    }

    public boolean isPipeConnectorReadFileBufferMemoryControlEnabled() {
        return this.isPipeConnectorReadFileBufferMemoryControlEnabled;
    }

    public void setIsPipeConnectorReadFileBufferMemoryControlEnabled(boolean isPipeConnectorReadFileBufferMemoryControlEnabled) {
        if (this.isPipeConnectorReadFileBufferMemoryControlEnabled == isPipeConnectorReadFileBufferMemoryControlEnabled) {
            return;
        }
        this.isPipeConnectorReadFileBufferMemoryControlEnabled = isPipeConnectorReadFileBufferMemoryControlEnabled;
        logger.info("isPipeConnectorReadFileBufferMemoryControlEnabled is set to {}.", (Object)isPipeConnectorReadFileBufferMemoryControlEnabled);
    }

    public void setPipeConnectorRPCThriftCompressionEnabled(boolean pipeConnectorRPCThriftCompressionEnabled) {
        if (this.isPipeConnectorReadFileBufferMemoryControlEnabled == pipeConnectorRPCThriftCompressionEnabled) {
            return;
        }
        this.pipeConnectorRPCThriftCompressionEnabled = pipeConnectorRPCThriftCompressionEnabled;
        logger.info("pipeConnectorRPCThriftCompressionEnabled is set to {}.", (Object)pipeConnectorRPCThriftCompressionEnabled);
    }

    public boolean isPipeConnectorRPCThriftCompressionEnabled() {
        return this.pipeConnectorRPCThriftCompressionEnabled;
    }

    public void setPipeAsyncSinkForcedRetryTsFileEventQueueSize(int pipeAsyncSinkForcedRetryTsFileEventQueueSize) {
        if (this.pipeAsyncSinkForcedRetryTsFileEventQueueSize == pipeAsyncSinkForcedRetryTsFileEventQueueSize) {
            return;
        }
        this.pipeAsyncSinkForcedRetryTsFileEventQueueSize = pipeAsyncSinkForcedRetryTsFileEventQueueSize;
        logger.info("pipeAsyncSinkForcedRetryTsFileEventQueueSize is set to {}.", (Object)pipeAsyncSinkForcedRetryTsFileEventQueueSize);
    }

    public int getPipeAsyncSinkForcedRetryTsFileEventQueueSize() {
        return this.pipeAsyncSinkForcedRetryTsFileEventQueueSize;
    }

    public void setPipeAsyncSinkForcedRetryTabletEventQueueSize(int pipeAsyncSinkForcedRetryTabletEventQueueSize) {
        if (this.pipeAsyncSinkForcedRetryTabletEventQueueSize == pipeAsyncSinkForcedRetryTabletEventQueueSize) {
            return;
        }
        this.pipeAsyncSinkForcedRetryTabletEventQueueSize = pipeAsyncSinkForcedRetryTabletEventQueueSize;
        logger.info("pipeAsyncSinkForcedRetryTabletEventQueueSize is set to {}.", (Object)pipeAsyncSinkForcedRetryTabletEventQueueSize);
    }

    public int getPipeAsyncSinkForcedRetryTabletEventQueueSize() {
        return this.pipeAsyncSinkForcedRetryTabletEventQueueSize;
    }

    public void setPipeAsyncSinkForcedRetryTotalEventQueueSize(int pipeAsyncSinkForcedRetryTotalEventQueueSize) {
        if (this.pipeAsyncSinkForcedRetryTotalEventQueueSize == pipeAsyncSinkForcedRetryTotalEventQueueSize) {
            return;
        }
        this.pipeAsyncSinkForcedRetryTotalEventQueueSize = pipeAsyncSinkForcedRetryTotalEventQueueSize;
        logger.info("pipeAsyncSinkForcedRetryTotalEventQueueSize is set to {}.", (Object)pipeAsyncSinkForcedRetryTotalEventQueueSize);
    }

    public int getPipeAsyncSinkForcedRetryTotalEventQueueSize() {
        return this.pipeAsyncSinkForcedRetryTotalEventQueueSize;
    }

    public void setPipeAsyncConnectorMaxRetryExecutionTimeMsPerCall(long pipeAsyncConnectorMaxRetryExecutionTimeMsPerCall) {
        if (this.pipeAsyncConnectorMaxRetryExecutionTimeMsPerCall == pipeAsyncConnectorMaxRetryExecutionTimeMsPerCall) {
            return;
        }
        this.pipeAsyncConnectorMaxRetryExecutionTimeMsPerCall = pipeAsyncConnectorMaxRetryExecutionTimeMsPerCall;
        logger.info("pipeAsyncConnectorMaxRetryExecutionTimeMsPerCall is set to {}.", (Object)pipeAsyncConnectorMaxRetryExecutionTimeMsPerCall);
    }

    public long getPipeAsyncConnectorMaxRetryExecutionTimeMsPerCall() {
        return this.pipeAsyncConnectorMaxRetryExecutionTimeMsPerCall;
    }

    public int getPipeAsyncConnectorSelectorNumber() {
        return this.pipeAsyncConnectorSelectorNumber;
    }

    public void setPipeAsyncConnectorSelectorNumber(int pipeAsyncConnectorSelectorNumber) {
        if (pipeAsyncConnectorSelectorNumber <= 0) {
            logger.info("pipeAsyncConnectorSelectorNumber should be greater than 0, configuring it not to change.");
            return;
        }
        if (this.pipeAsyncConnectorSelectorNumber == (pipeAsyncConnectorSelectorNumber = Math.max(4, pipeAsyncConnectorSelectorNumber))) {
            return;
        }
        this.pipeAsyncConnectorSelectorNumber = pipeAsyncConnectorSelectorNumber;
        logger.info("pipeAsyncConnectorSelectorNumber is set to {}.", (Object)pipeAsyncConnectorSelectorNumber);
    }

    public int getPipeAsyncConnectorMaxClientNumber() {
        return this.pipeAsyncConnectorMaxClientNumber;
    }

    public void setPipeAsyncConnectorMaxClientNumber(int pipeAsyncConnectorMaxClientNumber) {
        if (pipeAsyncConnectorMaxClientNumber <= 0) {
            logger.info(" pipeAsyncConnectorMaxClientNumber should be greater than 0, configuring it not to change.");
            return;
        }
        if (this.pipeAsyncConnectorMaxClientNumber == (pipeAsyncConnectorMaxClientNumber = Math.max(32, pipeAsyncConnectorMaxClientNumber))) {
            return;
        }
        this.pipeAsyncConnectorMaxClientNumber = pipeAsyncConnectorMaxClientNumber;
        logger.info("pipeAsyncConnectorMaxClientNumber is set to {}.", (Object)pipeAsyncConnectorMaxClientNumber);
    }

    public int getPipeAsyncConnectorMaxTsFileClientNumber() {
        return this.pipeAsyncConnectorMaxTsFileClientNumber;
    }

    public void setPipeAsyncConnectorMaxTsFileClientNumber(int pipeAsyncConnectorMaxTsFileClientNumber) {
        if (pipeAsyncConnectorMaxTsFileClientNumber <= 0) {
            logger.info("pipeAsyncConnectorMaxTsFileClientNumber should be greater than 0, configuring it not to change.");
            return;
        }
        if (this.pipeAsyncConnectorMaxTsFileClientNumber == (pipeAsyncConnectorMaxTsFileClientNumber = Math.max(16, pipeAsyncConnectorMaxTsFileClientNumber))) {
            return;
        }
        this.pipeAsyncConnectorMaxTsFileClientNumber = pipeAsyncConnectorMaxTsFileClientNumber;
        logger.info("pipeAsyncConnectorMaxClientNumber is set to {}.", (Object)pipeAsyncConnectorMaxTsFileClientNumber);
    }

    public boolean isSeperatedPipeHeartbeatEnabled() {
        return this.isSeperatedPipeHeartbeatEnabled;
    }

    public void setSeperatedPipeHeartbeatEnabled(boolean isSeperatedPipeHeartbeatEnabled) {
        if (this.isSeperatedPipeHeartbeatEnabled == isSeperatedPipeHeartbeatEnabled) {
            return;
        }
        this.isSeperatedPipeHeartbeatEnabled = isSeperatedPipeHeartbeatEnabled;
        logger.info("isSeperatedPipeHeartbeatEnabled is set to {}.", (Object)isSeperatedPipeHeartbeatEnabled);
    }

    public int getPipeHeartbeatIntervalSecondsForCollectingPipeMeta() {
        return this.pipeHeartbeatIntervalSecondsForCollectingPipeMeta;
    }

    public void setPipeHeartbeatIntervalSecondsForCollectingPipeMeta(int pipeHeartbeatIntervalSecondsForCollectingPipeMeta) {
        if (this.pipeHeartbeatIntervalSecondsForCollectingPipeMeta == pipeHeartbeatIntervalSecondsForCollectingPipeMeta) {
            return;
        }
        this.pipeHeartbeatIntervalSecondsForCollectingPipeMeta = pipeHeartbeatIntervalSecondsForCollectingPipeMeta;
        logger.info("pipeHeartbeatIntervalSecondsForCollectingPipeMeta is set to {}.", (Object)pipeHeartbeatIntervalSecondsForCollectingPipeMeta);
    }

    public long getPipeMetaSyncerInitialSyncDelayMinutes() {
        return this.pipeMetaSyncerInitialSyncDelayMinutes;
    }

    public void setPipeMetaSyncerInitialSyncDelayMinutes(long pipeMetaSyncerInitialSyncDelayMinutes) {
        if (this.pipeMetaSyncerInitialSyncDelayMinutes == pipeMetaSyncerInitialSyncDelayMinutes) {
            return;
        }
        this.pipeMetaSyncerInitialSyncDelayMinutes = pipeMetaSyncerInitialSyncDelayMinutes;
        logger.info("pipeMetaSyncerInitialSyncDelayMinutes is set to {}.", (Object)pipeMetaSyncerInitialSyncDelayMinutes);
    }

    public long getPipeMetaSyncerSyncIntervalMinutes() {
        return this.pipeMetaSyncerSyncIntervalMinutes;
    }

    public void setPipeMetaSyncerSyncIntervalMinutes(long pipeMetaSyncerSyncIntervalMinutes) {
        if (this.pipeMetaSyncerSyncIntervalMinutes == pipeMetaSyncerSyncIntervalMinutes) {
            return;
        }
        this.pipeMetaSyncerSyncIntervalMinutes = pipeMetaSyncerSyncIntervalMinutes;
        logger.info("pipeMetaSyncerSyncIntervalMinutes is set to {}.", (Object)pipeMetaSyncerSyncIntervalMinutes);
    }

    public long getPipeMetaSyncerAutoRestartPipeCheckIntervalRound() {
        return this.pipeMetaSyncerAutoRestartPipeCheckIntervalRound;
    }

    public void setPipeMetaSyncerAutoRestartPipeCheckIntervalRound(long pipeMetaSyncerAutoRestartPipeCheckIntervalRound) {
        if (this.pipeMetaSyncerAutoRestartPipeCheckIntervalRound == pipeMetaSyncerAutoRestartPipeCheckIntervalRound) {
            return;
        }
        this.pipeMetaSyncerAutoRestartPipeCheckIntervalRound = pipeMetaSyncerAutoRestartPipeCheckIntervalRound;
        logger.info("pipeMetaSyncerAutoRestartPipeCheckIntervalRound is set to {}.", (Object)pipeMetaSyncerAutoRestartPipeCheckIntervalRound);
    }

    public boolean getPipeAutoRestartEnabled() {
        return this.pipeAutoRestartEnabled;
    }

    public void setPipeAutoRestartEnabled(boolean pipeAutoRestartEnabled) {
        if (this.pipeAutoRestartEnabled == pipeAutoRestartEnabled) {
            return;
        }
        this.pipeAutoRestartEnabled = pipeAutoRestartEnabled;
        logger.info("pipeAutoRestartEnabled is set to {}.", (Object)pipeAutoRestartEnabled);
    }

    public long getPipeConnectorRetryIntervalMs() {
        return this.pipeConnectorRetryIntervalMs;
    }

    public void setPipeConnectorRetryIntervalMs(long pipeConnectorRetryIntervalMs) {
        if (this.pipeConnectorRetryIntervalMs == pipeConnectorRetryIntervalMs) {
            return;
        }
        this.pipeConnectorRetryIntervalMs = pipeConnectorRetryIntervalMs;
        logger.info("pipeConnectorRetryIntervalMs is set to {}", (Object)pipeConnectorRetryIntervalMs);
    }

    public int getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount() {
        return this.pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount;
    }

    public void setPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount(int pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount) {
        if (this.pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount == pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount) {
            return;
        }
        this.pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount = pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount;
        logger.info("pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount is set to {}", (Object)pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount);
    }

    public long getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration() {
        return this.pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration;
    }

    public void setPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration(long pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration) {
        if (this.pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration == pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration) {
            return;
        }
        this.pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration = pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration;
        logger.info("pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration is set to {}", (Object)pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration);
    }

    public int getPipeSubtaskExecutorMaxThreadNum() {
        return this.pipeSubtaskExecutorMaxThreadNum;
    }

    public void setPipeSubtaskExecutorMaxThreadNum(int pipeSubtaskExecutorMaxThreadNum) {
        if (pipeSubtaskExecutorMaxThreadNum <= 0) {
            logger.info("pipeSubtaskExecutorMaxThreadNum should be greater than 0, configuring it not to change.");
            return;
        }
        if (this.pipeSubtaskExecutorMaxThreadNum == (pipeSubtaskExecutorMaxThreadNum = Math.max(5, pipeSubtaskExecutorMaxThreadNum))) {
            return;
        }
        this.pipeSubtaskExecutorMaxThreadNum = pipeSubtaskExecutorMaxThreadNum;
        logger.info("pipeSubtaskExecutorMaxThreadNum is set to {}.", (Object)pipeSubtaskExecutorMaxThreadNum);
    }

    public boolean isPipeRetryLocallyForParallelOrUserConflict() {
        return this.pipeRetryLocallyForParallelOrUserConflict;
    }

    public void setPipeRetryLocallyForParallelOrUserConflict(boolean pipeRetryLocallyForParallelOrUserConflict) {
        if (this.pipeRetryLocallyForParallelOrUserConflict == pipeRetryLocallyForParallelOrUserConflict) {
            return;
        }
        this.pipeRetryLocallyForParallelOrUserConflict = pipeRetryLocallyForParallelOrUserConflict;
        logger.info("pipeRetryLocallyForParallelOrUserConflict is set to {}.", (Object)this.pipeSubtaskExecutorMaxThreadNum);
    }

    public long getPipeSinkSubtaskSleepIntervalInitMs() {
        return this.pipeSinkSubtaskSleepIntervalInitMs;
    }

    public void setPipeSinkSubtaskSleepIntervalInitMs(long pipeSinkSubtaskSleepIntervalInitMs) {
        if (this.pipeSinkSubtaskSleepIntervalInitMs == pipeSinkSubtaskSleepIntervalInitMs) {
            return;
        }
        this.pipeSinkSubtaskSleepIntervalInitMs = pipeSinkSubtaskSleepIntervalInitMs;
        logger.info("pipeSinkSubtaskSleepIntervalInitMs is set to {}.", (Object)pipeSinkSubtaskSleepIntervalInitMs);
    }

    public long getPipeSinkSubtaskSleepIntervalMaxMs() {
        return this.pipeSinkSubtaskSleepIntervalMaxMs;
    }

    public void setPipeSinkSubtaskSleepIntervalMaxMs(long pipeSinkSubtaskSleepIntervalMaxMs) {
        if (this.pipeSinkSubtaskSleepIntervalMaxMs == pipeSinkSubtaskSleepIntervalMaxMs) {
            return;
        }
        this.pipeSinkSubtaskSleepIntervalMaxMs = pipeSinkSubtaskSleepIntervalMaxMs;
        logger.info("pipeSinkSubtaskSleepIntervalMaxMs is set to {}.", (Object)pipeSinkSubtaskSleepIntervalMaxMs);
    }

    public long getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs() {
        return this.pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs;
    }

    public void setPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs(long pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs) {
        if (this.pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs == pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs) {
            return;
        }
        this.pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs = pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs;
        logger.info("pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs is set to {}", (Object)pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs);
    }

    public long getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds() {
        return this.pipeSubtaskExecutorCronHeartbeatEventIntervalSeconds;
    }

    public void setPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds(long pipeSubtaskExecutorCronHeartbeatEventIntervalSeconds) {
        if (this.pipeSubtaskExecutorCronHeartbeatEventIntervalSeconds == pipeSubtaskExecutorCronHeartbeatEventIntervalSeconds) {
            return;
        }
        this.pipeSubtaskExecutorCronHeartbeatEventIntervalSeconds = pipeSubtaskExecutorCronHeartbeatEventIntervalSeconds;
        logger.info("pipeSubtaskExecutorCronHeartbeatEventIntervalSeconds is set to {}.", (Object)pipeSubtaskExecutorCronHeartbeatEventIntervalSeconds);
    }

    public long getPipeMaxWaitFinishTime() {
        return this.pipeMaxWaitFinishTime;
    }

    public void setPipeMaxWaitFinishTime(long pipeMaxWaitFinishTime) {
        if (this.pipeMaxWaitFinishTime == pipeMaxWaitFinishTime) {
            return;
        }
        this.pipeMaxWaitFinishTime = pipeMaxWaitFinishTime;
        logger.info("pipeMaxWaitFinishTime is set to {}.", (Object)pipeMaxWaitFinishTime);
    }

    public int getPipeRealTimeQueuePollTsFileThreshold() {
        return this.pipeRealTimeQueuePollTsFileThreshold;
    }

    public void setPipeRealTimeQueuePollTsFileThreshold(int pipeRealTimeQueuePollTsFileThreshold) {
        if (this.pipeRealTimeQueuePollTsFileThreshold == pipeRealTimeQueuePollTsFileThreshold) {
            return;
        }
        this.pipeRealTimeQueuePollTsFileThreshold = pipeRealTimeQueuePollTsFileThreshold;
        logger.info("pipeRealTimeQueuePollTsFileThreshold is {}", (Object)pipeRealTimeQueuePollTsFileThreshold);
    }

    public int getPipeRealTimeQueuePollHistoricalTsFileThreshold() {
        return this.pipeRealTimeQueuePollHistoricalTsFileThreshold;
    }

    public void setPipeRealTimeQueuePollHistoricalTsFileThreshold(int pipeRealTimeQueuePollHistoricalTsFileThreshold) {
        if (this.pipeRealTimeQueuePollHistoricalTsFileThreshold == pipeRealTimeQueuePollHistoricalTsFileThreshold) {
            return;
        }
        this.pipeRealTimeQueuePollHistoricalTsFileThreshold = pipeRealTimeQueuePollHistoricalTsFileThreshold;
        logger.info("pipeRealTimeQueuePollHistoricalTsFileThreshold is set to {}", (Object)pipeRealTimeQueuePollHistoricalTsFileThreshold);
    }

    public int getPipeRealTimeQueueMaxWaitingTsFileSize() {
        return this.pipeRealTimeQueueMaxWaitingTsFileSize;
    }

    public void setPipeRealTimeQueueMaxWaitingTsFileSize(int pipeRealTimeQueueMaxWaitingTsFileSize) {
        if (this.pipeRealTimeQueueMaxWaitingTsFileSize == pipeRealTimeQueueMaxWaitingTsFileSize) {
            return;
        }
        this.pipeRealTimeQueueMaxWaitingTsFileSize = pipeRealTimeQueueMaxWaitingTsFileSize;
        logger.info("pipeRealTimeQueueMaxWaitingTsFileSize is set to {}.", (Object)pipeRealTimeQueueMaxWaitingTsFileSize);
    }

    public void setPipeAirGapReceiverEnabled(boolean pipeAirGapReceiverEnabled) {
        if (pipeAirGapReceiverEnabled == this.pipeAirGapReceiverEnabled) {
            return;
        }
        this.pipeAirGapReceiverEnabled = pipeAirGapReceiverEnabled;
        logger.info("pipeAirGapReceiverEnabled is set to {}.", (Object)pipeAirGapReceiverEnabled);
    }

    public boolean getPipeAirGapReceiverEnabled() {
        return this.pipeAirGapReceiverEnabled;
    }

    public void setPipeAirGapReceiverPort(int pipeAirGapReceiverPort) {
        if (pipeAirGapReceiverPort == this.pipeAirGapReceiverPort) {
            return;
        }
        this.pipeAirGapReceiverPort = pipeAirGapReceiverPort;
        logger.info("pipeAirGapReceiverPort is set to {}.", (Object)pipeAirGapReceiverPort);
    }

    public int getPipeAirGapReceiverPort() {
        return this.pipeAirGapReceiverPort;
    }

    public void setPipeReceiverLoginPeriodicVerificationIntervalMs(long pipeReceiverLoginPeriodicVerificationIntervalMs) {
        if (this.pipeReceiverLoginPeriodicVerificationIntervalMs == pipeReceiverLoginPeriodicVerificationIntervalMs) {
            return;
        }
        this.pipeReceiverLoginPeriodicVerificationIntervalMs = pipeReceiverLoginPeriodicVerificationIntervalMs;
        logger.info("pipeReceiverLoginPeriodicVerificationIntervalMs is set to {}", (Object)pipeReceiverLoginPeriodicVerificationIntervalMs);
    }

    public long getPipeReceiverLoginPeriodicVerificationIntervalMs() {
        return this.pipeReceiverLoginPeriodicVerificationIntervalMs;
    }

    public void setPipeReceiverActualToEstimatedMemoryRatio(double pipeReceiverActualToEstimatedMemoryRatio) {
        if (this.pipeReceiverActualToEstimatedMemoryRatio == pipeReceiverActualToEstimatedMemoryRatio) {
            return;
        }
        this.pipeReceiverActualToEstimatedMemoryRatio = pipeReceiverActualToEstimatedMemoryRatio;
        logger.info("pipeReceiverActualToEstimatedMemoryRatio is set to {}", (Object)pipeReceiverActualToEstimatedMemoryRatio);
    }

    public double getPipeReceiverActualToEstimatedMemoryRatio() {
        return this.pipeReceiverActualToEstimatedMemoryRatio;
    }

    public void setPipeReceiverReqDecompressedMaxLengthInBytes(int pipeReceiverReqDecompressedMaxLengthInBytes) {
        if (this.pipeReceiverReqDecompressedMaxLengthInBytes == pipeReceiverReqDecompressedMaxLengthInBytes) {
            return;
        }
        this.pipeReceiverReqDecompressedMaxLengthInBytes = pipeReceiverReqDecompressedMaxLengthInBytes;
        logger.info("pipeReceiverReqDecompressedMaxLengthInBytes is set to {}.", (Object)pipeReceiverReqDecompressedMaxLengthInBytes);
    }

    public boolean isPipeReceiverLoadConversionEnabled() {
        return this.pipeReceiverLoadConversionEnabled;
    }

    public void setPipeReceiverLoadConversionEnabled(boolean pipeReceiverLoadConversionEnabled) {
        if (this.pipeReceiverLoadConversionEnabled == pipeReceiverLoadConversionEnabled) {
            return;
        }
        this.pipeReceiverLoadConversionEnabled = pipeReceiverLoadConversionEnabled;
        logger.info("pipeReceiverConversionEnabled is set to {}.", (Object)pipeReceiverLoadConversionEnabled);
    }

    public long getPipePeriodicalLogMinIntervalSeconds() {
        return this.pipePeriodicalLogMinIntervalSeconds;
    }

    public void setPipePeriodicalLogMinIntervalSeconds(long pipePeriodicalLogMinIntervalSeconds) {
        if (this.pipePeriodicalLogMinIntervalSeconds == pipePeriodicalLogMinIntervalSeconds) {
            return;
        }
        this.pipePeriodicalLogMinIntervalSeconds = pipePeriodicalLogMinIntervalSeconds;
        logger.info("pipePeriodicalLogMinIntervalSeconds is set to {}.", (Object)pipePeriodicalLogMinIntervalSeconds);
    }

    public long getPipeLoggerCacheMaxSizeInBytes() {
        return this.pipeLoggerCacheMaxSizeInBytes;
    }

    public void setPipeLoggerCacheMaxSizeInBytes(long pipeLoggerCacheMaxSizeInBytes) {
        if (this.pipeLoggerCacheMaxSizeInBytes == pipeLoggerCacheMaxSizeInBytes) {
            return;
        }
        this.pipeLoggerCacheMaxSizeInBytes = pipeLoggerCacheMaxSizeInBytes;
        logger.info("pipeLoggerCacheMaxSizeInBytes is set to {}.", (Object)pipeLoggerCacheMaxSizeInBytes);
    }

    public int getPipeReceiverReqDecompressedMaxLengthInBytes() {
        return this.pipeReceiverReqDecompressedMaxLengthInBytes;
    }

    public double getPipeMetaReportMaxLogNumPerRound() {
        return this.pipeMetaReportMaxLogNumPerRound;
    }

    public void setPipeMetaReportMaxLogNumPerRound(double pipeMetaReportMaxLogNumPerRound) {
        if (this.pipeMetaReportMaxLogNumPerRound == pipeMetaReportMaxLogNumPerRound) {
            return;
        }
        this.pipeMetaReportMaxLogNumPerRound = pipeMetaReportMaxLogNumPerRound;
        logger.info("pipeMetaReportMaxLogNumPerRound is set to {}", (Object)pipeMetaReportMaxLogNumPerRound);
    }

    public int getPipeMetaReportMaxLogIntervalRounds() {
        return this.pipeMetaReportMaxLogIntervalRounds;
    }

    public void setPipeMetaReportMaxLogIntervalRounds(int pipeMetaReportMaxLogIntervalRounds) {
        if (this.pipeMetaReportMaxLogIntervalRounds == pipeMetaReportMaxLogIntervalRounds) {
            return;
        }
        this.pipeMetaReportMaxLogIntervalRounds = pipeMetaReportMaxLogIntervalRounds;
        logger.info("pipeMetaReportMaxLogIntervalRounds is set to {}", (Object)pipeMetaReportMaxLogIntervalRounds);
    }

    public int getPipeTsFilePinMaxLogNumPerRound() {
        return this.pipeTsFilePinMaxLogNumPerRound;
    }

    public void setPipeTsFilePinMaxLogNumPerRound(int pipeTsFilePinMaxLogNumPerRound) {
        if (this.pipeTsFilePinMaxLogNumPerRound == pipeTsFilePinMaxLogNumPerRound) {
            return;
        }
        this.pipeTsFilePinMaxLogNumPerRound = pipeTsFilePinMaxLogNumPerRound;
        logger.info("pipeTsFilePinMaxLogNumPerRound is set to {}", (Object)pipeTsFilePinMaxLogNumPerRound);
    }

    public int getPipeTsFilePinMaxLogIntervalRounds() {
        return this.pipeTsFilePinMaxLogIntervalRounds;
    }

    public void setPipeTsFilePinMaxLogIntervalRounds(int pipeTsFilePinMaxLogIntervalRounds) {
        if (this.pipeTsFilePinMaxLogIntervalRounds == pipeTsFilePinMaxLogIntervalRounds) {
            return;
        }
        this.pipeTsFilePinMaxLogIntervalRounds = pipeTsFilePinMaxLogIntervalRounds;
        logger.info("pipeTsFilePinMaxLogIntervalRounds is set to {}", (Object)pipeTsFilePinMaxLogIntervalRounds);
    }

    public boolean getPipeMemoryManagementEnabled() {
        return this.pipeMemoryManagementEnabled;
    }

    public void setPipeMemoryManagementEnabled(boolean pipeMemoryManagementEnabled) {
        if (this.pipeMemoryManagementEnabled == pipeMemoryManagementEnabled) {
            return;
        }
        this.pipeMemoryManagementEnabled = pipeMemoryManagementEnabled;
        logger.info("pipeMemoryManagementEnabled is set to {}", (Object)pipeMemoryManagementEnabled);
    }

    public long getPipeMemoryAllocateForTsFileSequenceReaderInBytes() {
        return this.pipeMemoryAllocateForTsFileSequenceReaderInBytes;
    }

    public void setPipeMemoryAllocateForTsFileSequenceReaderInBytes(long pipeMemoryAllocateForTsFileSequenceReaderInBytes) {
        if (this.pipeMemoryAllocateForTsFileSequenceReaderInBytes == pipeMemoryAllocateForTsFileSequenceReaderInBytes) {
            return;
        }
        this.pipeMemoryAllocateForTsFileSequenceReaderInBytes = pipeMemoryAllocateForTsFileSequenceReaderInBytes;
        logger.info("pipeMemoryAllocateForTsFileSequenceReaderInBytes is set to {}", (Object)pipeMemoryAllocateForTsFileSequenceReaderInBytes);
    }

    public long getPipeMemoryExpanderIntervalSeconds() {
        return this.pipeMemoryExpanderIntervalSeconds;
    }

    public void setPipeMemoryExpanderIntervalSeconds(long pipeMemoryExpanderIntervalSeconds) {
        if (this.pipeMemoryExpanderIntervalSeconds == pipeMemoryExpanderIntervalSeconds) {
            return;
        }
        this.pipeMemoryExpanderIntervalSeconds = pipeMemoryExpanderIntervalSeconds;
        logger.info("pipeMemoryExpanderIntervalSeconds is set to {}", (Object)pipeMemoryExpanderIntervalSeconds);
    }

    public long getPipeCheckMemoryEnoughIntervalMs() {
        return this.pipeCheckMemoryEnoughIntervalMs;
    }

    public void setPipeCheckMemoryEnoughIntervalMs(long pipeCheckMemoryEnoughIntervalMs) {
        if (this.pipeCheckMemoryEnoughIntervalMs == pipeCheckMemoryEnoughIntervalMs) {
            return;
        }
        this.pipeCheckMemoryEnoughIntervalMs = pipeCheckMemoryEnoughIntervalMs;
        logger.info("pipeCheckMemoryEnoughIntervalMs is set to {}", (Object)pipeCheckMemoryEnoughIntervalMs);
    }

    public int getPipeMemoryAllocateMaxRetries() {
        return this.pipeMemoryAllocateMaxRetries;
    }

    public void setPipeMemoryAllocateMaxRetries(int pipeMemoryAllocateMaxRetries) {
        if (this.pipeMemoryAllocateMaxRetries == pipeMemoryAllocateMaxRetries) {
            return;
        }
        this.pipeMemoryAllocateMaxRetries = pipeMemoryAllocateMaxRetries;
        logger.info("pipeMemoryAllocateMaxRetries is set to {}", (Object)pipeMemoryAllocateMaxRetries);
    }

    public long getPipeMemoryAllocateRetryIntervalInMs() {
        return this.pipeMemoryAllocateRetryIntervalMs;
    }

    public void setPipeMemoryAllocateRetryIntervalInMs(long pipeMemoryAllocateRetryIntervalMs) {
        if (this.pipeMemoryAllocateRetryIntervalMs == pipeMemoryAllocateRetryIntervalMs) {
            return;
        }
        this.pipeMemoryAllocateRetryIntervalMs = pipeMemoryAllocateRetryIntervalMs;
        logger.info("pipeMemoryAllocateRetryIntervalMs is set to {}", (Object)pipeMemoryAllocateRetryIntervalMs);
    }

    public long getPipeMemoryAllocateMinSizeInBytes() {
        return this.pipeMemoryAllocateMinSizeInBytes;
    }

    public void setPipeMemoryAllocateMinSizeInBytes(long pipeMemoryAllocateMinSizeInBytes) {
        if (this.pipeMemoryAllocateMinSizeInBytes == pipeMemoryAllocateMinSizeInBytes) {
            return;
        }
        this.pipeMemoryAllocateMinSizeInBytes = pipeMemoryAllocateMinSizeInBytes;
        logger.info("pipeMemoryAllocateMinSizeInBytes is set to {}", (Object)pipeMemoryAllocateMinSizeInBytes);
    }

    public float getPipeLeaderCacheMemoryUsagePercentage() {
        return this.pipeLeaderCacheMemoryUsagePercentage;
    }

    public void setPipeLeaderCacheMemoryUsagePercentage(float pipeLeaderCacheMemoryUsagePercentage) {
        if (this.pipeLeaderCacheMemoryUsagePercentage == pipeLeaderCacheMemoryUsagePercentage) {
            return;
        }
        this.pipeLeaderCacheMemoryUsagePercentage = pipeLeaderCacheMemoryUsagePercentage;
        logger.info("pipeLeaderCacheMemoryUsagePercentage is set to {}", (Object)Float.valueOf(pipeLeaderCacheMemoryUsagePercentage));
    }

    public long getPipeMaxReaderChunkSize() {
        return this.pipeMaxReaderChunkSize;
    }

    public void setPipeMaxReaderChunkSize(long pipeMaxReaderChunkSize) {
        if (this.pipeMaxReaderChunkSize == pipeMaxReaderChunkSize) {
            return;
        }
        this.pipeMaxReaderChunkSize = pipeMaxReaderChunkSize;
        logger.info("pipeMaxAlignedSeriesChunkSizeInOneBatch is set to {}", (Object)pipeMaxReaderChunkSize);
    }

    public long getPipeListeningQueueTransferSnapshotThreshold() {
        return this.pipeListeningQueueTransferSnapshotThreshold;
    }

    public void setPipeListeningQueueTransferSnapshotThreshold(long pipeListeningQueueTransferSnapshotThreshold) {
        if (this.pipeListeningQueueTransferSnapshotThreshold == pipeListeningQueueTransferSnapshotThreshold) {
            return;
        }
        this.pipeListeningQueueTransferSnapshotThreshold = pipeListeningQueueTransferSnapshotThreshold;
        logger.info("pipeListeningQueueTransferSnapshotThreshold is set to {}", (Object)pipeListeningQueueTransferSnapshotThreshold);
    }

    public int getPipeSnapshotExecutionMaxBatchSize() {
        return this.pipeSnapshotExecutionMaxBatchSize;
    }

    public void setPipeSnapshotExecutionMaxBatchSize(int pipeSnapshotExecutionMaxBatchSize) {
        if (this.pipeSnapshotExecutionMaxBatchSize == pipeSnapshotExecutionMaxBatchSize) {
            return;
        }
        this.pipeSnapshotExecutionMaxBatchSize = pipeSnapshotExecutionMaxBatchSize;
        logger.info("pipeSnapshotExecutionMaxBatchSize is set to {}", (Object)pipeSnapshotExecutionMaxBatchSize);
    }

    public long getPipeRemainingTimeCommitRateAutoSwitchSeconds() {
        return this.pipeRemainingTimeCommitRateAutoSwitchSeconds;
    }

    public void setPipeRemainingTimeCommitRateAutoSwitchSeconds(long pipeRemainingTimeCommitRateAutoSwitchSeconds) {
        if (this.pipeRemainingTimeCommitRateAutoSwitchSeconds == pipeRemainingTimeCommitRateAutoSwitchSeconds) {
            return;
        }
        this.pipeRemainingTimeCommitRateAutoSwitchSeconds = pipeRemainingTimeCommitRateAutoSwitchSeconds;
        logger.info("pipeRemainingTimeCommitRateAutoSwitchSeconds is set to {}", (Object)pipeRemainingTimeCommitRateAutoSwitchSeconds);
    }

    public PipeRateAverage getPipeRemainingTimeCommitRateAverageTime() {
        return this.pipeRemainingTimeCommitRateAverageTime;
    }

    public void setPipeRemainingTimeCommitRateAverageTime(PipeRateAverage pipeRemainingTimeCommitRateAverageTime) {
        if (Objects.equals((Object)this.pipeRemainingTimeCommitRateAverageTime, (Object)pipeRemainingTimeCommitRateAverageTime)) {
            return;
        }
        this.pipeRemainingTimeCommitRateAverageTime = pipeRemainingTimeCommitRateAverageTime;
        logger.info("pipeRemainingTimeCommitRateAverageTime is set to {}", (Object)pipeRemainingTimeCommitRateAverageTime);
    }

    public double getPipeRemainingInsertNodeCountEMAAlpha() {
        return this.pipeRemainingInsertNodeCountEMAAlpha;
    }

    public void setPipeRemainingInsertNodeCountEMAAlpha(double pipeRemainingInsertNodeCountEMAAlpha) {
        if (Objects.equals(this.pipeRemainingInsertNodeCountEMAAlpha, pipeRemainingInsertNodeCountEMAAlpha)) {
            return;
        }
        this.pipeRemainingInsertNodeCountEMAAlpha = pipeRemainingInsertNodeCountEMAAlpha;
        logger.info("pipeRemainingInsertEventCountAverage is set to {}", (Object)pipeRemainingInsertNodeCountEMAAlpha);
    }

    public double getPipeTsFileScanParsingThreshold() {
        return this.pipeTsFileScanParsingThreshold;
    }

    public void setPipeTsFileScanParsingThreshold(double pipeTsFileScanParsingThreshold) {
        if (this.pipeTsFileScanParsingThreshold == pipeTsFileScanParsingThreshold) {
            return;
        }
        this.pipeTsFileScanParsingThreshold = pipeTsFileScanParsingThreshold;
        logger.info("pipeTsFileScanParsingThreshold is set to {}", (Object)pipeTsFileScanParsingThreshold);
    }

    public double getPipeDynamicMemoryHistoryWeight() {
        return this.pipeDynamicMemoryHistoryWeight;
    }

    public void setPipeDynamicMemoryHistoryWeight(double pipeDynamicMemoryHistoryWeight) {
        if (this.pipeDynamicMemoryHistoryWeight == pipeDynamicMemoryHistoryWeight) {
            return;
        }
        this.pipeDynamicMemoryHistoryWeight = pipeDynamicMemoryHistoryWeight;
        logger.info("PipeDynamicMemoryHistoryWeight is set to {}", (Object)pipeDynamicMemoryHistoryWeight);
    }

    public double getPipeDynamicMemoryAdjustmentThreshold() {
        return this.pipeDynamicMemoryAdjustmentThreshold;
    }

    public void setPipeDynamicMemoryAdjustmentThreshold(double pipeDynamicMemoryAdjustmentThreshold) {
        if (this.pipeDynamicMemoryAdjustmentThreshold == pipeDynamicMemoryAdjustmentThreshold) {
            return;
        }
        this.pipeDynamicMemoryAdjustmentThreshold = pipeDynamicMemoryAdjustmentThreshold;
        logger.info("pipeDynamicMemoryAdjustmentThreshold is set to {}", (Object)pipeDynamicMemoryAdjustmentThreshold);
    }

    public double getPipeThresholdAllocationStrategyMaximumMemoryIncrementRatio() {
        return this.pipeThresholdAllocationStrategyMaximumMemoryIncrementRatio;
    }

    public void setPipeThresholdAllocationStrategyMaximumMemoryIncrementRatio(double pipeThresholdAllocationStrategyMaximumMemoryIncrementRatio) {
        if (this.pipeThresholdAllocationStrategyMaximumMemoryIncrementRatio == pipeThresholdAllocationStrategyMaximumMemoryIncrementRatio) {
            return;
        }
        this.pipeThresholdAllocationStrategyMaximumMemoryIncrementRatio = pipeThresholdAllocationStrategyMaximumMemoryIncrementRatio;
        logger.info("pipeThresholdAllocationStrategyMaximumMemoryIncrementRatio is set to {}", (Object)pipeThresholdAllocationStrategyMaximumMemoryIncrementRatio);
    }

    public double getPipeThresholdAllocationStrategyLowUsageThreshold() {
        return this.pipeThresholdAllocationStrategyLowUsageThreshold;
    }

    public void setPipeThresholdAllocationStrategyLowUsageThreshold(double pipeThresholdAllocationStrategyLowUsageThreshold) {
        if (this.pipeThresholdAllocationStrategyLowUsageThreshold == pipeThresholdAllocationStrategyLowUsageThreshold) {
            return;
        }
        this.pipeThresholdAllocationStrategyLowUsageThreshold = pipeThresholdAllocationStrategyLowUsageThreshold;
        logger.info("pipeMemoryBlockLowUsageThreshold is set to {}", (Object)pipeThresholdAllocationStrategyLowUsageThreshold);
    }

    public double getPipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold() {
        return this.pipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold;
    }

    public void setPipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold(double pipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold) {
        if (this.pipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold == pipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold) {
            return;
        }
        this.pipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold = pipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold;
        logger.info("pipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold is set to {}", (Object)pipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold);
    }

    public boolean getPipeTransferTsFileSync() {
        return this.pipeTransferTsFileSync;
    }

    public void setPipeTransferTsFileSync(boolean pipeTransferTsFileSync) {
        if (this.pipeTransferTsFileSync == pipeTransferTsFileSync) {
            return;
        }
        this.pipeTransferTsFileSync = pipeTransferTsFileSync;
        logger.info("pipeTransferTsFileSync is set to {}", (Object)pipeTransferTsFileSync);
    }

    public long getPipeCheckAllSyncClientLiveTimeIntervalMs() {
        return this.pipeCheckAllSyncClientLiveTimeIntervalMs;
    }

    public void setPipeCheckAllSyncClientLiveTimeIntervalMs(long pipeCheckAllSyncClientLiveTimeIntervalMs) {
        if (this.pipeCheckAllSyncClientLiveTimeIntervalMs == pipeCheckAllSyncClientLiveTimeIntervalMs) {
            return;
        }
        this.pipeCheckAllSyncClientLiveTimeIntervalMs = pipeCheckAllSyncClientLiveTimeIntervalMs;
        logger.info("pipeCheckSyncAllClientLiveTimeIntervalMs is set to {}", (Object)pipeCheckAllSyncClientLiveTimeIntervalMs);
    }

    public int getPipeTsFileResourceSegmentLockNum() {
        return this.pipeTsFileResourceSegmentLockNum;
    }

    public void setPipeTsFileResourceSegmentLockNum(int pipeTsFileResourceSegmentLockNum) {
        if (this.pipeTsFileResourceSegmentLockNum == pipeTsFileResourceSegmentLockNum) {
            return;
        }
        this.pipeTsFileResourceSegmentLockNum = pipeTsFileResourceSegmentLockNum;
        logger.info("pipeCheckSyncAllClientLiveTimeIntervalMs is set to {}", (Object)this.pipeCheckAllSyncClientLiveTimeIntervalMs);
    }

    public double getPipeSendTsFileRateLimitBytesPerSecond() {
        return this.pipeSendTsFileRateLimitBytesPerSecond;
    }

    public void setPipeSendTsFileRateLimitBytesPerSecond(double pipeSendTsFileRateLimitBytesPerSecond) {
        if (this.pipeSendTsFileRateLimitBytesPerSecond == pipeSendTsFileRateLimitBytesPerSecond) {
            return;
        }
        this.pipeSendTsFileRateLimitBytesPerSecond = pipeSendTsFileRateLimitBytesPerSecond;
        logger.info("pipeSendTsFileRateLimitBytesPerSecond is set to {}", (Object)pipeSendTsFileRateLimitBytesPerSecond);
    }

    public double getPipeAllSinksRateLimitBytesPerSecond() {
        return this.pipeAllSinksRateLimitBytesPerSecond;
    }

    public void setPipeAllSinksRateLimitBytesPerSecond(double pipeAllSinksRateLimitBytesPerSecond) {
        if (this.pipeAllSinksRateLimitBytesPerSecond == pipeAllSinksRateLimitBytesPerSecond) {
            return;
        }
        this.pipeAllSinksRateLimitBytesPerSecond = pipeAllSinksRateLimitBytesPerSecond;
        logger.info("pipeAllSinksRateLimitBytesPerSecond is set to {}", (Object)pipeAllSinksRateLimitBytesPerSecond);
    }

    public int getRateLimiterHotReloadCheckIntervalMs() {
        return this.rateLimiterHotReloadCheckIntervalMs;
    }

    public void setRateLimiterHotReloadCheckIntervalMs(int rateLimiterHotReloadCheckIntervalMs) {
        if (this.rateLimiterHotReloadCheckIntervalMs == rateLimiterHotReloadCheckIntervalMs) {
            return;
        }
        this.rateLimiterHotReloadCheckIntervalMs = rateLimiterHotReloadCheckIntervalMs;
        logger.info("rateLimiterHotReloadCheckIntervalMs is set to {}", (Object)rateLimiterHotReloadCheckIntervalMs);
    }

    public int getPipeConnectorRequestSliceThresholdBytes() {
        return this.pipeConnectorRequestSliceThresholdBytes;
    }

    public void setPipeConnectorRequestSliceThresholdBytes(int pipeConnectorRequestSliceThresholdBytes) {
        if (this.pipeConnectorRequestSliceThresholdBytes == pipeConnectorRequestSliceThresholdBytes) {
            return;
        }
        this.pipeConnectorRequestSliceThresholdBytes = pipeConnectorRequestSliceThresholdBytes;
        logger.info("pipeConnectorRequestSliceThresholdBytes is set to {}", (Object)pipeConnectorRequestSliceThresholdBytes);
    }

    public long getTwoStageAggregateMaxCombinerLiveTimeInMs() {
        return this.twoStageAggregateMaxCombinerLiveTimeInMs;
    }

    public void setTwoStageAggregateMaxCombinerLiveTimeInMs(long twoStageAggregateMaxCombinerLiveTimeInMs) {
        if (this.twoStageAggregateMaxCombinerLiveTimeInMs == twoStageAggregateMaxCombinerLiveTimeInMs) {
            return;
        }
        this.twoStageAggregateMaxCombinerLiveTimeInMs = twoStageAggregateMaxCombinerLiveTimeInMs;
        logger.info("twoStageAggregateMaxCombinerLiveTimeInMs is set to {}", (Object)twoStageAggregateMaxCombinerLiveTimeInMs);
    }

    public long getTwoStageAggregateDataRegionInfoCacheTimeInMs() {
        return this.twoStageAggregateDataRegionInfoCacheTimeInMs;
    }

    public void setTwoStageAggregateDataRegionInfoCacheTimeInMs(long twoStageAggregateDataRegionInfoCacheTimeInMs) {
        if (this.twoStageAggregateDataRegionInfoCacheTimeInMs == twoStageAggregateDataRegionInfoCacheTimeInMs) {
            return;
        }
        this.twoStageAggregateDataRegionInfoCacheTimeInMs = twoStageAggregateDataRegionInfoCacheTimeInMs;
        logger.info("twoStageAggregateDataRegionInfoCacheTimeInMs is set to {}", (Object)twoStageAggregateDataRegionInfoCacheTimeInMs);
    }

    public long getTwoStageAggregateSenderEndPointsCacheInMs() {
        return this.twoStageAggregateSenderEndPointsCacheInMs;
    }

    public void setTwoStageAggregateSenderEndPointsCacheInMs(long twoStageAggregateSenderEndPointsCacheInMs) {
        if (this.twoStageAggregateSenderEndPointsCacheInMs == twoStageAggregateSenderEndPointsCacheInMs) {
            return;
        }
        this.twoStageAggregateSenderEndPointsCacheInMs = twoStageAggregateSenderEndPointsCacheInMs;
        logger.info("twoStageAggregateSenderEndPointsCacheInMs is set to {}", (Object)twoStageAggregateSenderEndPointsCacheInMs);
    }

    public boolean getPipeEventReferenceTrackingEnabled() {
        return this.pipeEventReferenceTrackingEnabled;
    }

    public void setPipeEventReferenceTrackingEnabled(boolean pipeEventReferenceTrackingEnabled) {
        if (this.pipeEventReferenceTrackingEnabled == pipeEventReferenceTrackingEnabled) {
            return;
        }
        this.pipeEventReferenceTrackingEnabled = pipeEventReferenceTrackingEnabled;
        logger.info("pipeEventReferenceTrackingEnabled is set to {}", (Object)pipeEventReferenceTrackingEnabled);
    }

    public long getPipeEventReferenceEliminateIntervalSeconds() {
        return this.pipeEventReferenceEliminateIntervalSeconds;
    }

    public void setPipeEventReferenceEliminateIntervalSeconds(long pipeEventReferenceEliminateIntervalSeconds) {
        if (this.pipeEventReferenceEliminateIntervalSeconds == pipeEventReferenceEliminateIntervalSeconds) {
            return;
        }
        this.pipeEventReferenceEliminateIntervalSeconds = pipeEventReferenceEliminateIntervalSeconds;
        logger.info("pipeEventReferenceEliminateIntervalSeconds is set to {}", (Object)pipeEventReferenceEliminateIntervalSeconds);
    }

    public boolean getPipeAutoSplitFullEnabled() {
        return this.pipeAutoSplitFullEnabled;
    }

    public void setPipeAutoSplitFullEnabled(boolean pipeAutoSplitFullEnabled) {
        this.pipeAutoSplitFullEnabled = pipeAutoSplitFullEnabled;
    }

    public boolean getSubscriptionEnabled() {
        return this.subscriptionEnabled;
    }

    public void setSubscriptionEnabled(boolean subscriptionEnabled) {
        this.subscriptionEnabled = subscriptionEnabled;
    }

    public float getSubscriptionCacheMemoryUsagePercentage() {
        return this.subscriptionCacheMemoryUsagePercentage;
    }

    public void setSubscriptionCacheMemoryUsagePercentage(float subscriptionCacheMemoryUsagePercentage) {
        this.subscriptionCacheMemoryUsagePercentage = subscriptionCacheMemoryUsagePercentage;
    }

    public int getSubscriptionSubtaskExecutorMaxThreadNum() {
        return this.subscriptionSubtaskExecutorMaxThreadNum;
    }

    public void setSubscriptionSubtaskExecutorMaxThreadNum(int subscriptionSubtaskExecutorMaxThreadNum) {
        this.subscriptionSubtaskExecutorMaxThreadNum = subscriptionSubtaskExecutorMaxThreadNum;
    }

    public int getSubscriptionPrefetchTabletBatchMaxDelayInMs() {
        return this.subscriptionPrefetchTabletBatchMaxDelayInMs;
    }

    public void setSubscriptionPrefetchTabletBatchMaxDelayInMs(int subscriptionPrefetchTabletBatchMaxDelayInMs) {
        this.subscriptionPrefetchTabletBatchMaxDelayInMs = subscriptionPrefetchTabletBatchMaxDelayInMs;
    }

    public long getSubscriptionPrefetchTabletBatchMaxSizeInBytes() {
        return this.subscriptionPrefetchTabletBatchMaxSizeInBytes;
    }

    public void setSubscriptionPrefetchTabletBatchMaxSizeInBytes(long subscriptionPrefetchTabletBatchMaxSizeInBytes) {
        this.subscriptionPrefetchTabletBatchMaxSizeInBytes = subscriptionPrefetchTabletBatchMaxSizeInBytes;
    }

    public int getSubscriptionPrefetchTsFileBatchMaxDelayInMs() {
        return this.subscriptionPrefetchTsFileBatchMaxDelayInMs;
    }

    public void setSubscriptionPrefetchTsFileBatchMaxDelayInMs(int subscriptionPrefetchTsFileBatchMaxDelayInMs) {
        this.subscriptionPrefetchTsFileBatchMaxDelayInMs = subscriptionPrefetchTsFileBatchMaxDelayInMs;
    }

    public long getSubscriptionPrefetchTsFileBatchMaxSizeInBytes() {
        return this.subscriptionPrefetchTsFileBatchMaxSizeInBytes;
    }

    public void setSubscriptionPrefetchTsFileBatchMaxSizeInBytes(long subscriptionPrefetchTsFileBatchMaxSizeInBytes) {
        this.subscriptionPrefetchTsFileBatchMaxSizeInBytes = subscriptionPrefetchTsFileBatchMaxSizeInBytes;
    }

    public int getSubscriptionPollMaxBlockingTimeMs() {
        return this.subscriptionPollMaxBlockingTimeMs;
    }

    public void setSubscriptionPollMaxBlockingTimeMs(int subscriptionPollMaxBlockingTimeMs) {
        this.subscriptionPollMaxBlockingTimeMs = subscriptionPollMaxBlockingTimeMs;
    }

    public int getSubscriptionDefaultTimeoutInMs() {
        return this.subscriptionDefaultTimeoutInMs;
    }

    public void setSubscriptionDefaultTimeoutInMs(int subscriptionDefaultTimeoutInMs) {
        this.subscriptionDefaultTimeoutInMs = subscriptionDefaultTimeoutInMs;
    }

    public long getSubscriptionLaunchRetryIntervalMs() {
        return this.subscriptionLaunchRetryIntervalMs;
    }

    public void setSubscriptionLaunchRetryIntervalMs(long subscriptionLaunchRetryIntervalMs) {
        this.subscriptionLaunchRetryIntervalMs = subscriptionLaunchRetryIntervalMs;
    }

    public int getSubscriptionRecycleUncommittedEventIntervalMs() {
        return this.subscriptionRecycleUncommittedEventIntervalMs;
    }

    public void setSubscriptionRecycleUncommittedEventIntervalMs(int subscriptionRecycleUncommittedEventIntervalMs) {
        this.subscriptionRecycleUncommittedEventIntervalMs = subscriptionRecycleUncommittedEventIntervalMs;
    }

    public long getSubscriptionReadFileBufferSize() {
        return this.subscriptionReadFileBufferSize;
    }

    public void setSubscriptionReadFileBufferSize(long subscriptionReadFileBufferSize) {
        this.subscriptionReadFileBufferSize = subscriptionReadFileBufferSize;
    }

    public long getSubscriptionReadTabletBufferSize() {
        return this.subscriptionReadTabletBufferSize;
    }

    public void setSubscriptionReadTabletBufferSize(long subscriptionReadTabletBufferSize) {
        this.subscriptionReadTabletBufferSize = subscriptionReadTabletBufferSize;
    }

    public long getSubscriptionTsFileDeduplicationWindowSeconds() {
        return this.subscriptionTsFileDeduplicationWindowSeconds;
    }

    public void setSubscriptionTsFileDeduplicationWindowSeconds(long subscriptionTsFileDeduplicationWindowSeconds) {
        this.subscriptionTsFileDeduplicationWindowSeconds = subscriptionTsFileDeduplicationWindowSeconds;
    }

    public long getSubscriptionCheckMemoryEnoughIntervalMs() {
        return this.subscriptionCheckMemoryEnoughIntervalMs;
    }

    public void setSubscriptionCheckMemoryEnoughIntervalMs(long subscriptionCheckMemoryEnoughIntervalMs) {
        this.subscriptionCheckMemoryEnoughIntervalMs = subscriptionCheckMemoryEnoughIntervalMs;
    }

    public long getSubscriptionEstimatedInsertNodeTabletInsertionEventSize() {
        return this.subscriptionEstimatedInsertNodeTabletInsertionEventSize;
    }

    public void setSubscriptionEstimatedInsertNodeTabletInsertionEventSize(long subscriptionEstimatedInsertNodeTabletInsertionEventSize) {
        this.subscriptionEstimatedInsertNodeTabletInsertionEventSize = subscriptionEstimatedInsertNodeTabletInsertionEventSize;
    }

    public long getSubscriptionEstimatedRawTabletInsertionEventSize() {
        return this.subscriptionEstimatedRawTabletInsertionEventSize;
    }

    public void setSubscriptionEstimatedRawTabletInsertionEventSize(long subscriptionEstimatedRawTabletInsertionEventSize) {
        this.subscriptionEstimatedRawTabletInsertionEventSize = subscriptionEstimatedRawTabletInsertionEventSize;
    }

    public long getSubscriptionMaxAllowedEventCountInTabletBatch() {
        return this.subscriptionMaxAllowedEventCountInTabletBatch;
    }

    public void setSubscriptionMaxAllowedEventCountInTabletBatch(long subscriptionMaxAllowedEventCountInTabletBatch) {
        this.subscriptionMaxAllowedEventCountInTabletBatch = subscriptionMaxAllowedEventCountInTabletBatch;
    }

    public long getSubscriptionLogManagerWindowSeconds() {
        return this.subscriptionLogManagerWindowSeconds;
    }

    public void setSubscriptionLogManagerWindowSeconds(long subscriptionLogManagerWindowSeconds) {
        this.subscriptionLogManagerWindowSeconds = subscriptionLogManagerWindowSeconds;
    }

    public long getSubscriptionLogManagerBaseIntervalMs() {
        return this.subscriptionLogManagerBaseIntervalMs;
    }

    public void setSubscriptionLogManagerBaseIntervalMs(long subscriptionLogManagerBaseIntervalMs) {
        this.subscriptionLogManagerBaseIntervalMs = subscriptionLogManagerBaseIntervalMs;
    }

    public boolean getSubscriptionPrefetchEnabled() {
        return this.subscriptionPrefetchEnabled;
    }

    public void setSubscriptionPrefetchEnabled(boolean subscriptionPrefetchEnabled) {
        this.subscriptionPrefetchEnabled = subscriptionPrefetchEnabled;
    }

    public float getSubscriptionPrefetchMemoryThreshold() {
        return this.subscriptionPrefetchMemoryThreshold;
    }

    public void setSubscriptionPrefetchMemoryThreshold(float subscriptionPrefetchMemoryThreshold) {
        this.subscriptionPrefetchMemoryThreshold = subscriptionPrefetchMemoryThreshold;
    }

    public float getSubscriptionPrefetchMissingRateThreshold() {
        return this.subscriptionPrefetchMissingRateThreshold;
    }

    public void setSubscriptionPrefetchMissingRateThreshold(float subscriptionPrefetchMissingRateThreshold) {
        this.subscriptionPrefetchMissingRateThreshold = subscriptionPrefetchMissingRateThreshold;
    }

    public int getSubscriptionPrefetchEventLocalCountThreshold() {
        return this.subscriptionPrefetchEventLocalCountThreshold;
    }

    public void setSubscriptionPrefetchEventLocalCountThreshold(int subscriptionPrefetchEventLocalCountThreshold) {
        this.subscriptionPrefetchEventLocalCountThreshold = subscriptionPrefetchEventLocalCountThreshold;
    }

    public int getSubscriptionPrefetchEventGlobalCountThreshold() {
        return this.subscriptionPrefetchEventGlobalCountThreshold;
    }

    public void setSubscriptionPrefetchEventGlobalCountThreshold(int subscriptionPrefetchEventGlobalCountThreshold) {
        this.subscriptionPrefetchEventGlobalCountThreshold = subscriptionPrefetchEventGlobalCountThreshold;
    }

    public long getSubscriptionMetaSyncerInitialSyncDelayMinutes() {
        return this.subscriptionMetaSyncerInitialSyncDelayMinutes;
    }

    public void setSubscriptionMetaSyncerInitialSyncDelayMinutes(long subscriptionMetaSyncerInitialSyncDelayMinutes) {
        this.subscriptionMetaSyncerInitialSyncDelayMinutes = subscriptionMetaSyncerInitialSyncDelayMinutes;
    }

    public long getSubscriptionMetaSyncerSyncIntervalMinutes() {
        return this.subscriptionMetaSyncerSyncIntervalMinutes;
    }

    public void setSubscriptionMetaSyncerSyncIntervalMinutes(long subscriptionMetaSyncerSyncIntervalMinutes) {
        this.subscriptionMetaSyncerSyncIntervalMinutes = subscriptionMetaSyncerSyncIntervalMinutes;
    }

    public String getSchemaEngineMode() {
        return this.schemaEngineMode;
    }

    public void setSchemaEngineMode(String schemaEngineMode) {
        this.schemaEngineMode = schemaEngineMode;
    }

    public boolean isLastCacheEnable() {
        return this.lastCacheEnable;
    }

    public void setLastCacheEnable(boolean lastCacheEnable) {
        this.lastCacheEnable = lastCacheEnable;
    }

    public int getTagAttributeTotalSize() {
        return this.tagAttributeTotalSize;
    }

    public void setTagAttributeTotalSize(int tagAttributeTotalSize) {
        this.tagAttributeTotalSize = tagAttributeTotalSize;
    }

    public int getDatabaseLimitThreshold() {
        return this.databaseLimitThreshold;
    }

    public void setDatabaseLimitThreshold(int databaseLimitThreshold) {
        this.databaseLimitThreshold = databaseLimitThreshold;
    }

    public int getModelInferenceExecutionThreadCount() {
        return this.modelInferenceExecutionThreadCount;
    }

    public void setModelInferenceExecutionThreadCount(int modelInferenceExecutionThreadCount) {
        this.modelInferenceExecutionThreadCount = modelInferenceExecutionThreadCount;
    }

    public long getDatanodeTokenTimeoutMS() {
        return this.datanodeTokenTimeoutMS;
    }

    public void setDatanodeTokenTimeoutMS(long timeoutMS) {
        this.datanodeTokenTimeoutMS = timeoutMS;
    }

    public long getSeriesLimitThreshold() {
        return this.seriesLimitThreshold;
    }

    public void setSeriesLimitThreshold(long seriesLimitThreshold) {
        this.seriesLimitThreshold = seriesLimitThreshold;
    }

    public long getDeviceLimitThreshold() {
        return this.deviceLimitThreshold;
    }

    public void setDeviceLimitThreshold(long deviceLimitThreshold) {
        this.deviceLimitThreshold = deviceLimitThreshold;
    }

    public long getStartUpNanosecond() {
        return this.startUpNanosecond;
    }

    public boolean isIntegrationTest() {
        return this.isIntegrationTest;
    }

    public Set<String> getEnabledKillPoints() {
        return this.enabledKillPoints;
    }

    public boolean isRetryForUnknownErrors() {
        return this.retryForUnknownErrors;
    }

    public void setRetryForUnknownErrors(boolean retryForUnknownErrors) {
        this.retryForUnknownErrors = retryForUnknownErrors;
    }

    public long getRemoteWriteMaxRetryDurationInMs() {
        return this.remoteWriteMaxRetryDurationInMs;
    }

    public void setRemoteWriteMaxRetryDurationInMs(long remoteWriteMaxRetryDurationInMs) {
        this.remoteWriteMaxRetryDurationInMs = remoteWriteMaxRetryDurationInMs;
    }

    public int getArenaNum() {
        return this.arenaNum;
    }

    public void setArenaNum(int arenaNum) {
        this.arenaNum = arenaNum;
    }

    public int getMinAllocateSize() {
        return this.minAllocateSize;
    }

    public void setMinAllocateSize(int minAllocateSize) {
        this.minAllocateSize = minAllocateSize;
    }

    public int getMaxAllocateSize() {
        return this.maxAllocateSize;
    }

    public void setMaxAllocateSize(int maxAllocateSize) {
        this.maxAllocateSize = maxAllocateSize;
    }

    public boolean isEnableBinaryAllocator() {
        return this.enableBinaryAllocator;
    }

    public void setEnableBinaryAllocator(boolean enableBinaryAllocator) {
        this.enableBinaryAllocator = enableBinaryAllocator;
    }

    public int getLog2SizeClassGroup() {
        return this.log2SizeClassGroup;
    }

    public void setLog2SizeClassGroup(int log2SizeClassGroup) {
        this.log2SizeClassGroup = log2SizeClassGroup;
    }

    public int getPathLogMaxSize() {
        return this.pathLogMaxSize;
    }

    public void setPathLogMaxSize(int pathLogMaxSize) {
        this.pathLogMaxSize = pathLogMaxSize;
    }

    public void setQuerySamplingRateLimit(int querySamplingRateLimit) {
        if (querySamplingRateLimit > 0) {
            this.querySamplingRateLimiter.setRate((double)querySamplingRateLimit);
            this.enableQuerySampling = true;
            this.querySamplingHasRateLimit = true;
        } else if (querySamplingRateLimit == 0) {
            this.enableQuerySampling = false;
        } else {
            this.enableQuerySampling = true;
            this.querySamplingHasRateLimit = false;
        }
    }

    public boolean isQuerySamplingHasRateLimit() {
        return this.querySamplingHasRateLimit;
    }

    public RateLimiter getQuerySamplingRateLimiter() {
        return this.querySamplingRateLimiter;
    }

    public boolean isEnableQuerySampling() {
        return this.enableQuerySampling;
    }

    public Pattern getTrustedUriPattern() {
        return this.trustedUriPattern;
    }

    public void setTrustedUriPattern(Pattern trustedUriPattern) {
        this.trustedUriPattern = trustedUriPattern;
    }
}

