/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class DeleteSubscriptionsRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=845");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=847");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=846");
    private final RequestHeader requestHeader;
    private final UInteger[] subscriptionIds;

    public DeleteSubscriptionsRequest(RequestHeader requestHeader, UInteger[] subscriptionIds) {
        this.requestHeader = requestHeader;
        this.subscriptionIds = subscriptionIds;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger[] getSubscriptionIds() {
        return this.subscriptionIds;
    }

    protected DeleteSubscriptionsRequest(DeleteSubscriptionsRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((DeleteSubscriptionsRequestBuilder)b).requestHeader;
        this.subscriptionIds = ((DeleteSubscriptionsRequestBuilder)b).subscriptionIds;
    }

    public static DeleteSubscriptionsRequestBuilder<?, ?> builder() {
        return new DeleteSubscriptionsRequestBuilderImpl();
    }

    public DeleteSubscriptionsRequestBuilder<?, ?> toBuilder() {
        return new DeleteSubscriptionsRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteSubscriptionsRequest)) {
            return false;
        }
        DeleteSubscriptionsRequest other = (DeleteSubscriptionsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getSubscriptionIds(), other.getSubscriptionIds());
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteSubscriptionsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSubscriptionIds());
        return result;
    }

    @Override
    public String toString() {
        return "DeleteSubscriptionsRequest(requestHeader=" + this.getRequestHeader() + ", subscriptionIds=" + Arrays.deepToString(this.getSubscriptionIds()) + ")";
    }

    private static final class DeleteSubscriptionsRequestBuilderImpl
    extends DeleteSubscriptionsRequestBuilder<DeleteSubscriptionsRequest, DeleteSubscriptionsRequestBuilderImpl> {
        private DeleteSubscriptionsRequestBuilderImpl() {
        }

        @Override
        protected DeleteSubscriptionsRequestBuilderImpl self() {
            return this;
        }

        @Override
        public DeleteSubscriptionsRequest build() {
            return new DeleteSubscriptionsRequest(this);
        }
    }

    public static abstract class DeleteSubscriptionsRequestBuilder<C extends DeleteSubscriptionsRequest, B extends DeleteSubscriptionsRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private UInteger[] subscriptionIds;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DeleteSubscriptionsRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DeleteSubscriptionsRequest instance, DeleteSubscriptionsRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.subscriptionIds(instance.subscriptionIds);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B subscriptionIds(UInteger[] subscriptionIds) {
            this.subscriptionIds = subscriptionIds;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DeleteSubscriptionsRequest.DeleteSubscriptionsRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", subscriptionIds=" + Arrays.deepToString(this.subscriptionIds) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<DeleteSubscriptionsRequest> {
        @Override
        public Class<DeleteSubscriptionsRequest> getType() {
            return DeleteSubscriptionsRequest.class;
        }

        @Override
        public DeleteSubscriptionsRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            UInteger[] subscriptionIds = decoder.readUInt32Array("SubscriptionIds");
            return new DeleteSubscriptionsRequest(requestHeader, subscriptionIds);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DeleteSubscriptionsRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeUInt32Array("SubscriptionIds", value.getSubscriptionIds());
        }
    }
}

