/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.db.queryengine.metric.QueryExecutionMetricSet;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.BitMap;

public class Aggregator {
    protected final Accumulator accumulator;
    protected List<InputLocation[]> inputLocationList;
    protected final AggregationStep step;
    protected static final QueryExecutionMetricSet QUERY_EXECUTION_METRICS = QueryExecutionMetricSet.getInstance();

    public Aggregator(Accumulator accumulator, AggregationStep step) {
        this.accumulator = accumulator;
        this.step = step;
        this.inputLocationList = Collections.singletonList(new InputLocation[]{new InputLocation(0, 0)});
    }

    public Aggregator(Accumulator accumulator, AggregationStep step, List<InputLocation[]> inputLocationList) {
        this.accumulator = accumulator;
        this.step = step;
        this.inputLocationList = inputLocationList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTsBlock(TsBlock tsBlock, BitMap bitMap) {
        long startTime = System.nanoTime();
        try {
            Preconditions.checkArgument((boolean)this.step.isInputRaw(), (Object)"Step in SeriesAggregateScanOperator and RawDataAggregateOperator can only process raw input");
            for (InputLocation[] inputLocations : this.inputLocationList) {
                Column[] timeAndValueColumn = new Column[1 + inputLocations.length];
                timeAndValueColumn[0] = tsBlock.getTimeColumn();
                for (int i = 0; i < inputLocations.length; ++i) {
                    Preconditions.checkArgument((inputLocations[i].getTsBlockIndex() == 0 ? 1 : 0) != 0, (Object)"RawDataAggregateOperator can only process one tsBlock input.");
                    int index = inputLocations[i].getValueColumnIndex();
                    timeAndValueColumn[1 + i] = index == -1 ? timeAndValueColumn[0] : tsBlock.getColumn(index);
                }
                this.accumulator.addInput(timeAndValueColumn, bitMap);
            }
        }
        finally {
            QUERY_EXECUTION_METRICS.recordExecutionCost("aggregation_from_raw_data", System.nanoTime() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTsBlocks(TsBlock[] tsBlock) {
        long startTime = System.nanoTime();
        try {
            Preconditions.checkArgument((!this.step.isInputRaw() ? 1 : 0) != 0, (Object)"Step in AggregateOperator cannot process raw input");
            if (this.step.isInputFinal()) {
                Preconditions.checkArgument((this.inputLocationList.size() == 1 ? 1 : 0) != 0, (Object)"Final output can only be single column");
                Column finalResult = tsBlock[this.inputLocationList.get(0)[0].getTsBlockIndex()].getColumn(this.inputLocationList.get(0)[0].getValueColumnIndex());
                this.accumulator.setFinal(finalResult);
            } else {
                for (InputLocation[] inputLocations : this.inputLocationList) {
                    Column[] columns = new Column[inputLocations.length];
                    for (int i = 0; i < inputLocations.length; ++i) {
                        columns[i] = tsBlock[inputLocations[i].getTsBlockIndex()].getColumn(inputLocations[i].getValueColumnIndex());
                    }
                    this.accumulator.addIntermediate(columns);
                }
            }
        }
        finally {
            QUERY_EXECUTION_METRICS.recordExecutionCost("aggregation_from_raw_data", System.nanoTime() - startTime);
        }
    }

    public void outputResult(ColumnBuilder[] columnBuilder) {
        if (this.step.isOutputPartial()) {
            this.accumulator.outputIntermediate(columnBuilder);
        } else {
            this.accumulator.outputFinal(columnBuilder[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStatistics(Statistics timeStatistics, Statistics[] valueStatistics) {
        long startTime = System.nanoTime();
        try {
            for (InputLocation[] inputLocations : this.inputLocationList) {
                int valueIndex = inputLocations[0].getValueColumnIndex();
                this.accumulator.addStatistics(valueIndex == -1 ? timeStatistics : valueStatistics[valueIndex]);
            }
        }
        finally {
            QUERY_EXECUTION_METRICS.recordExecutionCost("aggregation_from_statistics", System.nanoTime() - startTime);
        }
    }

    public TSDataType[] getOutputType() {
        if (this.step.isOutputPartial()) {
            return this.accumulator.getIntermediateType();
        }
        return new TSDataType[]{this.accumulator.getFinalType()};
    }

    public void reset() {
        this.accumulator.reset();
    }

    public boolean hasFinalResult() {
        return this.accumulator.hasFinalResult();
    }
}

