/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.datastructure.iterator;

import java.io.IOException;
import org.apache.iotdb.db.queryengine.transformation.datastructure.iterator.ListForwardIterator;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.SerializableTVList;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.TimeColumn;

public class TVListForwardIterator
implements ListForwardIterator {
    private final ElasticSerializableTVList tvList;
    private int externalIndex;
    private int internalIndex;
    private int endPointIndex;

    public TVListForwardIterator(ElasticSerializableTVList tvList) {
        this.tvList = tvList;
        this.externalIndex = 0;
        this.internalIndex = -1;
        this.endPointIndex = 0;
    }

    public TVListForwardIterator(ElasticSerializableTVList tvList, int externalIndex, int internalIndex) throws IOException {
        this.tvList = tvList;
        this.externalIndex = externalIndex;
        this.internalIndex = internalIndex;
        this.endPointIndex = tvList.getLastPointIndex(externalIndex, internalIndex);
    }

    public TimeColumn currentTimes() throws IOException {
        return this.tvList.getTimeColumn(this.externalIndex, this.internalIndex);
    }

    public Column currentValues() throws IOException {
        return this.tvList.getValueColumn(this.externalIndex, this.internalIndex);
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.tvList.getSerializableTVListSize() == 0) {
            return false;
        }
        return this.externalIndex + 1 < this.tvList.getSerializableTVListSize() || this.internalIndex + 1 < this.tvList.getSerializableTVList(this.externalIndex).getColumnCount();
    }

    @Override
    public void next() throws IOException {
        if (this.internalIndex + 1 == this.tvList.getColumnCount(this.externalIndex)) {
            this.internalIndex = 0;
            ++this.externalIndex;
        } else {
            ++this.internalIndex;
        }
        SerializableTVList internalTVList = this.tvList.getSerializableTVList(this.externalIndex);
        this.endPointIndex += internalTVList.getColumnSize(this.internalIndex);
    }

    public void adjust() throws IOException {
        int capacity = this.tvList.getInternalTVListCapacity();
        int externalColumnIndex = this.endPointIndex / capacity;
        int internalPointIndex = this.endPointIndex % capacity;
        int internalColumnIndex = this.tvList.getSerializableTVList(this.externalIndex).getColumnIndex(internalPointIndex - 1);
        this.externalIndex = externalColumnIndex;
        this.internalIndex = internalColumnIndex;
    }

    public int getEndPointIndex() {
        return this.endPointIndex;
    }
}

