/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.repair;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionLastTimeCheckFailedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionStatisticsCheckFailedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader.CompactionChunkReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.compress.IUnCompressor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.MetadataIndexNode;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TsFileDeviceIterator;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.reader.chunk.ChunkReader;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairDataFileScanUtil {
    private static final Logger logger = LoggerFactory.getLogger(RepairDataFileScanUtil.class);
    private final TsFileResource resource;
    private DeviceTimeIndex timeIndex;
    private boolean hasUnsortedDataOrWrongStatistics;
    private boolean isBrokenFile;
    private boolean previousTimeSet;
    private long previousTime;
    private boolean printLog;

    public RepairDataFileScanUtil(TsFileResource resource) {
        this(resource, false);
    }

    public RepairDataFileScanUtil(TsFileResource resource, boolean printLog) {
        this.resource = resource;
        this.hasUnsortedDataOrWrongStatistics = false;
        this.previousTimeSet = false;
        this.printLog = printLog;
    }

    public void scanTsFile() {
        this.scanTsFile(false);
    }

    public void scanTsFile(boolean checkTsFileResource) {
        File tsfile = this.resource.getTsFile();
        try {
            this.timeIndex = checkTsFileResource ? RepairDataFileScanUtil.getDeviceTimeIndex(this.resource) : null;
        }
        catch (IOException e) {
            logger.warn("Meet error when read tsfile resource file {}, it may be repaired after reboot", (Object)(tsfile.getAbsolutePath() + ".resource"), (Object)e);
            this.isBrokenFile = true;
            return;
        }
        try (CompactionTsFileReader reader = new CompactionTsFileReader(tsfile.getPath(), this.resource.isSeq() ? CompactionType.INNER_SEQ_COMPACTION : CompactionType.INNER_UNSEQ_COMPACTION);){
            HashSet<IDeviceID> deviceIdsInTimeIndex;
            TsFileDeviceIterator deviceInFileIterator = reader.getAllDevicesIteratorWithIsAligned();
            HashSet<IDeviceID> hashSet = deviceIdsInTimeIndex = checkTsFileResource ? new HashSet<IDeviceID>(this.timeIndex.getDevices()) : Collections.emptySet();
            while (deviceInFileIterator.hasNext()) {
                Pair deviceIsAlignedPair = deviceInFileIterator.next();
                IDeviceID deviceInFile = (IDeviceID)deviceIsAlignedPair.getLeft();
                if (checkTsFileResource) {
                    if (!deviceIdsInTimeIndex.contains(deviceInFile)) {
                        throw new CompactionStatisticsCheckFailedException(deviceInFile + " does not exist in the resource file");
                    }
                    deviceIdsInTimeIndex.remove(deviceInFile);
                }
                MetadataIndexNode metadataIndexNode = deviceInFileIterator.getFirstMeasurementNodeOfCurrentDevice();
                TimeRange deviceTimeRangeInResource = checkTsFileResource ? new TimeRange(this.timeIndex.getStartTime(deviceInFile).get().longValue(), this.timeIndex.getEndTime(deviceInFile).get().longValue()) : null;
                boolean isAligned = (Boolean)deviceIsAlignedPair.getRight();
                if (isAligned) {
                    this.checkAlignedDeviceSeries(reader, deviceInFile, metadataIndexNode, deviceTimeRangeInResource, checkTsFileResource);
                    continue;
                }
                this.checkNonAlignedDeviceSeries(reader, deviceInFile, metadataIndexNode, deviceTimeRangeInResource, checkTsFileResource);
            }
            if (!deviceIdsInTimeIndex.isEmpty()) {
                throw new CompactionStatisticsCheckFailedException("These devices (" + deviceIdsInTimeIndex + ") do not exist in the tsfile");
            }
        }
        catch (CompactionLastTimeCheckFailedException lastTimeCheckFailedException) {
            this.hasUnsortedDataOrWrongStatistics = true;
            if (this.printLog) {
                logger.error("File {} has unsorted data: ", (Object)this.resource.getTsFile().getPath(), (Object)lastTimeCheckFailedException);
            }
        }
        catch (CompactionStatisticsCheckFailedException compactionStatisticsCheckFailedException) {
            this.hasUnsortedDataOrWrongStatistics = true;
            if (this.printLog) {
                logger.error("File {} has wrong time statistics: ", (Object)this.resource.getTsFile().getPath(), (Object)compactionStatisticsCheckFailedException);
            }
        }
        catch (Exception e) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (!this.resource.tsFileExists()) {
                return;
            }
            logger.warn("Meet error when read tsfile {}", (Object)tsfile.getAbsolutePath(), (Object)e);
            this.isBrokenFile = true;
        }
    }

    private void checkAlignedDeviceSeries(TsFileSequenceReader reader, IDeviceID device, MetadataIndexNode metadataIndexNode, TimeRange deviceTimeRangeInResource, boolean checkTsFileResource) throws IOException {
        ArrayList timeColumnTimeseriesMetadata = new ArrayList(1);
        reader.readITimeseriesMetadata(timeColumnTimeseriesMetadata, metadataIndexNode, "");
        TimeseriesMetadata timeseriesMetadata = (TimeseriesMetadata)timeColumnTimeseriesMetadata.get(0);
        TimeRange timeseriesTimeRange = new TimeRange(timeseriesMetadata.getStatistics().getStartTime(), timeseriesMetadata.getStatistics().getEndTime());
        if (checkTsFileResource) {
            this.compareDeviceTimeRange(device, deviceTimeRangeInResource, timeseriesTimeRange);
        }
        long actualTimeseriesStartTime = Long.MAX_VALUE;
        long actualTimeseriesEndTime = Long.MIN_VALUE;
        List timeChunkMetadataList = reader.readChunkMetaDataList((TimeseriesMetadata)timeColumnTimeseriesMetadata.get(0));
        for (ChunkMetadata timeChunkMetadata : timeChunkMetadataList) {
            actualTimeseriesStartTime = Math.min(actualTimeseriesStartTime, timeChunkMetadata.getStartTime());
            actualTimeseriesEndTime = Math.max(actualTimeseriesEndTime, timeChunkMetadata.getEndTime());
            this.checkTimeChunkInAlignedSeries(reader, device, timeChunkMetadata);
        }
        this.previousTimeSet = false;
        if (actualTimeseriesStartTime > actualTimeseriesEndTime) {
            return;
        }
        TimeRange actualTimeseriesTimeRange = new TimeRange(actualTimeseriesStartTime, actualTimeseriesEndTime);
        if (!actualTimeseriesTimeRange.equals((Object)timeseriesTimeRange)) {
            throw new CompactionStatisticsCheckFailedException(device, timeseriesMetadata, actualTimeseriesTimeRange);
        }
    }

    private void checkTimeChunkInAlignedSeries(TsFileSequenceReader reader, IDeviceID device, ChunkMetadata timeChunkMetadata) throws IOException {
        Chunk timeChunk = reader.readMemChunk(timeChunkMetadata);
        CompactionChunkReader chunkReader = new CompactionChunkReader(timeChunk);
        ByteBuffer chunkDataBuffer = timeChunk.getData();
        ChunkHeader chunkHeader = timeChunk.getHeader();
        long actualChunkStartTime = Long.MAX_VALUE;
        long actualChunkEndTime = Long.MIN_VALUE;
        while (chunkDataBuffer.hasRemaining()) {
            PageHeader pageHeader = null;
            pageHeader = (byte)(chunkHeader.getChunkType() & 0x3F) == 5 ? PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (Statistics)timeChunk.getChunkStatistic()) : PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (TSDataType)chunkHeader.getDataType());
            actualChunkStartTime = Math.min(actualChunkStartTime, pageHeader.getStartTime());
            actualChunkEndTime = Math.max(actualChunkEndTime, pageHeader.getEndTime());
            ByteBuffer pageData = chunkReader.readPageDataWithoutUncompressing(pageHeader);
            ByteBuffer uncompressedPageData = ChunkReader.uncompressPageData((PageHeader)pageHeader, (IUnCompressor)IUnCompressor.getUnCompressor((CompressionType)chunkHeader.getCompressionType()), (ByteBuffer)pageData);
            this.validateTimeData(device, uncompressedPageData, pageHeader);
        }
        if (actualChunkStartTime > actualChunkEndTime) {
            return;
        }
        TimeRange actualChunkTimeRange = new TimeRange(actualChunkStartTime, actualChunkEndTime);
        if (!actualChunkTimeRange.equals((Object)new TimeRange(timeChunkMetadata.getStartTime(), timeChunkMetadata.getEndTime()))) {
            throw new CompactionStatisticsCheckFailedException(device, timeChunkMetadata, actualChunkTimeRange);
        }
    }

    private void checkNonAlignedDeviceSeries(TsFileSequenceReader reader, IDeviceID device, MetadataIndexNode metadataIndexNode, TimeRange deviceTimeRangeInResource, boolean checkTsFileResource) throws IOException {
        ArrayList timeseriesMetadataList = new ArrayList();
        reader.getDeviceTimeseriesMetadata(timeseriesMetadataList, metadataIndexNode, Collections.emptySet(), true);
        long actualDeviceStartTime = Long.MAX_VALUE;
        long actualDeviceEndTime = Long.MIN_VALUE;
        for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataList) {
            actualDeviceStartTime = Math.min(actualDeviceStartTime, timeseriesMetadata.getStatistics().getStartTime());
            actualDeviceEndTime = Math.max(actualDeviceEndTime, timeseriesMetadata.getStatistics().getEndTime());
            this.checkSingleNonAlignedSeries(reader, device, timeseriesMetadata);
            this.previousTimeSet = false;
        }
        if (!checkTsFileResource || actualDeviceStartTime > actualDeviceEndTime) {
            return;
        }
        this.compareDeviceTimeRange(device, deviceTimeRangeInResource, new TimeRange(actualDeviceStartTime, actualDeviceEndTime));
    }

    private void compareDeviceTimeRange(IDeviceID device, TimeRange deviceTimeRangeInResource, TimeRange actualDeviceTimeRange) {
        long innerCompactionCount = this.resource.getTsFileID().getInnerCompactionCount();
        if (innerCompactionCount == 0L ? !deviceTimeRangeInResource.contains(actualDeviceTimeRange) : !actualDeviceTimeRange.equals((Object)deviceTimeRangeInResource)) {
            throw new CompactionStatisticsCheckFailedException(device, deviceTimeRangeInResource, actualDeviceTimeRange);
        }
    }

    private void checkSingleNonAlignedSeries(TsFileSequenceReader reader, IDeviceID deviceID, TimeseriesMetadata timeseriesMetadata) throws IOException {
        TimeRange timeseriesTimeRange = new TimeRange(timeseriesMetadata.getStatistics().getStartTime(), timeseriesMetadata.getStatistics().getEndTime());
        long actualTimeseriesStartTime = Long.MAX_VALUE;
        long actualTimeseriesEndTime = Long.MIN_VALUE;
        for (IChunkMetadata iChunkMetadata : timeseriesMetadata.getChunkMetadataList()) {
            ChunkMetadata chunkMetadata = (ChunkMetadata)iChunkMetadata;
            actualTimeseriesStartTime = Math.min(actualTimeseriesStartTime, chunkMetadata.getStartTime());
            actualTimeseriesEndTime = Math.max(actualTimeseriesEndTime, chunkMetadata.getEndTime());
            this.checkChunkOfNonAlignedSeries(reader, deviceID, chunkMetadata);
        }
        if (actualTimeseriesStartTime > actualTimeseriesEndTime) {
            return;
        }
        TimeRange actualTimeseriesTimeRange = new TimeRange(actualTimeseriesStartTime, actualTimeseriesEndTime);
        if (!actualTimeseriesTimeRange.equals((Object)timeseriesTimeRange)) {
            throw new CompactionStatisticsCheckFailedException(deviceID, timeseriesMetadata, actualTimeseriesTimeRange);
        }
    }

    private void checkChunkOfNonAlignedSeries(TsFileSequenceReader reader, IDeviceID deviceID, ChunkMetadata chunkMetadata) throws IOException {
        Chunk chunk = reader.readMemChunk(chunkMetadata);
        ChunkHeader chunkHeader = chunk.getHeader();
        CompactionChunkReader chunkReader = new CompactionChunkReader(chunk);
        ByteBuffer chunkDataBuffer = chunk.getData();
        long actualChunkStartTime = Long.MAX_VALUE;
        long actualChunkEndTime = Long.MIN_VALUE;
        while (chunkDataBuffer.hasRemaining()) {
            PageHeader pageHeader = null;
            pageHeader = (byte)(chunkHeader.getChunkType() & 0x3F) == 5 ? PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (Statistics)chunk.getChunkStatistic()) : PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (TSDataType)chunkHeader.getDataType());
            actualChunkStartTime = Math.min(actualChunkStartTime, pageHeader.getStartTime());
            actualChunkEndTime = Math.max(actualChunkEndTime, pageHeader.getEndTime());
            ByteBuffer pageData = chunkReader.readPageDataWithoutUncompressing(pageHeader);
            ByteBuffer uncompressedPageData = ChunkReader.uncompressPageData((PageHeader)pageHeader, (IUnCompressor)IUnCompressor.getUnCompressor((CompressionType)chunkHeader.getCompressionType()), (ByteBuffer)pageData);
            ByteBuffer timeBuffer = this.getTimeBufferFromNonAlignedPage(uncompressedPageData);
            this.validateTimeData(deviceID, timeBuffer, pageHeader);
        }
        if (actualChunkStartTime > actualChunkEndTime) {
            return;
        }
        TimeRange actualChunkTimeRange = new TimeRange(actualChunkStartTime, actualChunkEndTime);
        if (!actualChunkTimeRange.equals((Object)new TimeRange(chunkMetadata.getStartTime(), chunkMetadata.getEndTime()))) {
            throw new CompactionStatisticsCheckFailedException(deviceID, chunkMetadata, actualChunkTimeRange);
        }
    }

    private ByteBuffer getTimeBufferFromNonAlignedPage(ByteBuffer uncompressedPageData) {
        int timeBufferLength = ReadWriteForEncodingUtils.readUnsignedVarInt((ByteBuffer)uncompressedPageData);
        ByteBuffer timeBuffer = uncompressedPageData.slice();
        timeBuffer.limit(timeBufferLength);
        return timeBuffer;
    }

    private void validateTimeData(IDeviceID device, ByteBuffer uncompressedTimeData, PageHeader pageHeader) throws IOException {
        Decoder decoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
        TimeRange pageHeaderTimeRange = new TimeRange(pageHeader.getStartTime(), pageHeader.getEndTime());
        long actualStartTime = Long.MAX_VALUE;
        long actualEndTime = Long.MIN_VALUE;
        while (decoder.hasNext(uncompressedTimeData)) {
            long currentTime = decoder.readLong(uncompressedTimeData);
            actualStartTime = Math.min(actualStartTime, currentTime);
            actualEndTime = Math.max(actualEndTime, currentTime);
            this.checkPreviousTimeAndUpdate(device, currentTime);
        }
        if (actualStartTime > actualEndTime) {
            return;
        }
        TimeRange actualPageTimeRange = new TimeRange(actualStartTime, actualEndTime);
        if (!actualPageTimeRange.equals((Object)pageHeaderTimeRange)) {
            throw new CompactionStatisticsCheckFailedException(device, pageHeader, actualPageTimeRange);
        }
    }

    private void checkPreviousTimeAndUpdate(IDeviceID deviceID, String measurementId, long time) {
        if (this.previousTimeSet && this.previousTime >= time) {
            throw new CompactionLastTimeCheckFailedException(deviceID.toString() + "." + measurementId, time, this.previousTime);
        }
        this.previousTime = time;
        this.previousTimeSet = true;
    }

    private void checkPreviousTimeAndUpdate(IDeviceID deviceID, long time) {
        if (this.previousTimeSet && this.previousTime >= time) {
            throw new CompactionLastTimeCheckFailedException(deviceID.toString(), time, this.previousTime);
        }
        this.previousTime = time;
        this.previousTimeSet = true;
    }

    public boolean hasUnsortedDataOrWrongStatistics() {
        return this.hasUnsortedDataOrWrongStatistics;
    }

    public boolean isBrokenFile() {
        return this.isBrokenFile;
    }

    public static List<TsFileResource> checkTimePartitionHasOverlap(List<TsFileResource> resources, boolean printOverlappedDevices) {
        ArrayList<TsFileResource> overlapResources = new ArrayList<TsFileResource>();
        HashMap<IDeviceID, Long> deviceEndTimeMap = new HashMap<IDeviceID, Long>();
        for (TsFileResource resource : resources) {
            DeviceTimeIndex deviceTimeIndex;
            if (resource.getStatus() == TsFileResourceStatus.UNCLOSED || resource.getStatus() == TsFileResourceStatus.DELETED) continue;
            try {
                deviceTimeIndex = RepairDataFileScanUtil.getDeviceTimeIndex(resource);
            }
            catch (Exception ignored) {
                continue;
            }
            Set<IDeviceID> devices = deviceTimeIndex.getDevices();
            boolean fileHasOverlap = false;
            for (IDeviceID device : devices) {
                long deviceEndTimeInPreviousFile;
                long deviceStartTimeInCurrentFile = deviceTimeIndex.getStartTime(device).get();
                if (deviceStartTimeInCurrentFile > deviceTimeIndex.getEndTime(device).get() || !deviceEndTimeMap.containsKey(device) || deviceStartTimeInCurrentFile > (deviceEndTimeInPreviousFile = ((Long)deviceEndTimeMap.get(device)).longValue())) continue;
                if (printOverlappedDevices) {
                    logger.error("Device {} has overlapped data, start time in current file is {}, end time in previous file is {}", new Object[]{device, deviceStartTimeInCurrentFile, deviceEndTimeInPreviousFile});
                }
                fileHasOverlap = true;
                overlapResources.add(resource);
                break;
            }
            if (fileHasOverlap) continue;
            for (IDeviceID device : devices) {
                deviceEndTimeMap.put(device, deviceTimeIndex.getEndTime(device).get());
            }
        }
        return overlapResources;
    }

    private static DeviceTimeIndex getDeviceTimeIndex(TsFileResource resource) throws IOException {
        ITimeIndex timeIndex = resource.getTimeIndex();
        if (timeIndex instanceof DeviceTimeIndex) {
            return (DeviceTimeIndex)timeIndex;
        }
        return CompactionUtils.buildDeviceTimeIndex(resource);
    }
}

