/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.ainode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TAINodeConfiguration;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class RegisterAINodePlan
extends ConfigPhysicalPlan {
    private TAINodeConfiguration aiNodeConfiguration;

    public RegisterAINodePlan() {
        super(ConfigPhysicalPlanType.RegisterAINode);
    }

    public RegisterAINodePlan(TAINodeConfiguration aiNodeConfiguration) {
        this();
        this.aiNodeConfiguration = aiNodeConfiguration;
    }

    public TAINodeConfiguration getAINodeConfiguration() {
        return this.aiNodeConfiguration;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ThriftCommonsSerDeUtils.serializeTAINodeInfo((TAINodeConfiguration)this.aiNodeConfiguration, (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.aiNodeConfiguration = ThriftCommonsSerDeUtils.deserializeTAINodeInfo((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterAINodePlan that = (RegisterAINodePlan)o;
        return this.aiNodeConfiguration.equals(that.aiNodeConfiguration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aiNodeConfiguration);
    }
}

