/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.AnalyzeVisitor;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.TemplatedInfo;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.planner.LogicalPlanBuilder;
import org.apache.iotdb.db.queryengine.plan.planner.LogicalPlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.TemplatedLogicalPlanBuilder;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class TemplatedLogicalPlan {
    private final Analysis analysis;
    private final QueryStatement queryStatement;
    private final MPPQueryContext context;
    private final List<String> measurementList;
    private final List<IMeasurementSchema> schemaList;
    private final long limitValue;
    private static final long OFFSET_VALUE = 0L;
    private final Expression whereExpression;
    private List<String> newMeasurementList;
    private List<IMeasurementSchema> newSchemaList;
    private Map<String, List<InputLocation>> filterLayoutMap;
    List<AggregationDescriptor> aggregationDescriptorList;

    public TemplatedLogicalPlan(Analysis analysis, QueryStatement queryStatement, MPPQueryContext context) {
        this.analysis = analysis;
        this.queryStatement = queryStatement;
        this.context = context;
        this.measurementList = analysis.getMeasurementList();
        this.schemaList = analysis.getMeasurementSchemaList();
        this.newMeasurementList = this.measurementList;
        this.newSchemaList = this.schemaList;
        this.limitValue = LogicalPlanVisitor.pushDownLimitToScanNode(queryStatement, analysis);
        this.whereExpression = analysis.getWhereExpression();
        if (queryStatement.isAggregationQuery()) {
            this.initAggQueryCommonVariables();
        } else {
            this.initNonAggQueryCommonVariables();
        }
    }

    private void initAggQueryCommonVariables() {
        if (this.whereExpression != null) {
            this.newMeasurementList = new ArrayList<String>(this.measurementList);
            this.newSchemaList = new ArrayList<IMeasurementSchema>(this.schemaList);
            HashSet<String> selectMeasurements = new HashSet<String>(this.measurementList);
            List<Expression> whereSourceExpressions = ExpressionAnalyzer.searchSourceExpressions(this.whereExpression);
            for (Expression expression : whereSourceExpressions) {
                if (!(expression instanceof TimeSeriesOperand)) continue;
                String measurement = ((TimeSeriesOperand)expression).getPath().getMeasurement();
                if (!this.analysis.getDeviceTemplate().getSchemaMap().containsKey(measurement) || selectMeasurements.contains(measurement)) continue;
                this.newMeasurementList.add(measurement);
                this.newSchemaList.add(this.analysis.getDeviceTemplate().getSchema(measurement));
            }
            this.filterLayoutMap = TemplatedInfo.makeLayout(this.newMeasurementList);
            this.analysis.getExpressionTypes().forEach((key, value) -> this.context.getTypeProvider().setTreeModelType(((Expression)key.getNode()).getOutputSymbol(), (TSDataType)value));
        }
        if (this.queryStatement.isOutputEndTime()) {
            this.context.getTypeProvider().setTreeModelType(AnalyzeVisitor.END_TIME_EXPRESSION.getOutputSymbol(), TSDataType.INT64);
        }
        if (this.queryStatement.isCountTimeAggregation()) {
            this.context.getTypeProvider().setTreeModelType("count_time(*)", TSDataType.INT64);
            this.context.getTypeProvider().setTreeModelType("count_time(Time)", TSDataType.INT64);
        }
        ArrayList<Integer> deviceToMeasurementIndexes = new ArrayList<Integer>(this.analysis.getAggregationExpressions().size());
        for (int i = 1; i <= this.analysis.getAggregationExpressions().size(); ++i) {
            deviceToMeasurementIndexes.add(i);
        }
        this.context.getTypeProvider().setTemplatedInfo(new TemplatedInfo(this.newMeasurementList, this.newSchemaList, this.newSchemaList.stream().map(IMeasurementSchema::getType).collect(Collectors.toList()), this.queryStatement.getResultTimeOrder(), this.analysis.isLastLevelUseWildcard(), this.analysis.getDeviceViewOutputExpressions().stream().map(Expression::getExpressionString).collect(Collectors.toList()), deviceToMeasurementIndexes, 0L, this.limitValue, this.whereExpression, this.queryStatement.isGroupByTime(), this.analysis.getDeviceTemplate().getSchemaMap(), this.filterLayoutMap, null, true, this.analysis.getGroupByTimeParameter(), this.queryStatement.isOutputEndTime()));
    }

    private void initNonAggQueryCommonVariables() {
        if (this.whereExpression != null) {
            if (!this.analysis.isTemplateWildCardQuery()) {
                this.newMeasurementList = new ArrayList<String>(this.measurementList);
                this.newSchemaList = new ArrayList<IMeasurementSchema>(this.schemaList);
                HashSet<String> selectExpressions = new HashSet<String>(this.measurementList);
                List<Expression> whereSourceExpressions = ExpressionAnalyzer.searchSourceExpressions(this.whereExpression);
                for (Expression expression : whereSourceExpressions) {
                    if (!(expression instanceof TimeSeriesOperand)) continue;
                    String measurement = ((TimeSeriesOperand)expression).getPath().getMeasurement();
                    if (!this.analysis.getDeviceTemplate().getSchemaMap().containsKey(measurement) || selectExpressions.contains(measurement)) continue;
                    selectExpressions.add(measurement);
                    this.newMeasurementList.add(measurement);
                    this.newSchemaList.add(this.analysis.getDeviceTemplate().getSchema(measurement));
                }
            }
            this.filterLayoutMap = TemplatedInfo.makeLayout(this.newMeasurementList);
            this.analysis.getExpressionTypes().forEach((key, value) -> this.context.getTypeProvider().setTreeModelType(((Expression)key.getNode()).getOutputSymbol(), (TSDataType)value));
        }
        ArrayList<Integer> deviceToMeasurementIndexes = new ArrayList<Integer>(this.analysis.getSelectExpressions().size() - 1);
        for (int i = 1; i < this.analysis.getSelectExpressions().size(); ++i) {
            deviceToMeasurementIndexes.add(i);
        }
        this.context.getTypeProvider().setTemplatedInfo(new TemplatedInfo(this.newMeasurementList, this.newSchemaList, this.newSchemaList.stream().map(IMeasurementSchema::getType).collect(Collectors.toList()), this.queryStatement.getResultTimeOrder(), this.analysis.isLastLevelUseWildcard(), this.analysis.getDeviceViewOutputExpressions().stream().map(Expression::getExpressionString).collect(Collectors.toList()), deviceToMeasurementIndexes, 0L, this.limitValue, this.whereExpression, this.queryStatement.isGroupByTime(), this.analysis.getDeviceTemplate().getSchemaMap(), this.filterLayoutMap, null, false, this.analysis.getGroupByTimeParameter(), this.queryStatement.isOutputEndTime()));
    }

    public PlanNode visitQuery() {
        if (this.queryStatement.isAggregationQuery()) {
            return this.visitAggregation();
        }
        LogicalPlanBuilder planBuilder = new TemplatedLogicalPlanBuilder(this.analysis, this.context, this.measurementList, this.schemaList);
        LinkedHashMap<IDeviceID, PlanNode> deviceToSubPlanMap = new LinkedHashMap<IDeviceID, PlanNode>();
        for (PartialPath devicePath : this.analysis.getDeviceList()) {
            IDeviceID deviceID = devicePath.getIDeviceIDAsFullDevice();
            PlanNode rootNode = this.visitQueryBody(devicePath);
            LogicalPlanBuilder subPlanBuilder = new TemplatedLogicalPlanBuilder(this.analysis, this.context, this.measurementList, this.schemaList).withNewRoot(rootNode);
            if (this.queryStatement.needPushDownSort()) {
                subPlanBuilder = subPlanBuilder.planOrderBy(this.analysis.getDeviceToOrderByExpressions().get(deviceID), this.analysis.getDeviceToSortItems().get(deviceID));
            }
            deviceToSubPlanMap.put(deviceID, subPlanBuilder.getRoot());
        }
        planBuilder = planBuilder.planDeviceView(deviceToSubPlanMap, this.analysis.getDeviceViewOutputExpressions(), this.analysis.getDeviceViewInputIndexesMap(), this.analysis.getSelectExpressions(), this.queryStatement, this.analysis);
        if (!this.queryStatement.needPushDownSort()) {
            planBuilder = planBuilder.planOrderBy(this.queryStatement, this.analysis);
        }
        planBuilder = planBuilder.planFill(this.analysis.getFillDescriptor(), this.queryStatement.getResultTimeOrder()).planOffset(this.queryStatement.getRowOffset());
        if (!this.analysis.isUseTopKNode() || this.queryStatement.hasOffset()) {
            planBuilder = planBuilder.planLimit(this.queryStatement.getRowLimit());
        }
        return planBuilder.getRoot();
    }

    public PlanNode visitQueryBody(PartialPath devicePath) {
        TemplatedLogicalPlanBuilder planBuilder = new TemplatedLogicalPlanBuilder(this.analysis, this.context, this.newMeasurementList, this.newSchemaList);
        planBuilder = planBuilder.planRawDataSource(devicePath, this.queryStatement.getResultTimeOrder(), 0L, this.limitValue, this.analysis.isLastLevelUseWildcard()).planFilter(this.whereExpression, this.queryStatement.isGroupByTime(), this.queryStatement.getResultTimeOrder());
        return planBuilder.getRoot();
    }

    private PlanNode visitAggregation() {
        boolean outputPartial = this.queryStatement.isGroupByTime() && this.analysis.getGroupByTimeParameter().hasOverlap();
        AggregationStep curStep = outputPartial ? AggregationStep.PARTIAL : AggregationStep.SINGLE;
        this.aggregationDescriptorList = this.constructAggregationDescriptorList(this.analysis.getAggregationExpressions(), curStep);
        this.updateTypeProvider(this.analysis.getAggregationExpressions());
        if (curStep.isOutputPartial()) {
            this.aggregationDescriptorList.forEach(aggregationDescriptor -> LogicalPlanBuilder.updateTypeProviderByPartialAggregation(aggregationDescriptor, this.context.getTypeProvider()));
        }
        LogicalPlanBuilder templatedPlanBuilder = new TemplatedLogicalPlanBuilder(this.analysis, this.context, this.measurementList, this.schemaList);
        LinkedHashMap<IDeviceID, PlanNode> deviceToSubPlanMap = new LinkedHashMap<IDeviceID, PlanNode>();
        this.aggregationDescriptorList = AggregationNode.getDeduplicatedDescriptors(this.aggregationDescriptorList);
        boolean needCheckAscending = this.queryStatement.isGroupByTime();
        ArrayList<AggregationDescriptor> ascendingDescriptors = new ArrayList<AggregationDescriptor>();
        ArrayList<AggregationDescriptor> descendingDescriptors = new ArrayList<AggregationDescriptor>();
        for (AggregationDescriptor aggregationDescriptor2 : this.aggregationDescriptorList) {
            if (needCheckAscending || SchemaUtils.isConsistentWithScanOrder(aggregationDescriptor2.getAggregationType(), this.queryStatement.getResultTimeOrder())) {
                ascendingDescriptors.add(aggregationDescriptor2);
                continue;
            }
            descendingDescriptors.add(aggregationDescriptor2);
        }
        this.context.getTypeProvider().getTemplatedInfo().setAscendingDescriptorList(ascendingDescriptors);
        this.context.getTypeProvider().getTemplatedInfo().setDescendingDescriptorList(descendingDescriptors);
        for (PartialPath devicePath : this.analysis.getDeviceList()) {
            IDeviceID deviceName = devicePath.getIDeviceID();
            PlanNode rootNode = this.visitDeviceAggregationBody(devicePath);
            TemplatedLogicalPlanBuilder subPlanBuilder = new TemplatedLogicalPlanBuilder(this.analysis, this.context, this.measurementList, this.schemaList).withNewRoot(rootNode);
            deviceToSubPlanMap.put(deviceName, subPlanBuilder.getRoot());
        }
        templatedPlanBuilder = templatedPlanBuilder.planDeviceView(deviceToSubPlanMap, this.analysis.getDeviceViewOutputExpressions(), null, this.analysis.getSelectExpressions(), this.queryStatement, this.analysis).planHavingAndTransform(this.analysis.getHavingExpression(), this.analysis.getSelectExpressions(), this.analysis.getOrderByExpressions(), this.queryStatement.isGroupByTime(), this.queryStatement.getResultTimeOrder());
        if (!this.queryStatement.needPushDownSort()) {
            templatedPlanBuilder = templatedPlanBuilder.planOrderBy(this.queryStatement, this.analysis);
        }
        templatedPlanBuilder = templatedPlanBuilder.planFill(this.analysis.getFillDescriptor(), this.queryStatement.getResultTimeOrder()).planOffset(this.queryStatement.getRowOffset());
        if (!this.analysis.isUseTopKNode() || this.queryStatement.hasOffset()) {
            templatedPlanBuilder = templatedPlanBuilder.planLimit(this.queryStatement.getRowLimit());
        }
        return templatedPlanBuilder.getRoot();
    }

    private PlanNode visitDeviceAggregationBody(PartialPath devicePath) {
        TemplatedLogicalPlanBuilder templatedPlanBuilder = new TemplatedLogicalPlanBuilder(this.analysis, this.context, this.newMeasurementList, this.newSchemaList);
        templatedPlanBuilder = templatedPlanBuilder.planRawDataSource(devicePath, this.queryStatement.getResultTimeOrder(), 0L, this.limitValue, this.analysis.isLastLevelUseWildcard()).planFilter(this.whereExpression, this.queryStatement.isGroupByTime(), this.queryStatement.getResultTimeOrder()).planRawDataAggregation(this.analysis.getAggregationExpressions(), null, this.analysis.getGroupByTimeParameter(), this.analysis.getGroupByParameter(), this.queryStatement.isOutputEndTime(), this.queryStatement.getResultTimeOrder(), this.aggregationDescriptorList).planSlidingWindowAggregation(this.queryStatement, this.analysis.getAggregationExpressions(), this.analysis.getGroupByTimeParameter(), this.queryStatement.getResultTimeOrder());
        return templatedPlanBuilder.getRoot();
    }

    private List<AggregationDescriptor> constructAggregationDescriptorList(Set<Expression> aggregationExpressions, AggregationStep curStep) {
        return aggregationExpressions.stream().map(expression -> {
            Validate.isTrue((boolean)(expression instanceof FunctionExpression));
            return new AggregationDescriptor(((FunctionExpression)expression).getFunctionName(), curStep, expression.getExpressions(), ((FunctionExpression)expression).getFunctionAttributes());
        }).collect(Collectors.toList());
    }

    void updateTypeProvider(Collection<Expression> expressions) {
        if (expressions == null) {
            return;
        }
        expressions.forEach(expression -> {
            if (!expression.getExpressionString().equals("Device") && !expression.getExpressionString().equals("__endTime")) {
                this.context.getTypeProvider().setTreeModelType(expression.getExpressionString(), this.getPreAnalyzedType((Expression)expression));
            }
        });
    }

    private TSDataType getPreAnalyzedType(Expression expression) {
        return this.analysis.getType(expression);
    }
}

