/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SortItem;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class OrderBy
extends Node {
    private final List<SortItem> sortItems;

    public OrderBy(List<SortItem> sortItems) {
        super(null);
        Objects.requireNonNull(sortItems, "sortItems is null");
        Preconditions.checkArgument((!sortItems.isEmpty() ? 1 : 0) != 0, (Object)"sortItems should not be empty");
        this.sortItems = ImmutableList.copyOf(sortItems);
    }

    public OrderBy(NodeLocation location, List<SortItem> sortItems) {
        super(Objects.requireNonNull(location, "location is null"));
        Objects.requireNonNull(sortItems, "sortItems is null");
        Preconditions.checkArgument((!sortItems.isEmpty() ? 1 : 0) != 0, (Object)"sortItems should not be empty");
        this.sortItems = ImmutableList.copyOf(sortItems);
    }

    public List<SortItem> getSortItems() {
        return this.sortItems;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitOrderBy(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.sortItems;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sortItems", this.sortItems).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OrderBy o = (OrderBy)obj;
        return Objects.equals(this.sortItems, o.sortItems);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sortItems);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return OrderBy.sameClass(this, other);
    }

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((int)this.sortItems.size(), (ByteBuffer)buffer);
        for (SortItem sortItem : this.sortItems) {
            sortItem.serialize(buffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.sortItems.size(), (OutputStream)stream);
        for (SortItem sortItem : this.sortItems) {
            sortItem.serialize(stream);
        }
    }

    public OrderBy(ByteBuffer byteBuffer) {
        super(null);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.sortItems = new ArrayList<SortItem>(size);
        for (int i = 0; i < size; ++i) {
            this.sortItems.add(new SortItem(byteBuffer));
        }
    }
}

