/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.util.EnumSet;
import java.util.Locale;
import java.util.stream.Collectors;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.xpack.XPackInfoRequest;
import org.elasticsearch.client.xpack.XPackUsageRequest;

final class XPackRequestConverters {
    private XPackRequestConverters() {
    }

    static Request info(XPackInfoRequest infoRequest) {
        Request request = new Request("GET", "/_xpack");
        if (!infoRequest.isVerbose()) {
            request.addParameter("human", "false");
        }
        if (!infoRequest.getCategories().equals(EnumSet.allOf(XPackInfoRequest.Category.class))) {
            request.addParameter("categories", infoRequest.getCategories().stream().map(c -> c.toString().toLowerCase(Locale.ROOT)).collect(Collectors.joining(",")));
        }
        return request;
    }

    static Request usage(XPackUsageRequest usageRequest) {
        Request request = new Request("GET", "/_xpack/usage");
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withMasterTimeout(usageRequest.masterNodeTimeout());
        request.addParameters(parameters.asMap());
        return request;
    }
}

