/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.mail.MessagingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.apache.mailet.base.MailetUtil;

public class AtMost
extends GenericMatcher {
    static final AttributeName AT_MOST_EXECUTIONS = AttributeName.of((String)"AT_MOST_EXECUTIONS");
    private static final String CONDITION_SEPARATOR = ":";
    private static final int ONLY_CONDITION_VALUE = 1;
    private static final int CONDITION_NAME_AND_VALUE = 2;
    private AttributeName attributeName;
    private Integer atMostExecutions;

    public void init() throws MessagingException {
        String conditionConfig = this.getMatcherConfig().getCondition();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)conditionConfig), (Object)"MatcherConfiguration is mandatory!");
        Preconditions.checkArgument((!conditionConfig.startsWith(CONDITION_SEPARATOR) ? 1 : 0) != 0, (String)"MatcherConfiguration can not start with '%s'", (Object)CONDITION_SEPARATOR);
        List conditions = Splitter.on((String)CONDITION_SEPARATOR).splitToList((CharSequence)conditionConfig);
        this.attributeName = this.parseAttribute(conditions);
        this.atMostExecutions = this.parseAttributeValue(conditions);
    }

    private AttributeName parseAttribute(List<String> conditions) {
        switch (conditions.size()) {
            case 1: {
                return AT_MOST_EXECUTIONS;
            }
            case 2: {
                return AttributeName.of((String)conditions.get(0));
            }
        }
        throw new IllegalArgumentException("MatcherConfiguration format should follow: 'name:value' or 'value'");
    }

    private Integer parseAttributeValue(List<String> conditions) throws MessagingException {
        switch (conditions.size()) {
            case 1: {
                return MailetUtil.getInitParameterAsStrictlyPositiveInteger((String)conditions.get(0));
            }
            case 2: {
                return MailetUtil.getInitParameterAsStrictlyPositiveInteger((String)conditions.get(1));
            }
        }
        throw new IllegalArgumentException("MatcherConfiguration format should follow: 'name:value' or 'value'");
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        return AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)this.attributeName, Integer.class).or(() -> Optional.of(0)).filter(executions -> executions < this.atMostExecutions).map(executions -> {
            mail.setAttribute(new Attribute(this.attributeName, AttributeValue.of((Integer)(executions + 1))));
            return mail.getRecipients();
        }).orElse((Collection)ImmutableList.of());
    }
}

