/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;

public class CertificateUtil {
    private static final String SSL_HANDLER_NAME = "ssl";

    public static X509Certificate[] getCertsFromConnection(RemotingConnection remotingConnection) {
        Connection transportConnection;
        X509Certificate[] certificates = null;
        if (remotingConnection != null && (transportConnection = remotingConnection.getTransportConnection()) instanceof NettyConnection) {
            certificates = org.apache.activemq.artemis.utils.CertificateUtil.getCertsFromChannel((Channel)((NettyConnection)transportConnection).getChannel());
        }
        return certificates;
    }

    public static Principal getPeerPrincipalFromConnection(RemotingConnection remotingConnection) {
        NettyConnection nettyConnection;
        ChannelHandler channelHandler;
        Connection transportConnection;
        Principal result = null;
        if (remotingConnection != null && (transportConnection = remotingConnection.getTransportConnection()) instanceof NettyConnection && (channelHandler = (nettyConnection = (NettyConnection)transportConnection).getChannel().pipeline().get(SSL_HANDLER_NAME)) != null && channelHandler instanceof SslHandler) {
            SslHandler sslHandler = (SslHandler)channelHandler;
            try {
                result = sslHandler.engine().getSession().getPeerPrincipal();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Principal getLocalPrincipalFromConnection(NettyConnection nettyConnection) {
        Principal result = null;
        ChannelHandler handler = nettyConnection.getChannel().pipeline().get(SSL_HANDLER_NAME);
        if (handler instanceof SslHandler) {
            SslHandler sslHandler = (SslHandler)handler;
            result = sslHandler.engine().getSession().getLocalPrincipal();
        }
        return result;
    }
}

