/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup.zip;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipEntryIterator
implements Iterator<ZipEntry>,
Closeable {
    private final ZipInputStream zipInputStream;
    private Optional<ZipEntry> next;
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipEntryIterator.class);

    public ZipEntryIterator(ZipInputStream inputStream) {
        this.zipInputStream = inputStream;
        try {
            this.next = Optional.ofNullable(this.zipInputStream.getNextEntry());
        }
        catch (IOException e) {
            LOGGER.error("Empty stream or error during reading first entry", (Throwable)e);
            this.next = Optional.empty();
        }
    }

    @Override
    public boolean hasNext() {
        return this.next.isPresent();
    }

    @Override
    public ZipEntry next() {
        Optional<ZipEntry> current = this.next;
        if (!current.isPresent()) {
            return null;
        }
        ZipEntry currentEntry = current.get();
        this.advanceToNextEntry();
        return currentEntry;
    }

    private void advanceToNextEntry() {
        try {
            this.next = Optional.ofNullable(this.zipInputStream.getNextEntry());
        }
        catch (IOException e) {
            LOGGER.error("Error when reading archive", (Throwable)e);
            this.next = Optional.empty();
        }
    }

    @Override
    public void close() throws IOException {
        this.zipInputStream.close();
    }
}

