/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.json;

import org.apache.james.json.DTO;
import org.apache.james.json.DTOModule;

public class DTOModule<T, U extends DTO> {
    private final DTOConverter<T, U> converter;
    private final DomainObjectConverter<T, U> toDomainObjectConverter;
    private final Class<T> domainObjectType;
    private final Class<U> dtoType;
    private final String typeName;

    public static <T> Builder<T> forDomainObject(Class<T> domainObjectType) {
        return new Builder<T>(domainObjectType);
    }

    protected DTOModule(DTOConverter<T, U> converter, DomainObjectConverter<T, U> toDomainObjectConverter, Class<T> domainObjectType, Class<U> dtoType, String typeName) {
        this.converter = converter;
        this.toDomainObjectConverter = toDomainObjectConverter;
        this.domainObjectType = domainObjectType;
        this.dtoType = dtoType;
        this.typeName = typeName;
    }

    public DomainObjectConverter<T, U> getToDomainObjectConverter() {
        return this.toDomainObjectConverter;
    }

    public String getDomainObjectType() {
        return this.typeName;
    }

    public Class<U> getDTOClass() {
        return this.dtoType;
    }

    public Class<T> getDomainObjectClass() {
        return this.domainObjectType;
    }

    public U toDTO(T domainObject) {
        return this.converter.convert(domainObject, this.typeName);
    }

    public static class Builder<T> {
        private final Class<T> type;

        public Builder(Class<T> type) {
            this.type = type;
        }

        public <U extends DTO> RequireToDomainObjectConverterBuilder<U> convertToDTO(Class<U> dtoType) {
            return new RequireToDomainObjectConverterBuilder<U>(dtoType);
        }

        public class RequireToDomainObjectConverterBuilder<U extends DTO> {
            private final Class<U> dtoType;

            RequireToDomainObjectConverterBuilder(Class<U> dtoType) {
                this.dtoType = dtoType;
            }

            public RequireToDTOConverterBuilder toDomainObjectConverter(DomainObjectConverter<T, U> converter) {
                return new RequireToDTOConverterBuilder(converter);
            }

            public class RequireToDTOConverterBuilder {
                private DomainObjectConverter<T, U> toDomainObjectConverter;

                private RequireToDTOConverterBuilder(DomainObjectConverter<T, U> toDomainObjectConverter) {
                    this.toDomainObjectConverter = toDomainObjectConverter;
                }

                public org.apache.james.json.DTOModule$Builder$RequireToDomainObjectConverterBuilder$RequireToDTOConverterBuilder.RequireTypeNameBuilder toDTOConverter(DTOConverter<T, U> converter) {
                    return new RequireTypeNameBuilder(converter);
                }

                public class RequireTypeNameBuilder {
                    private final DTOConverter<T, U> converter;

                    private RequireTypeNameBuilder(DTOConverter<T, U> converter) {
                        this.converter = converter;
                    }

                    public org.apache.james.json.DTOModule$Builder$RequireToDomainObjectConverterBuilder$RequireToDTOConverterBuilder.RequireTypeNameBuilder.RequireModuleFactory typeName(String typeName) {
                        return new RequireModuleFactory(typeName);
                    }

                    public class RequireModuleFactory {
                        private final String typeName;

                        private RequireModuleFactory(String typeName) {
                            this.typeName = typeName;
                        }

                        public <ModuleTypeT extends DTOModule<T, U>> ModuleTypeT withFactory(ModuleFactory<T, U, ModuleTypeT> factory) {
                            return factory.create(RequireTypeNameBuilder.this.converter, RequireToDTOConverterBuilder.this.toDomainObjectConverter, Builder.this.type, RequireToDomainObjectConverterBuilder.this.dtoType, this.typeName);
                        }
                    }
                }
            }
        }
    }

    public static interface ModuleFactory<T, U extends DTO, ModuleTypeT extends DTOModule<T, U>> {
        public ModuleTypeT create(DTOConverter<T, U> var1, DomainObjectConverter<T, U> var2, Class<T> var3, Class<U> var4, String var5);
    }

    public static interface DomainObjectConverter<T, U extends DTO> {
        public T convert(U var1);
    }

    public static interface DTOConverter<T, U extends DTO> {
        public U convert(T var1, String var2);
    }
}

