/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import eu.timepit.refined.package$;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.mail.EmailView;
import org.apache.james.jmap.mail.UnparsedEmailId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Email$ {
    public static final Email$ MODULE$ = new Email$();
    private static final Logger logger = LoggerFactory.getLogger(EmailView.class);
    private static final Properties defaultProperties = Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"id")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"blobId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"threadId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"mailboxIds")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"keywords")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"size")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"receivedAt")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"messageId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"inReplyTo")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"references")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"sender")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"from")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"to")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"cc")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bcc")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"replyTo")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"subject")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"sentAt")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"hasAttachment")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"preview")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bodyValues")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"textBody")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"htmlBody")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"attachments")).value()))}));
    private static final Properties allowedProperties = Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"id")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"size")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bodyStructure")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"textBody")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"htmlBody")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"attachments")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"headers")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bodyValues")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"messageId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"inReplyTo")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"references")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"to")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"cc")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bcc")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"from")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"sender")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"replyTo")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"subject")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"sentAt")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"mailboxIds")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"blobId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"threadId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"receivedAt")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"preview")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"hasAttachment")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"keywords")).value()))}));
    private static final Properties idProperty = Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"id")).value()))}));

    private Logger logger() {
        return logger;
    }

    public Properties defaultProperties() {
        return defaultProperties;
    }

    public Properties allowedProperties() {
        return allowedProperties;
    }

    public Properties idProperty() {
        return idProperty;
    }

    public Try<UnparsedEmailId> asUnparsed(MessageId messageId) {
        Either either = package$.MODULE$.refineV().apply((Object)messageId.serialize(), Id$.MODULE$.validateId());
        if (either instanceof Left) {
            Left left = (Left)either;
            String e = (String)left.value();
            return new Failure((Throwable)new IllegalArgumentException(e));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            String value = (String)((Refined)right.value()).value();
            return new Success((Object)new UnparsedEmailId(value));
        }
        throw new MatchError((Object)either);
    }

    public Try<Message> parseAsMime4JMessage(MessageResult firstMessage) {
        DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
        defaultMessageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        defaultMessageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        InputStream inputStream = firstMessage.getFullContent().getInputStream();
        Try resultMessage = Try$.MODULE$.apply((Function0 & Serializable)() -> defaultMessageBuilder.parseMessage(inputStream));
        return (Try)resultMessage.fold((Function1 & Serializable)e -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> inputStream.close()).flatMap((Function1 & Serializable)closeFailure -> {
            MODULE$.logger().error(new StringBuilder(16).append("Could not close ").append(inputStream).toString(), closeFailure);
            return new Failure(e);
        }), (Function1 & Serializable)msg -> (Success)Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> inputStream.close()).fold((Function1 & Serializable)closeFailure -> {
            MODULE$.logger().error(new StringBuilder(16).append("Could not close ").append(inputStream).toString(), closeFailure);
            return new Success(msg);
        }, (Function1 & Serializable)x$1 -> new Success(msg)));
    }

    private Email$() {
    }
}

