/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.jmap.draft.exceptions.JmapFieldNotSupportedException;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.model.JmapRuleDTO;

@JsonDeserialize(builder=Builder.class)
public class SetFilterRequest
implements JmapRequest {
    private static final String ISSUER = "SetFilterRequest";
    private final List<JmapRuleDTO> singleton;

    public static Builder builder() {
        return new Builder();
    }

    private SetFilterRequest(List<JmapRuleDTO> singleton) {
        this.singleton = singleton;
    }

    public List<JmapRuleDTO> getSingleton() {
        return this.singleton;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private final ImmutableList.Builder<JmapRuleDTO> rules = ImmutableList.builder();

        private Builder() {
        }

        public Builder accountId(String accountId) {
            if (accountId != null) {
                throw new JmapFieldNotSupportedException(SetFilterRequest.ISSUER, "accountId");
            }
            return this;
        }

        public Builder ifInState(String ifInState) {
            if (ifInState != null) {
                throw new JmapFieldNotSupportedException(SetFilterRequest.ISSUER, "ifInState");
            }
            return this;
        }

        public Builder singleton(List<JmapRuleDTO> rules) {
            this.rules.addAll(rules);
            return this;
        }

        public SetFilterRequest build() {
            return new SetFilterRequest((List<JmapRuleDTO>)this.rules.build());
        }
    }
}

