/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.core.MailAddress;
import org.apache.james.queue.rabbitmq.EnqueuedItem;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.cassandra.EnqueuedMailsDaoUtil;
import org.apache.james.queue.rabbitmq.view.cassandra.model.BucketedSlices;
import org.apache.james.queue.rabbitmq.view.cassandra.model.EnqueuedItemWithSlicingContext;
import org.apache.mailet.Mail;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EnqueuedMailsDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement selectFrom;
    private final PreparedStatement selectBlobIds;
    private final PreparedStatement insert;
    private final PreparedStatement deleteBucket;
    private final BlobId.Factory blobFactory;
    private final TupleType userHeaderNameHeaderValueTriple;

    @Inject
    @VisibleForTesting
    public EnqueuedMailsDAO(Session session, BlobId.Factory blobIdFactory) {
        this.executor = new CassandraAsyncExecutor(session);
        this.selectFrom = this.prepareSelectFrom(session);
        this.insert = this.prepareInsert(session);
        this.deleteBucket = this.prepareDeleteBucket(session);
        this.selectBlobIds = this.prepareSelectBlobIds(session);
        this.blobFactory = blobIdFactory;
        this.userHeaderNameHeaderValueTriple = session.getCluster().getMetadata().newTupleType(new DataType[]{DataType.text(), DataType.text(), DataType.text()});
    }

    private PreparedStatement prepareSelectFrom(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("enqueuedMailsV4").where(QueryBuilder.eq((String)"queueName", (Object)QueryBuilder.bindMarker((String)"queueName"))).and(QueryBuilder.eq((String)"timeRangeStart", (Object)QueryBuilder.bindMarker((String)"timeRangeStart"))).and(QueryBuilder.eq((String)"bucketId", (Object)QueryBuilder.bindMarker((String)"bucketId"))));
    }

    private PreparedStatement prepareSelectBlobIds(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"headerBlobId", "bodyBlobId"}).from("enqueuedMailsV4"));
    }

    private PreparedStatement prepareDeleteBucket(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("enqueuedMailsV4").where(QueryBuilder.eq((String)"queueName", (Object)QueryBuilder.bindMarker((String)"queueName"))).and(QueryBuilder.eq((String)"timeRangeStart", (Object)QueryBuilder.bindMarker((String)"timeRangeStart"))).and(QueryBuilder.eq((String)"bucketId", (Object)QueryBuilder.bindMarker((String)"bucketId"))));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"enqueuedMailsV4").value("queueName", (Object)QueryBuilder.bindMarker((String)"queueName")).value("timeRangeStart", (Object)QueryBuilder.bindMarker((String)"timeRangeStart")).value("bucketId", (Object)QueryBuilder.bindMarker((String)"bucketId")).value("enqueueId", (Object)QueryBuilder.bindMarker((String)"enqueueId")).value("name", (Object)QueryBuilder.bindMarker((String)"name")).value("headerBlobId", (Object)QueryBuilder.bindMarker((String)"headerBlobId")).value("bodyBlobId", (Object)QueryBuilder.bindMarker((String)"bodyBlobId")).value("enqueuedTime", (Object)QueryBuilder.bindMarker((String)"enqueuedTime")).value("state", (Object)QueryBuilder.bindMarker((String)"state")).value("sender", (Object)QueryBuilder.bindMarker((String)"sender")).value("recipients", (Object)QueryBuilder.bindMarker((String)"recipients")).value("attributes", (Object)QueryBuilder.bindMarker((String)"attributes")).value("errorMessage", (Object)QueryBuilder.bindMarker((String)"errorMessage")).value("remoteAddr", (Object)QueryBuilder.bindMarker((String)"remoteAddr")).value("remoteHost", (Object)QueryBuilder.bindMarker((String)"remoteHost")).value("lastUpdated", (Object)QueryBuilder.bindMarker((String)"lastUpdated")).value("perRecipientSpecificHeaders", (Object)QueryBuilder.bindMarker((String)"perRecipientSpecificHeaders")));
    }

    Mono<Void> insert(EnqueuedItemWithSlicingContext enqueuedItemWithSlicing) {
        EnqueuedItem enqueuedItem = enqueuedItemWithSlicing.getEnqueuedItem();
        EnqueuedItemWithSlicingContext.SlicingContext slicingContext = enqueuedItemWithSlicing.getSlicingContext();
        Mail mail = enqueuedItem.getMail();
        MimeMessagePartsId mimeMessagePartsId = enqueuedItem.getPartsId();
        BoundStatement statement = this.insert.bind().setString("queueName", enqueuedItem.getMailQueueName().asString()).setTimestamp("timeRangeStart", Date.from(slicingContext.getTimeRangeStart())).setInt("bucketId", slicingContext.getBucketId().getValue()).setTimestamp("enqueuedTime", Date.from(enqueuedItem.getEnqueuedTime())).setUUID("enqueueId", enqueuedItem.getEnqueueId().asUUID()).setString("name", mail.getName()).setString("headerBlobId", mimeMessagePartsId.getHeaderBlobId().asString()).setString("bodyBlobId", mimeMessagePartsId.getBodyBlobId().asString()).setString("state", mail.getState()).setList("recipients", EnqueuedMailsDaoUtil.asStringList(mail.getRecipients())).setString("remoteAddr", mail.getRemoteAddr()).setString("remoteHost", mail.getRemoteHost()).setTimestamp("lastUpdated", mail.getLastUpdated()).setMap("attributes", EnqueuedMailsDaoUtil.toRawAttributeMap(mail)).setList("perRecipientSpecificHeaders", EnqueuedMailsDaoUtil.toTupleList(this.userHeaderNameHeaderValueTriple, mail.getPerRecipientSpecificHeaders()));
        Optional.ofNullable(mail.getErrorMessage()).ifPresent(errorMessage -> statement.setString("errorMessage", mail.getErrorMessage()));
        mail.getMaybeSender().asOptional().map(MailAddress::asString).ifPresent(mailAddress -> statement.setString("sender", mailAddress));
        return this.executor.executeVoid((Statement)statement);
    }

    @VisibleForTesting
    public Flux<EnqueuedItemWithSlicingContext> selectEnqueuedMails(MailQueueName queueName, BucketedSlices.Slice slice, BucketedSlices.BucketId bucketId) {
        return this.executor.executeRows((Statement)this.selectFrom.bind().setString("queueName", queueName.asString()).setTimestamp("timeRangeStart", Date.from(slice.getStartSliceInstant())).setInt("bucketId", bucketId.getValue())).map(row -> EnqueuedMailsDaoUtil.toEnqueuedMail(row, this.blobFactory));
    }

    Mono<Void> deleteBucket(MailQueueName queueName, BucketedSlices.Slice slice, BucketedSlices.BucketId bucketId) {
        return this.executor.executeVoid((Statement)this.deleteBucket.bind().setString("queueName", queueName.asString()).setTimestamp("timeRangeStart", Date.from(slice.getStartSliceInstant())).setInt("bucketId", bucketId.getValue()));
    }

    Flux<BlobId> listBlobIds() {
        return this.executor.executeRows((Statement)this.selectBlobIds.bind()).flatMapIterable(row -> ImmutableList.of((Object)this.blobFactory.from(row.getString("headerBlobId")), (Object)this.blobFactory.from(row.getString("bodyBlobId"))));
    }
}

