/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.vault.dto.DeletedMessageWithStorageInformationConverter;
import org.apache.james.vault.dto.DeletedMessageWithStorageInformationDTO;
import org.apache.james.vault.metadata.DeletedMessageWithStorageInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetadataSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataSerializer.class);
    private final ObjectMapper objectMapper;
    private final DeletedMessageWithStorageInformationConverter dtoConverter;

    @Inject
    MetadataSerializer(DeletedMessageWithStorageInformationConverter dtoConverter) {
        this.dtoConverter = dtoConverter;
        this.objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
    }

    Optional<DeletedMessageWithStorageInformation> deserialize(String payload) {
        return this.deserializeDto(payload).flatMap(this::toDomainObject);
    }

    private Optional<DeletedMessageWithStorageInformationDTO> deserializeDto(String payload) {
        try {
            return Optional.of((DeletedMessageWithStorageInformationDTO)this.objectMapper.readValue(payload, DeletedMessageWithStorageInformationDTO.class));
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing JSON metadata", (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<DeletedMessageWithStorageInformation> toDomainObject(DeletedMessageWithStorageInformationDTO dto) {
        try {
            return Optional.of(this.dtoConverter.toDomainObject(dto));
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing DTO", (Throwable)e);
            return Optional.empty();
        }
    }

    String serialize(DeletedMessageWithStorageInformation message) {
        DeletedMessageWithStorageInformationDTO dto = DeletedMessageWithStorageInformationDTO.toDTO((DeletedMessageWithStorageInformation)message);
        try {
            return this.objectMapper.writeValueAsString((Object)dto);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

