/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationParser {
    private static final String PATTERN_STRING = "\\s*(-?[0-9]+)\\s*([a-z,A-Z]*)\\s*";
    private static final int AMOUNT = 1;
    private static final int UNIT = 2;
    private static Pattern PATTERN = Pattern.compile("\\s*(-?[0-9]+)\\s*([a-z,A-Z]*)\\s*");

    private DurationParser() {
    }

    public static Duration parse(String rawString) throws NumberFormatException {
        return DurationParser.parse(rawString, ChronoUnit.MILLIS);
    }

    public static Duration parse(String rawString, ChronoUnit defaultUnit) throws NumberFormatException {
        Matcher res = PATTERN.matcher(rawString);
        if (res.matches()) {
            String unitAsString = res.group(2);
            String amountAsString = res.group(1);
            if (amountAsString != null && unitAsString != null) {
                long time = Integer.parseInt(res.group(1).trim());
                Duration unitAsDuration = DurationParser.parseUnitAsDuration(unitAsString).orElse(defaultUnit.getDuration());
                return DurationParser.computeDuration(unitAsDuration, time);
            }
        }
        throw new NumberFormatException("The supplied String is not a supported format " + rawString);
    }

    private static Duration computeDuration(Duration unitAsDuration, long time) {
        Preconditions.checkArgument(time >= 0L, "Duration amount should be positive");
        return unitAsDuration.multipliedBy(time);
    }

    private static Optional<Duration> parseUnitAsDuration(String unit) {
        if (Strings.isNullOrEmpty(unit)) {
            return Optional.empty();
        }
        return Optional.of(Unit.parse(unit).getDuration());
    }

    private static enum Unit {
        MILLI_SECONDS(ImmutableList.of("ms", "msec", "msecs"), ChronoUnit.MILLIS),
        SECONDS(ImmutableList.of("s", "sec", "secs", "second", "seconds"), ChronoUnit.SECONDS),
        MINUTES(ImmutableList.of("m", "min", "mins", "minute", "minutes"), ChronoUnit.MINUTES),
        HOURS(ImmutableList.of("h", "hour", "hours"), ChronoUnit.HOURS),
        DAYS(ImmutableList.of("d", "day", "days"), ChronoUnit.DAYS),
        WEEKS(ImmutableList.of("w", "week", "weeks"), ChronoUnit.WEEKS),
        MONTH(ImmutableList.of("month", "months"), ChronoUnit.MONTHS),
        YEARS(ImmutableList.of("y", "year", "years"), ChronoUnit.YEARS);

        private final List<String> validPatterns;
        private final ChronoUnit unit;

        public static ChronoUnit parse(String string) {
            return Arrays.stream(Unit.values()).filter(value -> value.validPatterns.contains(string.toLowerCase(Locale.US))).findFirst().map(entry -> entry.unit).orElseThrow(() -> new NumberFormatException("Unknown unit: " + string));
        }

        private Unit(List<String> validPatterns, ChronoUnit unit) {
            this.validPatterns = validPatterns;
            this.unit = unit;
        }
    }
}

