/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.cassandra.table.CassandraAttachmentMessageIdTable;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.MessageId;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraAttachmentMessageIdDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectStatement;
    private final PreparedStatement listStatement;
    private final PreparedStatement deleteStatement;
    private final MessageId.Factory messageIdFactory;

    @Inject
    public CassandraAttachmentMessageIdDAO(CqlSession session, MessageId.Factory messageIdFactory) {
        this.messageIdFactory = messageIdFactory;
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.selectStatement = this.prepareSelect(session);
        this.insertStatement = this.prepareInsert(session);
        this.deleteStatement = this.prepareDelete(session);
        this.listStatement = this.prepareList(session);
    }

    private PreparedStatement prepareInsert(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"attachmentMessageId").value(CassandraAttachmentMessageIdTable.ATTACHMENT_ID_AS_UUID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentMessageIdTable.ATTACHMENT_ID_AS_UUID)).value(CassandraAttachmentMessageIdTable.ATTACHMENT_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentMessageIdTable.ATTACHMENT_ID)).value(CassandraAttachmentMessageIdTable.MESSAGE_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentMessageIdTable.MESSAGE_ID)).build());
    }

    private PreparedStatement prepareDelete(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"attachmentMessageId").where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraAttachmentMessageIdTable.ATTACHMENT_ID_AS_UUID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentMessageIdTable.ATTACHMENT_ID_AS_UUID)), (Relation)Relation.column((CqlIdentifier)CassandraAttachmentMessageIdTable.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentMessageIdTable.MESSAGE_ID))})).build());
    }

    private PreparedStatement prepareSelect(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"attachmentMessageId").columns(CassandraAttachmentMessageIdTable.FIELDS).where((Relation)Relation.column((CqlIdentifier)CassandraAttachmentMessageIdTable.ATTACHMENT_ID_AS_UUID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentMessageIdTable.ATTACHMENT_ID_AS_UUID)))).build());
    }

    private PreparedStatement prepareList(CqlSession session) {
        return session.prepare(QueryBuilder.selectFrom((String)"attachmentMessageId").columns(CassandraAttachmentMessageIdTable.FIELDS).build());
    }

    public Flux<MessageId> getOwnerMessageIds(AttachmentId attachmentId) {
        Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectStatement.bind(new Object[0]).setUuid(CassandraAttachmentMessageIdTable.ATTACHMENT_ID_AS_UUID, attachmentId.asUUID())).map(this::rowToMessageId);
    }

    private MessageId rowToMessageId(Row row) {
        return this.messageIdFactory.fromString(row.getString(CassandraAttachmentMessageIdTable.MESSAGE_ID));
    }

    public Mono<Void> storeAttachmentForMessageId(AttachmentId attachmentId, MessageId ownerMessageId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.insertStatement.bind(new Object[0]).setUuid(CassandraAttachmentMessageIdTable.ATTACHMENT_ID_AS_UUID, attachmentId.asUUID())).setString(CassandraAttachmentMessageIdTable.ATTACHMENT_ID, attachmentId.getId())).setString(CassandraAttachmentMessageIdTable.MESSAGE_ID, ownerMessageId.serialize()));
    }

    public Mono<Void> delete(AttachmentId attachmentId, MessageId ownerMessageId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.deleteStatement.bind(new Object[0]).setUuid(CassandraAttachmentMessageIdTable.ATTACHMENT_ID_AS_UUID, attachmentId.asUUID())).setString(CassandraAttachmentMessageIdTable.MESSAGE_ID, ownerMessageId.serialize()));
    }

    public Flux<Pair<AttachmentId, MessageId>> listAll() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listStatement.bind(new Object[0])).map(row -> Pair.of((Object)AttachmentId.from((String)row.getString(CassandraAttachmentMessageIdTable.ATTACHMENT_ID)), (Object)this.messageIdFactory.fromString(row.getString(CassandraAttachmentMessageIdTable.MESSAGE_ID))));
    }
}

