/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.Optional;
import org.apache.james.mailbox.exception.MailboxException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class MailboxReactorUtils {
    public static <T> T block(Mono<T> publisher) throws MailboxException {
        try {
            return (T)publisher.block();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MailboxException) {
                throw (MailboxException)e.getCause();
            }
            throw e;
        }
    }

    public static <T> T block(Publisher<T> publisher) throws MailboxException {
        return MailboxReactorUtils.block(Mono.from(publisher));
    }

    public static <T> Optional<T> blockOptional(Mono<T> publisher) throws MailboxException {
        try {
            return publisher.blockOptional();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MailboxException) {
                throw (MailboxException)e.getCause();
            }
            throw e;
        }
    }
}

