/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.MailboxException;

public interface Authorizator {
    public AuthorizationState canLoginAsOtherUser(Username var1, Username var2) throws MailboxException;

    default public FluentAuthorizator user(Username userId) {
        return otherUserId -> this.canLoginAsOtherUser(userId, otherUserId);
    }

    default public Collection<Username> delegatedUsers(Username username) {
        return ImmutableList.of();
    }

    public static enum AuthorizationState {
        ALLOWED,
        FORBIDDEN,
        UNKNOWN_USER;

    }

    public static interface FluentAuthorizator {
        public AuthorizationState canLoginAs(Username var1) throws MailboxException;
    }
}

