/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.utils;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.james.jmap.draft.utils.DependencyGraph;

public class SortingHierarchicalCollections<T, IdT> {
    private final Function<T, IdT> index;
    private final Function<T, Optional<IdT>> parentId;

    public SortingHierarchicalCollections(Function<T, IdT> index, Function<T, Optional<IdT>> parentId) {
        this.index = index;
        this.parentId = parentId;
    }

    public List<T> sortFromRootToLeaf(Collection<T> elements) throws DependencyGraph.CycleDetectedException {
        Map<IdT, T> mapOfElementsById = this.indexElementsById(elements);
        DependencyGraph<Object> graph = new DependencyGraph<Object>(m -> this.parentId.apply(m).map(mapOfElementsById::get));
        elements.forEach(graph::registerItem);
        return graph.getBuildChain().collect(Collectors.toList());
    }

    private Map<IdT, T> indexElementsById(Collection<T> elements) {
        return elements.stream().collect(Collectors.toMap(this.index, Function.identity()));
    }

    public List<T> sortFromLeafToRoot(Collection<T> elements) throws DependencyGraph.CycleDetectedException {
        return Lists.reverse(this.sortFromRootToLeaf(elements));
    }
}

