/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValidRcptHandler
implements RcptHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractValidRcptHandler.class);

    @Override
    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        try {
            if (!this.isLocalDomain(session, rcpt.getDomain())) {
                return HookResult.DECLINED;
            }
            if (!this.isValidRecipient(session, rcpt)) {
                return this.reject(rcpt);
            }
            return HookResult.DECLINED;
        }
        catch (Exception e) {
            LOGGER.error("Encounter an error upon RCPT validation ({}), deny-soft", (Object)rcpt.asString(), (Object)e);
            return HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpReturnCode("451").smtpDescription(DSNStatus.getStatus(4, "0.0") + " Unexpected error for " + rcpt.asString()).build();
        }
    }

    public HookResult reject(MailAddress rcpt) {
        LOGGER.info("Rejected message. Unknown user: {}", (Object)rcpt);
        return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("550").smtpDescription(DSNStatus.getStatus(5, "1.1") + " Unknown user: " + rcpt.asString()).build();
    }

    protected abstract boolean isValidRecipient(SMTPSession var1, MailAddress var2) throws Exception;

    protected abstract boolean isLocalDomain(SMTPSession var1, Domain var2) throws Exception;
}

