/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.setup;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.system.DataDirectory;
import org.apache.sis.system.Loggers;
import org.apache.sis.system.Shutdown;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.TreeTables;
import org.apache.sis.util.internal.MetadataServices;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.util.resources.Vocabulary;

public enum About {
    VERSIONS(219),
    LOCALIZATION(119),
    PLUGINS(160),
    LOGGING(121),
    PATHS(159),
    LIBRARIES(115);

    private final short resourceKey;

    private About(short resourceKey) {
        this.resourceKey = resourceKey;
    }

    public static TreeTable configuration() {
        return About.configuration(EnumSet.allOf(About.class), null, null);
    }

    public static TreeTable configuration(Set<About> sections, Locale locale, TimeZone timezone2) {
        Locale formatLocale;
        ArgumentChecks.ensureNonNull("sections", sections);
        if (locale != null) {
            formatLocale = locale;
        } else {
            locale = Locale.getDefault(Locale.Category.DISPLAY);
            formatLocale = Locale.getDefault(Locale.Category.FORMAT);
        }
        String userHome = null;
        String javaHome = null;
        Date now2 = new Date();
        Vocabulary resources = Vocabulary.getResources(locale);
        DefaultTreeTable table = new DefaultTreeTable(TableColumn.NAME, TableColumn.VALUE_AS_TEXT);
        TreeTable.Node root2 = table.getRoot();
        root2.setValue(TableColumn.NAME, resources.getString((short)117));
        table.setRoot(root2);
        TreeTable.Node section = null;
        About newSection = VERSIONS;
        int i = 0;
        block33: while (true) {
            short nameKey = 0;
            String name = null;
            Object value = null;
            String[] children = null;
            block2 : switch (i) {
                case 0: {
                    if (!sections.contains((Object)VERSIONS)) break;
                    name = "Apache SIS";
                    value = Version.SIS;
                    break;
                }
                case 1: {
                    if (!sections.contains((Object)VERSIONS)) break;
                    name = "Java";
                    value = About.concatenate(System.getProperty("java.version"), System.getProperty("java.vendor"), true);
                    break;
                }
                case 2: {
                    if (!sections.contains((Object)VERSIONS)) break;
                    name = "JavaFX";
                    value = System.getProperty("javafx.version");
                    break;
                }
                case 3: {
                    if (!sections.contains((Object)VERSIONS)) break;
                    nameKey = 150;
                    value = About.concatenate(About.concatenate(System.getProperty("os.name"), System.getProperty("os.version"), false), System.getProperty("os.arch"), true);
                    break;
                }
                case 4: {
                    if (!sections.contains((Object)VERSIONS)) break;
                    nameKey = 33;
                    value = Shutdown.getContainer();
                    break;
                }
                case 5: {
                    if (!sections.contains((Object)VERSIONS)) break;
                    nameKey = 91;
                    value = MetadataServices.getInstance().getInformation("EPSG", locale);
                    break;
                }
                case 6: {
                    Object current;
                    newSection = LOCALIZATION;
                    if (!sections.contains((Object)LOCALIZATION) || (current = Locale.getDefault()) == null) break;
                    nameKey = 118;
                    value = ((Locale)current).getDisplayName(locale);
                    CharSequence code = About.concatenate(About.getCode(locale, false), About.getCode(locale, true), true);
                    if (code == null) break;
                    children = new String[]{resources.getString((short)29, "ISO"), code.toString()};
                    break;
                }
                case 7: {
                    Object current;
                    if (!sections.contains((Object)LOCALIZATION) || (current = TimeZone.getDefault()) == null) break;
                    nameKey = 197;
                    boolean inDaylightTime = ((TimeZone)current).inDaylightTime(now2);
                    value = About.concatenate(((TimeZone)current).getDisplayName(inDaylightTime, 1, locale), ((TimeZone)current).getID(), true);
                    DateFormat df = DateFormat.getTimeInstance(3, formatLocale);
                    df.setTimeZone(TimeZone.getTimeZone("UTC"));
                    int offset = ((TimeZone)current).getOffset(now2.getTime());
                    Object buffer = About.format(df, offset, new StringBuffer("UTC "));
                    if ((offset -= ((TimeZone)current).getRawOffset()) != 0) {
                        buffer = About.format(df, offset, ((StringBuffer)buffer).append(" (").append(resources.getString((short)55)).append(' ')).append(')');
                    }
                    children = new String[]{resources.getString((short)149), ((StringBuffer)buffer).toString()};
                    break;
                }
                case 8: {
                    if (!sections.contains((Object)LOCALIZATION)) break;
                    nameKey = 43;
                    DateFormat df = DateFormat.getDateTimeInstance(1, 1, formatLocale);
                    if (timezone2 != null) {
                        df.setTimeZone(timezone2);
                    }
                    value = df.format(now2);
                    break;
                }
                case 9: {
                    Object current;
                    if (!sections.contains((Object)LOCALIZATION) || (current = Charset.defaultCharset()) == null) break;
                    nameKey = 25;
                    value = ((Charset)current).displayName(locale);
                    Set<String> aliases = ((Charset)current).aliases();
                    if (aliases == null || aliases.isEmpty()) break;
                    StringBuilder buffer = new StringBuilder((String)value);
                    String separator = " (";
                    for (String alias : aliases) {
                        buffer.append(separator).append(alias);
                        separator = ", ";
                    }
                    value = buffer.append(')');
                    break;
                }
                case 10: {
                    newSection = PLUGINS;
                    if (sections.contains((Object)PLUGINS)) {
                        try {
                            children = (String[])Class.forName("org.apache.sis.storage.base.Capability").getMethod("providers", Locale.class, Vocabulary.class).invoke(null, locale, resources);
                            value = resources.getString((short)78, children.length / 2);
                        }
                        catch (ClassNotFoundException e2) {
                            Logging.recoverableException(Logger.getLogger("org.apache.sis.storage"), About.class, "configuration", e2);
                        }
                        catch (ReflectiveOperationException e3) {
                            value = Exceptions.unwrap(e3).toString();
                        }
                    }
                    nameKey = 50;
                    break;
                }
                case 11: {
                    newSection = LOGGING;
                    if (!sections.contains((Object)LOGGING)) break;
                    nameKey = 104;
                    value = "java.util.logging";
                    for (Handler handler : Logger.getLogger("").getHandlers()) {
                        String c = handler.getClass().getPackageName();
                        if (value.equals(c)) continue;
                        value = c;
                        break block2;
                    }
                    break;
                }
                case 12: {
                    if (!sections.contains((Object)LOGGING)) break;
                    nameKey = 114;
                    Level level = Logger.getLogger("").getLevel();
                    if (level == null) {
                        value = resources.getString((short)207);
                        break;
                    }
                    value = level.getLocalizedName();
                    SortedMap<String, Level> levels = Loggers.getEffectiveLevels();
                    if (levels.size() == 1 && level.equals(levels.get("org.apache.sis"))) break;
                    int j = 0;
                    children = new String[levels.size() * 2];
                    for (Map.Entry entry : levels.entrySet()) {
                        children[j++] = (String)entry.getKey();
                        children[j++] = ((Level)entry.getValue()).getLocalizedName();
                    }
                    break;
                }
                case 13: {
                    newSection = PATHS;
                    if (!sections.contains((Object)PATHS)) break;
                    nameKey = 212;
                    userHome = System.getProperty("user.home");
                    value = userHome;
                    break;
                }
                case 14: {
                    if (!sections.contains((Object)PATHS)) break;
                    nameKey = 44;
                    value = System.getProperty("user.dir");
                    break;
                }
                case 15: {
                    if (!sections.contains((Object)PATHS)) break;
                    nameKey = 49;
                    try {
                        value = DataDirectory.getenv();
                    }
                    catch (SecurityException e4) {
                        value = e4.toString();
                    }
                    if (value == null) {
                        value = Messages.getResources(locale).getString((short)16, "SIS_DATA");
                        break;
                    }
                    Path path = DataDirectory.getRootDirectory();
                    if (path != null) {
                        value = path.toString();
                        break;
                    }
                    value = value + " (" + resources.getString((short)107) + ")";
                    break;
                }
                case 16: {
                    if (!sections.contains((Object)PATHS)) break;
                    nameKey = 48;
                    value = MetadataServices.getInstance().getInformation("DataSource", locale);
                    break;
                }
                case 17: {
                    if (!sections.contains((Object)PATHS)) break;
                    nameKey = 193;
                    value = System.getProperty("java.io.tmpdir");
                    break;
                }
                case 18: {
                    if (!sections.contains((Object)PATHS)) break;
                    nameKey = 110;
                    javaHome = System.getProperty("java.home");
                    value = javaHome;
                    break;
                }
                case 19: {
                    newSection = LIBRARIES;
                    if (!sections.contains((Object)LIBRARIES)) break;
                    nameKey = 109;
                    value = About.classpath(System.getProperty("java.ext.dirs"), true);
                    break;
                }
                case 20: {
                    if (!sections.contains((Object)LIBRARIES)) break;
                    nameKey = 27;
                    value = About.classpath(System.getProperty("java.class.path"), false);
                    break;
                }
                default: {
                    break block33;
                }
            }
            if (value != null) {
                if (newSection != null) {
                    section = root2.newChild();
                    section.setValue(TableColumn.NAME, resources.getString(newSection.resourceKey));
                    newSection = null;
                }
                if (name == null) {
                    name = resources.getString(nameKey);
                }
                TreeTable.Node node = section.newChild();
                node.setValue(TableColumn.NAME, name);
                if (children != null) {
                    for (int j = 0; j < children.length; j += 2) {
                        String c = children[j + 1];
                        if (c == null) continue;
                        TreeTable.Node child = node.newChild();
                        child.setValue(TableColumn.NAME, children[j]);
                        child.setValue(TableColumn.VALUE_AS_TEXT, c);
                    }
                }
                if (!(value instanceof Map)) {
                    node.setValue(TableColumn.VALUE_AS_TEXT, value.toString());
                } else {
                    Map paths = (Map)value;
                    int j = 0;
                    block38: while (true) {
                        short homeKey;
                        String home;
                        TreeTable.Node directory = null;
                        switch (j) {
                            case 0: {
                                home = javaHome;
                                homeKey = 110;
                                break;
                            }
                            case 1: {
                                home = userHome;
                                homeKey = 212;
                                break;
                            }
                            case 2: {
                                home = "";
                                homeKey = 0;
                                directory = node;
                                break;
                            }
                            default: {
                                break block38;
                            }
                        }
                        if (home != null) {
                            File homeDirectory = home.isEmpty() ? null : new File(home);
                            Iterator it = paths.entrySet().iterator();
                            while (it.hasNext()) {
                                CharSequence title;
                                Map.Entry entry = it.next();
                                File file = (File)entry.getKey();
                                if (homeDirectory != null && (file = About.relativize(homeDirectory, file)) == null) continue;
                                if (directory == null) {
                                    directory = node.newChild();
                                    directory.setValue(TableColumn.NAME, About.parenthesis(resources.getString(homeKey)));
                                }
                                if ((title = (CharSequence)entry.getValue()) == null || title.length() == 0) {
                                    title = About.parenthesis(resources.getString(file.isDirectory() ? (short)66 : 210).toLowerCase(locale));
                                }
                                TreeTables.nodeForPath(directory, TableColumn.NAME, file).setValue(TableColumn.VALUE_AS_TEXT, title);
                                it.remove();
                            }
                            if (directory != null) {
                                About.concatenateSingletons(directory, true);
                                About.omitMavenRedundancy(directory);
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        TreeTables.replaceCharSequences(table, locale);
        return table;
    }

    private static Map<File, CharSequence> classpath(String paths, boolean asDirectories) {
        LinkedHashMap<File, CharSequence> files = new LinkedHashMap<File, CharSequence>();
        return About.classpath(paths, null, asDirectories, files) ? files : null;
    }

    private static boolean classpath(String paths, File directory, boolean asDirectories, Map<File, CharSequence> files) {
        File file;
        if (paths == null) {
            return false;
        }
        boolean changed = false;
        for (CharSequence path : CharSequences.split(paths, directory == null ? File.pathSeparatorChar : (char)' ')) {
            file = new File(directory, path.toString());
            if (!file.exists()) continue;
            if (!asDirectories) {
                if (files.containsKey(file)) continue;
                files.put(file, null);
                changed = true;
                continue;
            }
            JARFilter filter = new JARFilter();
            Object[] list = file.listFiles(filter);
            if (list == null) continue;
            Arrays.sort(list);
            for (Object ext : list) {
                if (files.containsKey(ext)) continue;
                files.put((File)ext, null);
                changed = true;
            }
        }
        if (!changed) {
            return false;
        }
        IOException error = null;
        for (Map.Entry<File, CharSequence> entry : files.entrySet()) {
            CharSequence title = entry.getValue();
            if (title != null || !(file = entry.getKey()).isFile() || !file.canRead()) continue;
            try (JarFile jar = new JarFile(file);){
                Attributes attributes;
                Manifest manifest = jar.getManifest();
                if (manifest == null || (attributes = manifest.getMainAttributes()) == null) continue;
                title = About.concatenate(attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE), attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION), false);
                if (title == null && (title = About.concatenate(attributes.getValue(Attributes.Name.SPECIFICATION_TITLE), attributes.getValue(Attributes.Name.SPECIFICATION_VERSION), false)) == null) {
                    title = "";
                }
                entry.setValue(title);
                if (!About.classpath(attributes.getValue(Attributes.Name.CLASS_PATH), file.getParentFile(), false, files)) continue;
                break;
            }
            catch (IOException e2) {
                if (error == null) {
                    error = e2;
                    continue;
                }
                error.addSuppressed(e2);
            }
        }
        if (error != null) {
            Logging.unexpectedException(Logger.getLogger("org.apache.sis.util"), About.class, "configuration", error);
        }
        return true;
    }

    private static void omitMavenRedundancy(TreeTable.Node node) {
        int s1;
        int length;
        for (TreeTable.Node child : node.getChildren()) {
            About.omitMavenRedundancy(child);
        }
        CharSequence name = node.getValue(TableColumn.NAME);
        int s2 = CharSequences.lastIndexOf(name, File.separatorChar, 0, length = name.length());
        if (s2 >= 0 && (s1 = CharSequences.lastIndexOf(name, File.separatorChar, 0, s2)) >= 0) {
            int s0 = CharSequences.lastIndexOf(name, File.separatorChar, 0, s1) + 1;
            StringBuilder buffer = new StringBuilder(s2 - s0).append(name, s0, s2);
            buffer.setCharAt(s1 - s0, '-');
            if (CharSequences.regionMatches(name, s2 + 1, buffer)) {
                buffer.setLength(0);
                node.setValue(TableColumn.NAME, buffer.append(name, 0, s0).append("(\u2026)").append(name, s2, length));
            }
        }
    }

    private static TreeTable.Node concatenateSingletons(TreeTable.Node node, boolean skip) {
        List children = (List)node.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            children.set(i, About.concatenateSingletons((TreeTable.Node)children.get(i), false));
        }
        if (!skip && size == 1 && node.getValue(TableColumn.VALUE_AS_TEXT) == null) {
            TreeTable.Node child = (TreeTable.Node)children.remove(0);
            StringBuilder name = new StringBuilder(node.getValue(TableColumn.NAME));
            if (!File.separator.contentEquals(name)) {
                name.append(File.separatorChar);
            }
            child.setValue(TableColumn.NAME, name.append(child.getValue(TableColumn.NAME)));
            return child;
        }
        return node;
    }

    private static CharSequence concatenate(CharSequence main, CharSequence complement, boolean parenthesis) {
        if (main != null && main.length() != 0) {
            if (complement != null && complement.length() != 0) {
                StringBuilder buffer = main instanceof StringBuilder ? (StringBuilder)main : new StringBuilder(main);
                buffer.append(' ');
                if (parenthesis) {
                    buffer.append('(');
                }
                buffer.append(complement);
                if (parenthesis) {
                    buffer.append(')');
                }
                return buffer;
            }
            return main;
        }
        return complement;
    }

    private static CharSequence parenthesis(String text) {
        return new StringBuilder(text.length() + 2).append('(').append(text).append(')');
    }

    private static String getCode(Locale locale, boolean country) {
        try {
            return country ? locale.getCountry() : locale.getISO3Language();
        }
        catch (MissingResourceException e2) {
            Logging.ignorableException(Vocabulary.LOGGER, About.class, "configuration", e2);
            return null;
        }
    }

    private static StringBuffer format(Format df, int offset, StringBuffer buffer) {
        return df.format(Math.abs(offset), buffer.append(offset < 0 ? (char)'-' : '+').append(' '), new FieldPosition(0));
    }

    private static File relativize(File root2, File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return null;
        }
        if (root2.equals(parent)) {
            parent = null;
        } else if ((parent = About.relativize(root2, parent)) == null) {
            return null;
        }
        return new File(parent, file.getName());
    }

    private static final class JARFilter
    implements FileFilter {
        private JARFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".jar");
        }
    }
}

