/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.iterator.ExtendedIterator;

public class StreamRDFOps {
    public static void datasetToStream(DatasetGraph datasetGraph, StreamRDF stream) {
        stream.start();
        StreamRDFOps.sendDatasetToStream(datasetGraph, stream);
        stream.finish();
    }

    public static void graphToStream(Graph graph, StreamRDF stream) {
        stream.start();
        StreamRDFOps.sendGraphToStream(graph, stream);
        stream.finish();
    }

    public static void sendPrefixesToStream(PrefixMap prefixMap, StreamRDF stream) {
        prefixMap.forEach((p, u) -> stream.prefix((String)p, u.toString()));
    }

    public static void sendPrefixesToStream(PrefixMapping prefixMap, StreamRDF stream) {
        prefixMap.getNsPrefixMap().forEach(stream::prefix);
    }

    public static void sendTriplesQuadsToStream(DatasetGraph datasetGraph, StreamRDF stream) {
        StreamRDFOps.sendDatasetToStream(datasetGraph, stream, null, null);
    }

    public static void sendDatasetToStream(DatasetGraph datasetGraph, StreamRDF stream) {
        StreamRDFOps.sendDatasetToStream(datasetGraph, stream, null, datasetGraph.prefixes());
    }

    public static void sendDatasetToStream(DatasetGraph datasetGraph, StreamRDF stream, String baseURI, PrefixMap prefixMap) {
        if (baseURI != null) {
            stream.base(baseURI);
        }
        if (prefixMap != null) {
            StreamRDFOps.sendPrefixesToStream(prefixMap, stream);
        }
        ExtendedIterator<Triple> iter1 = datasetGraph.getDefaultGraph().find(null, null, null);
        StreamRDFOps.sendTriplesToStream(iter1, stream);
        Iterator<Quad> iter2 = datasetGraph.findNG(null, null, null, null);
        StreamRDFOps.sendQuadsToStream(iter2, stream);
    }

    public static void sendGraphToStream(Graph graph, StreamRDF stream) {
        PrefixMap prefixMap = PrefixMapFactory.create(graph.getPrefixMapping());
        StreamRDFOps.sendGraphToStream(graph, stream, null, prefixMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendGraphToStream(Graph graph, StreamRDF stream, String baseURI, PrefixMap prefixMap) {
        if (baseURI != null) {
            stream.base(baseURI);
        }
        if (prefixMap != null) {
            StreamRDFOps.sendPrefixesToStream(prefixMap, stream);
        }
        try (ExtendedIterator<Triple> iter = graph.find(null, null, null);){
            StreamRDFOps.sendTriplesToStream(iter, stream);
        }
    }

    public static void sendTriplesToStream(Graph graph, StreamRDF stream) {
        StreamRDFOps.sendGraphToStream(graph, stream, null, null);
    }

    public static void sendTriplesToStream(Iterator<Triple> iter, StreamRDF dest) {
        iter.forEachRemaining(dest::triple);
    }

    public static void sendQuadsToStream(DatasetGraph datasetGraph, StreamRDF stream) {
        Iterator<Quad> iter2 = datasetGraph.find(null, null, null, null);
        StreamRDFOps.sendQuadsToStream(iter2, stream);
    }

    public static void sendQuadsToStream(Iterator<Quad> iter, StreamRDF dest) {
        iter.forEachRemaining(dest::quad);
    }
}

