/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.tokens;

import java.nio.charset.MalformedInputException;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.RiotChars;
import org.apache.jena.riot.tokens.StringType;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenChecker;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerTextBuilder;
import org.apache.jena.sparql.ARQInternalErrorException;

public final class TokenizerText
implements Tokenizer {
    private static final boolean CHECK_CODEPOINTS = true;
    private static final boolean CHECK_RDFSTRING = false;
    private static final boolean VeryVeryLaxIRI = false;
    private static final boolean AllowSpacesInIRI = false;
    private static final boolean WarnOnReplacmentCharInIRI = false;
    private static final boolean WarnOnReplacmentCharInString = false;
    private static final boolean WarnOnReplacmentCharInPrefixedName = true;
    private static final boolean WarnOnReplacmentCharInBlankNodeLabel = true;
    private static final boolean CHECKER = false;
    private final TokenChecker checker = null;
    private final PeekReader reader;
    private final boolean singleLineMode;
    private final ErrorHandler errorHandler;
    private Token token = null;
    private boolean finished = false;
    private final StringBuilder stringBuilder = new StringBuilder(200);
    private static final int NO_CODEPOINT = 0;
    private static char[] extraCharsWord = new char[]{'_', '.', '-'};
    private static char[] extraCharsVar = new char[]{'_', '.', '-', '?', '@', '+', '/', '~'};

    public static TokenizerTextBuilder create() {
        return new TokenizerTextBuilder();
    }

    public static Tokenizer fromString(String string) {
        return TokenizerText.create().fromString(string).build();
    }

    static TokenizerText internal(PeekReader reader, boolean singleLineMode, ErrorHandler errorHandler) {
        return new TokenizerText(reader, singleLineMode, errorHandler);
    }

    private TokenizerText(PeekReader reader, boolean singleLineMode, ErrorHandler errorHandler) {
        this.reader = Objects.requireNonNull(reader, "PeekReader");
        this.singleLineMode = singleLineMode;
        this.errorHandler = Objects.requireNonNull(errorHandler, "ErrorHandler");
    }

    @Override
    public final boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.token != null) {
            return true;
        }
        try {
            this.skip();
            if (this.reader.eof()) {
                this.finished = true;
                return false;
            }
            this.token = this.parseToken();
            if (this.token == null) {
                this.finished = true;
                return false;
            }
            return true;
        }
        catch (AtlasException ex) {
            if (ex.getCause() != null) {
                if (ex.getCause().getClass() == MalformedInputException.class) {
                    throw new RiotParseException("Bad character encoding", this.reader.getLineNum(), this.reader.getColNum());
                }
                throw new RiotParseException("Bad input stream [" + String.valueOf(ex.getCause()) + "]", this.reader.getLineNum(), this.reader.getColNum());
            }
            throw new RiotParseException("Bad input stream", this.reader.getLineNum(), this.reader.getColNum());
        }
    }

    @Override
    public final boolean eof() {
        return !this.hasNext();
    }

    @Override
    public final Token next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Token t = this.token;
        this.token = null;
        return t;
    }

    @Override
    public final Token peek() {
        if (!this.hasNext()) {
            return null;
        }
        return this.token;
    }

    @Override
    public void close() {
        IO.close(this.reader);
    }

    private void skip() {
        int ch = -1;
        while (true) {
            if (this.reader.eof()) {
                return;
            }
            ch = this.reader.peekChar();
            if (ch == 35) {
                this.reader.readChar();
                while ((ch = this.reader.peekChar()) != -1 && !RiotChars.isNewlineChar(ch)) {
                    this.reader.readChar();
                }
            }
            if (this.singleLineMode ? !RiotChars.isHorizontalWhitespace(ch) : !RiotChars.isWhitespace(ch)) break;
            this.reader.readChar();
        }
    }

    private Token parseToken() {
        this.token = new Token(this.getLine(), this.getColumn());
        int ch = this.reader.peekChar();
        if (ch == 60) {
            this.reader.readChar();
            int chPeek2 = this.reader.peekChar();
            if (chPeek2 != 60) {
                this.token.setImage(this.readIRI());
                this.token.setType(TokenType.IRI);
                return this.token;
            }
            this.reader.readChar();
            int chPeek3 = this.reader.peekChar();
            if (chPeek3 != 40) {
                this.token.setType(TokenType.LT2);
                return this.token;
            }
            this.reader.readChar();
            this.token.setType(TokenType.L_TRIPLE);
            return this.token;
        }
        if (ch == 39 || ch == 34) {
            this.token.setType(TokenType.STRING);
            this.reader.readChar();
            int ch2 = this.reader.peekChar();
            if (ch2 == ch) {
                this.reader.readChar();
                int ch3 = this.reader.peekChar();
                if (ch3 == ch) {
                    this.reader.readChar();
                    this.token.setImage(this.readStringQuote3(ch));
                    st = ch == 39 ? StringType.LONG_STRING1 : StringType.LONG_STRING2;
                    this.token.setStringType(st);
                } else {
                    this.token.setImage("");
                    st = ch == 39 ? StringType.STRING1 : StringType.STRING2;
                    this.token.setStringType(st);
                }
            } else {
                this.token.setImage(this.readStringQuote1(ch, ch));
                StringType st = ch == 39 ? StringType.STRING1 : StringType.STRING2;
                this.token.setStringType(st);
            }
            this.skip();
            if (this.reader.peekChar() == 64) {
                this.reader.readChar();
                Token mainToken = new Token(this.token);
                mainToken.setType(TokenType.LITERAL_LANG);
                mainToken.setSubToken1(this.token);
                mainToken.setImage2(this.langTag());
                this.token = mainToken;
            } else if (this.reader.peekChar() == 94) {
                this.expect("^^");
                this.skip();
                Token mainToken = new Token(this.token);
                mainToken.setSubToken1(this.token);
                mainToken.setImage(this.token.getImage());
                Token subToken = this.parseToken();
                if (!subToken.isIRI()) {
                    this.fatal("Datatype URI required after ^^ - URI or prefixed name expected", new Object[0]);
                }
                mainToken.setSubToken2(subToken);
                mainToken.setType(TokenType.LITERAL_DT);
                this.token = mainToken;
            }
            return this.token;
        }
        if (ch == 95) {
            this.reader.readChar();
            int ch2 = this.reader.peekChar();
            if (ch2 == 58) {
                this.reader.readChar();
                this.token.setImage(this.readBlankNodeLabel());
                this.token.setType(TokenType.BNODE);
                return this.token;
            }
            this.token.setType(TokenType.UNDERSCORE);
            return this.token;
        }
        if (ch == 64) {
            this.reader.readChar();
            this.token.setType(TokenType.DIRECTIVE);
            this.token.setImage(this.readWord(false));
            return this.token;
        }
        if (ch == 63) {
            this.reader.readChar();
            this.token.setType(TokenType.VAR);
            this.token.setImage(this.readVarName());
            return this.token;
        }
        switch (ch) {
            case 46: {
                this.reader.readChar();
                ch = this.reader.peekChar();
                if (RiotChars.range(ch, 48, 57)) {
                    this.reader.pushbackChar(46);
                    boolean charactersConsumed = this.readNumber(0, false);
                    if (charactersConsumed) {
                        return this.token;
                    }
                }
                this.token.setType(TokenType.DOT);
                return this.token;
            }
            case 62: {
                this.reader.readChar();
                int chPeek = this.reader.peekChar();
                if (chPeek == 62) {
                    this.reader.readChar();
                    this.token.setType(TokenType.GT2);
                    return this.token;
                }
                this.token.setType(TokenType.GT);
                return this.token;
            }
            case 59: {
                this.reader.readChar();
                this.token.setType(TokenType.SEMICOLON);
                return this.token;
            }
            case 44: {
                this.reader.readChar();
                this.token.setType(TokenType.COMMA);
                return this.token;
            }
            case 123: {
                this.reader.readChar();
                int chPeek = this.reader.peekChar();
                if (chPeek == 124) {
                    this.reader.readChar();
                    this.token.setType(TokenType.L_ANN);
                    return this.token;
                }
                this.token.setType(TokenType.LBRACE);
                return this.token;
            }
            case 125: {
                this.reader.readChar();
                this.token.setType(TokenType.RBRACE);
                return this.token;
            }
            case 40: {
                this.reader.readChar();
                this.token.setType(TokenType.LPAREN);
                return this.token;
            }
            case 41: {
                this.reader.readChar();
                int peek2 = this.reader.peekChar();
                if (peek2 != 62) {
                    this.token.setType(TokenType.RPAREN);
                    return this.token;
                }
                this.reader.readChar();
                int peek3 = this.reader.peekChar();
                if (peek3 != 62) {
                    this.reader.pushbackChar(peek2);
                    this.token.setType(TokenType.RPAREN);
                    return this.token;
                }
                this.reader.readChar();
                this.token.setType(TokenType.R_TRIPLE);
                return this.token;
            }
            case 91: {
                this.reader.readChar();
                this.token.setType(TokenType.LBRACKET);
                return this.token;
            }
            case 93: {
                this.reader.readChar();
                this.token.setType(TokenType.RBRACKET);
                return this.token;
            }
            case 61: {
                this.reader.readChar();
                this.token.setType(TokenType.EQUALS);
                return this.token;
            }
            case 47: {
                this.reader.readChar();
                this.token.setType(TokenType.SLASH);
                return this.token;
            }
            case 92: {
                this.reader.readChar();
                this.token.setType(TokenType.RSLASH);
                return this.token;
            }
            case 124: {
                this.reader.readChar();
                int chPeek = this.reader.peekChar();
                if (chPeek == 125) {
                    this.reader.readChar();
                    this.token.setType(TokenType.R_ANN);
                    return this.token;
                }
                this.token.setType(TokenType.VBAR);
                return this.token;
            }
            case 38: {
                this.reader.readChar();
                this.token.setType(TokenType.AMPERSAND);
                return this.token;
            }
            case 60: {
                this.reader.readChar();
                this.token.setType(TokenType.LT);
                return this.token;
            }
            case 42: {
                this.reader.readChar();
                this.token.setType(TokenType.STAR);
                return this.token;
            }
            case 33: {
                this.reader.readChar();
                this.token.setType(TokenType.EMARK);
                return this.token;
            }
            case 126: {
                this.reader.readChar();
                this.token.setType(TokenType.TILDE);
                return this.token;
            }
        }
        if (ch == 43 || ch == 45) {
            this.reader.readChar();
            int ch2 = this.reader.peekChar();
            if (!RiotChars.range(ch2, 48, 57) && ch2 != 46) {
                if (ch == 43) {
                    this.token.setType(TokenType.PLUS);
                } else {
                    this.token.setType(TokenType.MINUS);
                }
                return this.token;
            }
            boolean charactersConsumed = this.readNumber(ch, false);
            if (!charactersConsumed) {
                if (ch == 43) {
                    this.token.setType(TokenType.PLUS);
                } else {
                    this.token.setType(TokenType.MINUS);
                }
            }
            return this.token;
        }
        if (RiotChars.range(ch, 48, 57)) {
            boolean isHex;
            this.reader.readChar();
            if (ch == 48 && (isHex = this.readPossibleHex())) {
                return this.token;
            }
            boolean charactersConsumed = this.readNumber(ch, true);
            if (!charactersConsumed) {
                throw new InternalError("Seen digit but no number produced");
            }
            return this.token;
        }
        if (RiotChars.isNewlineChar(ch)) {
            do {
                int n = this.reader.readChar();
            } while (RiotChars.isNewlineChar(this.reader.peekChar()));
            this.token.setType(TokenType.NL);
            return this.token;
        }
        this.readPrefixedNameOrKeyword(this.token);
        return this.token;
    }

    private void startStringU() {
        this.stringBuilder.setLength(0);
    }

    private String finishStringU(int finalCodepoint) {
        if (finalCodepoint != 0) {
            this.fatal("Bad unpaired surrogate at end of string", new Object[0]);
        }
        return this.stringBuilder.toString();
    }

    private void startStringNU() {
        this.stringBuilder.setLength(0);
    }

    private String finishStringNU() {
        return this.stringBuilder.toString();
    }

    private int lengthStringBuilder() {
        return this.stringBuilder.length();
    }

    private void setStringBuilderLength(int x) {
        this.stringBuilder.setLength(x);
    }

    private char charAt(int idx) {
        return this.stringBuilder.charAt(idx);
    }

    private void deleteCharAt(int idx) {
        this.stringBuilder.deleteCharAt(idx);
    }

    private int insertCodepoint(int previousCP, int ch) {
        if (Character.charCount(ch) == 1) {
            char ch16 = (char)ch;
            char rtn = '\u0000';
            rtn = this.checkCodepoint((char)previousCP, ch16);
            this.insertCodepointDirect(ch16);
            return rtn;
        }
        if (previousCP != 0) {
            this.fatal("Lone surrogate", new Object[0]);
        }
        if (!Character.isDefined(ch) && !Character.isSupplementaryCodePoint(ch)) {
            this.fatal("Illegal codepoint: 0x%04X", ch);
        }
        char[] chars = Character.toChars(ch);
        this.stringBuilder.append(chars);
        return 0;
    }

    private char checkCodepoint(char previousCP, char ch) {
        if (!Character.isSurrogate(ch)) {
            if (previousCP == '\u0000') {
                return '\u0000';
            }
            this.fatal("Bad surrogate (high surrogate not followed by a low surrogate): 0x%04X", previousCP);
        }
        if (previousCP == '\u0000') {
            if (Character.isHighSurrogate(ch)) {
                return ch;
            }
            this.fatal("Bad surrogate (low surrogate not preceded by a high surrogate): 0x%04X", ch);
        }
        if (Character.isLowSurrogate(ch)) {
            return '\u0000';
        }
        this.fatal("Bad surrogate (high surrogate not followed by low surrogate): 0x%04X", previousCP);
        return '\u0000';
    }

    private void insertCodepointDirect(int ch) {
        this.insertCodepointDirect((char)ch);
    }

    private void insertCodepointDirect(char ch) {
        this.stringBuilder.append(ch);
    }

    private String currentString() {
        return this.stringBuilder.toString();
    }

    private String readIRI() {
        this.startStringU();
        int prevCP = 0;
        while (true) {
            int ch = this.reader.readChar();
            switch (ch) {
                case -1: {
                    this.fatal("Broken IRI (End of file)", new Object[0]);
                    return null;
                }
                case 10: {
                    this.fatal("Broken IRI (newline): %s", this.currentString());
                    return null;
                }
                case 13: {
                    this.fatal("Broken IRI (CR): %s", this.currentString());
                    return null;
                }
                case 62: {
                    String str2 = this.finishStringU(prevCP);
                    return str2;
                }
                case 92: {
                    ch = this.readUnicodeEscape();
                    break;
                }
                case 60: {
                    this.fatal("Bad character in IRI (bad character: '<'): <%s[<]...>", this.currentString());
                    return null;
                }
                case 9: {
                    this.error("Bad character in IRI (tab character): <%s[tab]...>", this.currentString());
                    break;
                }
                case 34: 
                case 94: 
                case 96: 
                case 123: 
                case 124: 
                case 125: {
                    this.warning("Illegal character in IRI (codepoint U+%04X, '%c'): <%s[%c]...>", ch, Character.valueOf((char)ch), this.currentString(), Character.valueOf((char)ch));
                    break;
                }
                case 32: {
                    this.error("Bad character in IRI (space): <%s[space]...>", this.currentString());
                    break;
                }
                case 65533: {
                    break;
                }
                default: {
                    if (ch > 25) break;
                    this.warning("Illegal character in IRI (control char 0x%02X): <%s[0x%02X]...>", ch, this.currentString(), ch);
                }
            }
            prevCP = this.insertCodepoint(prevCP, ch);
        }
    }

    private void readPrefixedNameOrKeyword(Token token) {
        long posn = this.reader.getPosition();
        String prefixPart = this.readPrefixPart();
        token.setImage(prefixPart);
        token.setType(TokenType.KEYWORD);
        int ch = this.reader.peekChar();
        if (ch == 58) {
            this.reader.readChar();
            token.setType(TokenType.PREFIXED_NAME);
            String ln2 = this.readLocalPart();
            token.setImage2(ln2);
        }
        if (posn == this.reader.getPosition()) {
            this.fatal("Failed to find a prefix name or keyword: %c(%d;0x%04X)", ch, ch, ch);
        }
    }

    private String readPrefixPart() {
        return this.readSegment(false);
    }

    private String readLocalPart() {
        return this.readSegment(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String readSegment(boolean isLocalPart) {
        int ch;
        int prevCP;
        block17: {
            block18: {
                prevCP = 0;
                ch = this.reader.peekChar();
                if (ch == -1) {
                    return "";
                }
                this.startStringU();
                if (!isLocalPart) break block18;
                if (ch == 58) {
                    this.reader.readChar();
                    prevCP = this.insertCodepoint(prevCP, ch);
                    break block17;
                } else if (ch == 37 || ch == 92) {
                    this.reader.readChar();
                    this.processPLX(ch);
                    break block17;
                } else {
                    if (!RiotChars.isPNChars_U_N(ch)) {
                        this.finishStringU(prevCP);
                        return "";
                    }
                    if (ch == 65533) {
                        this.warning("Unicode replacement character U+FFFD in prefixed name", new Object[0]);
                    }
                    prevCP = this.insertCodepoint(prevCP, ch);
                    this.reader.readChar();
                }
                break block17;
            }
            if (!RiotChars.isPNCharsBase(ch)) {
                this.finishStringU(prevCP);
                return "";
            }
            prevCP = this.insertCodepoint(prevCP, ch);
            this.reader.readChar();
        }
        int chDot = 0;
        while (true) {
            ch = this.reader.peekChar();
            boolean valid = false;
            if (isLocalPart && (ch == 37 || ch == 92)) {
                this.reader.readChar();
                if (chDot != 0) {
                    this.insertCodepointDirect(chDot);
                }
                this.processPLX(ch);
                prevCP = 0;
                chDot = 0;
                continue;
            }
            valid = isLocalPart && ch == 58 ? true : (RiotChars.isPNChars(ch) ? true : ch == 46);
            if (!valid) {
                if (chDot != 46) return this.finishStringU(prevCP);
                break;
            }
            if (chDot != 0) {
                this.insertCodepointDirect(chDot);
                chDot = 0;
            }
            if (ch != 46) {
                if (ch == 65533) {
                    this.warning("Unicode replacement character U+FFFD in prefixed name", new Object[0]);
                }
                prevCP = this.insertCodepoint(prevCP, ch);
            } else {
                chDot = ch;
            }
            this.reader.readChar();
        }
        this.reader.pushbackChar(chDot);
        return this.finishStringU(prevCP);
    }

    private void processPLX(int ch) {
        if (ch == 37) {
            this.insertCodepointDirect(ch);
            ch = this.reader.peekChar();
            if (!RiotChars.isHexChar(ch)) {
                this.fatal("Not a hex character: '%c'", ch);
            }
            this.insertCodepointDirect(ch);
            this.reader.readChar();
            ch = this.reader.peekChar();
            if (!RiotChars.isHexChar(ch)) {
                this.fatal("Not a hex character: '%c'", ch);
            }
            this.insertCodepointDirect(ch);
            this.reader.readChar();
        } else if (ch == 92) {
            ch = this.readCharEscape();
            this.insertCodepointDirect(ch);
        } else {
            throw new ARQInternalErrorException("Not a '\\' or a '%' character");
        }
    }

    private void checkRDFString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (!Character.isValidCodePoint(ch)) {
                this.warning("Illegal code point in \\U sequence value: 0x%08X", ch);
            }
            if (Character.isHighSurrogate(ch)) {
                char ch1;
                if (++i == string.length()) {
                    this.fatal("Bad surrogate pair (end of string):0x%04X", ch);
                }
                if (Character.isLowSurrogate(ch1 = string.charAt(i))) continue;
                this.fatal("Bad surrogate (high surrogate not followed by a low surrogate): 0x%04X", ch1);
                continue;
            }
            if (!Character.isLowSurrogate(ch)) continue;
            this.fatal("Bad surrogate pair (low surrogate not preceded by a high surrogate): 0x%04X", ch);
        }
    }

    private String readStringQuote1(int startCh, int endCh) {
        this.startStringU();
        int prevCP = 0;
        while (true) {
            int ch;
            if ((ch = this.reader.readChar()) == 65535 || ch == 65534) {
                this.warning("Unicode non-character U+%04X in string", ch);
            }
            if (ch == -1) {
                this.fatal("Broken token: %s", this.currentString());
            } else {
                if (ch == endCh) {
                    String str2 = this.finishStringU(prevCP);
                    return str2;
                }
                if (ch == 10) {
                    this.fatal("Broken token (newline in string)", this.currentString());
                } else if (ch == 13) {
                    this.fatal("Broken token (carriage return in string)", this.currentString());
                } else if (ch == 92) {
                    ch = this.readLiteralEscape();
                }
            }
            prevCP = this.insertCodepoint(prevCP, ch);
        }
    }

    private String readStringQuote3(int quoteChar) {
        this.startStringU();
        int prevCP = 0;
        while (true) {
            int ch;
            if ((ch = this.reader.readChar()) == -1) {
                this.fatal("Broken long string", new Object[0]);
            } else if (ch == quoteChar) {
                if (this.threeQuotes(quoteChar)) {
                    String str2 = this.finishStringU(prevCP);
                    return str2;
                }
            } else if (ch == 92) {
                ch = this.readLiteralEscape();
            }
            prevCP = this.insertCodepoint(prevCP, ch);
        }
    }

    private String readWord(boolean leadingDigitAllowed) {
        return this.readWordSub(leadingDigitAllowed, false);
    }

    private String readWordSub(boolean leadingDigitAllowed, boolean leadingSignAllowed) {
        return this.readCharsWithExtras(leadingDigitAllowed, leadingSignAllowed, extraCharsWord, false);
    }

    private String readVarName() {
        return this.readCharsWithExtras(true, true, extraCharsVar, true);
    }

    private String readCharsWithExtras(boolean leadingDigitAllowed, boolean leadingSignAllowed, char[] extraChars, boolean allowFinalDot) {
        int ch;
        this.startStringNU();
        int idx = 0;
        if (!leadingDigitAllowed && Character.isDigit(ch = this.reader.peekChar())) {
            return "";
        }
        if (!(leadingSignAllowed || (ch = this.reader.peekChar()) != 45 && ch != 43)) {
            return "";
        }
        while (RiotChars.isAlphaNumeric(ch = this.reader.peekChar()) || Chars.charInArray(ch, extraChars)) {
            this.reader.readChar();
            this.insertCodepointDirect(ch);
            ++idx;
        }
        if (!allowFinalDot) {
            while (idx > 0 && this.charAt(idx - 1) == '.') {
                this.reader.pushbackChar(46);
                this.setStringBuilderLength(--idx);
            }
        }
        return this.finishStringNU();
    }

    private String readBlankNodeLabel() {
        int ch;
        this.startStringU();
        int prevCP = 0;
        int ch2 = this.reader.peekChar();
        if (ch2 == -1) {
            this.fatal("Blank node label missing (EOF found)", new Object[0]);
        }
        if (RiotChars.isWhitespace(ch2)) {
            this.fatal("Blank node label missing", new Object[0]);
        }
        if (!RiotChars.isPNChars_U_N(ch2)) {
            this.fatal("Blank node label does not start with alphabetic or _ : '%c'", Character.valueOf((char)ch2));
        }
        this.reader.readChar();
        if (ch2 == 65533) {
            this.warning("Unicode replacement character U+FFFD in blank node label", new Object[0]);
        }
        prevCP = this.insertCodepoint(prevCP, ch2);
        int chDot = 0;
        while ((ch = this.reader.peekChar()) != -1 && (RiotChars.isPNChars(ch) || ch == 46)) {
            this.reader.readChar();
            if (chDot != 0) {
                this.insertCodepointDirect(chDot);
                prevCP = 0;
                chDot = 0;
            }
            if (ch != 46) {
                if (ch == 65533) {
                    this.warning("Unicode replacement character U+FFFD in blank node label", new Object[0]);
                }
                prevCP = this.insertCodepoint(prevCP, ch);
                continue;
            }
            chDot = ch;
        }
        if (chDot == 46) {
            this.reader.pushbackChar(chDot);
        }
        return this.finishStringU(prevCP);
    }

    private boolean readNumber(int initialChar, boolean isDigit) {
        boolean isDouble = false;
        boolean hasDecimalPoint = false;
        boolean hasDigitsBeforeDot = false;
        boolean hasDigitsAfterDot = false;
        int numDigitsBeforeDP = 0;
        int numDigitsAfterDP = 0;
        this.startStringNU();
        if (initialChar != 0) {
            if (initialChar == 43 || initialChar == 45) {
                this.insertCodepointDirect(initialChar);
            } else if (isDigit) {
                this.insertCodepointDirect(initialChar);
                numDigitsBeforeDP = 1;
            }
        }
        int ch = this.reader.peekChar();
        if ((numDigitsBeforeDP += this.readDigits()) > 0) {
            hasDigitsBeforeDot = true;
        }
        if ((ch = this.reader.peekChar()) == 46) {
            this.reader.readChar();
            this.insertCodepointDirect('.');
            hasDecimalPoint = true;
            if ((numDigitsAfterDP += this.readDigits()) > 0) {
                hasDigitsAfterDot = true;
            }
        }
        if (numDigitsBeforeDP == 0 && !hasDecimalPoint) {
            this.fatal("Unrecognized as number", new Object[0]);
        }
        if (!hasDigitsBeforeDot & !hasDigitsAfterDot) {
            if (hasDecimalPoint) {
                this.reader.pushbackChar(46);
            }
            return false;
        }
        if (this.exponent()) {
            isDouble = true;
        } else if (hasDecimalPoint && !hasDigitsAfterDot) {
            int N = this.lengthStringBuilder();
            this.deleteCharAt(N - 1);
            this.reader.pushbackChar(46);
            hasDecimalPoint = false;
        }
        this.token.setImage(this.finishStringNU());
        if (isDouble) {
            this.token.setType(TokenType.DOUBLE);
        } else if (hasDecimalPoint) {
            this.token.setType(TokenType.DECIMAL);
        } else {
            this.token.setType(TokenType.INTEGER);
        }
        return true;
    }

    private boolean readPossibleHex() {
        int ch2 = this.reader.peekChar();
        if (ch2 != 120 && ch2 != 88) {
            return false;
        }
        this.reader.readChar();
        this.startStringNU();
        this.insertCodepointDirect('0');
        this.insertCodepointDirect(ch2);
        this.readHex(this.reader);
        this.token.setImage(this.finishStringNU());
        this.token.setType(TokenType.HEX);
        return true;
    }

    private void readHex(PeekReader reader) {
        int ch;
        int x = 0;
        while (RiotChars.isHexChar(ch = reader.peekChar())) {
            reader.readChar();
            this.insertCodepointDirect(ch);
            ++x;
        }
        if (x == 0) {
            this.fatal("No hex characters after %s", this.currentString());
        }
    }

    private int readDigits() {
        int ch;
        int count = 0;
        while (RiotChars.range(ch = this.reader.peekChar(), 48, 57)) {
            this.reader.readChar();
            this.insertCodepointDirect(ch);
            ++count;
        }
        return count;
    }

    private void readPossibleSign() {
        int ch = this.reader.peekChar();
        if (ch == 45 || ch == 43) {
            this.reader.readChar();
            this.insertCodepointDirect(ch);
        }
    }

    private boolean threeQuotes(int ch) {
        int ch2 = this.reader.peekChar();
        if (ch2 != ch) {
            return false;
        }
        this.reader.readChar();
        int ch3 = this.reader.peekChar();
        if (ch3 != ch) {
            this.reader.pushbackChar(ch2);
            return false;
        }
        this.reader.readChar();
        return true;
    }

    private boolean exponent() {
        int ch = this.reader.peekChar();
        if (ch != 101 && ch != 69) {
            return false;
        }
        this.reader.readChar();
        this.insertCodepointDirect(ch);
        this.readPossibleSign();
        int x = this.readDigits();
        if (x == 0) {
            this.fatal("Malformed double: %s", this.currentString());
        }
        return true;
    }

    private String langTag() {
        int ch;
        this.startStringU();
        this.a2z();
        if (this.lengthStringBuilder() == 0) {
            this.fatal("Bad language tag", new Object[0]);
        }
        boolean seenTextDirection = false;
        while ((ch = this.reader.peekChar()) == 45) {
            if (seenTextDirection) {
                this.fatal("Bad language tag with base direction", new Object[0]);
            }
            this.reader.readChar();
            this.insertCodepointDirect(ch);
            int ch2 = this.reader.peekChar();
            if (ch2 == 45) {
                this.reader.readChar();
                this.insertCodepointDirect(ch2);
                seenTextDirection = true;
            }
            int x = this.lengthStringBuilder();
            this.a2zN();
            if (this.lengthStringBuilder() != x) continue;
            this.fatal("Bad language tag", new Object[0]);
        }
        return this.finishStringU(0).intern();
    }

    private void a2z() {
        int ch;
        while (RiotChars.isA2Z(ch = this.reader.peekChar())) {
            this.reader.readChar();
            this.insertCodepointDirect(ch);
        }
    }

    private void a2zN() {
        int ch;
        while (RiotChars.isA2ZN(ch = this.reader.peekChar())) {
            this.reader.readChar();
            this.insertCodepointDirect(ch);
        }
    }

    @Override
    public long getColumn() {
        return this.reader.getColNum();
    }

    @Override
    public long getLine() {
        return this.reader.getLineNum();
    }

    private final int readUnicodeEscape() {
        int ch = this.reader.readChar();
        if (ch == -1) {
            this.fatal("Broken escape sequence", new Object[0]);
        }
        switch (ch) {
            case 117: {
                return this.readUnicode4Escape();
            }
            case 85: {
                return this.readUnicode8Escape();
            }
        }
        this.fatal("Illegal unicode escape sequence value: \\%c (0x%02X)", ch, ch);
        return 0;
    }

    private final int readLiteralEscape() {
        int c = this.reader.readChar();
        if (c == -1) {
            this.fatal("Escape sequence not completed", new Object[0]);
        }
        switch (c) {
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 102: {
                return 12;
            }
            case 98: {
                return 8;
            }
            case 34: {
                return 34;
            }
            case 39: {
                return 39;
            }
            case 92: {
                return 92;
            }
            case 117: {
                return this.readUnicode4Escape();
            }
            case 85: {
                return this.readUnicode8Escape();
            }
        }
        this.fatal("Illegal escape sequence value: %c (0x%02X)", c, c);
        return 0;
    }

    private final int readCharEscape() {
        int c = this.reader.readChar();
        if (c == -1) {
            this.fatal("Escape sequence not completed", new Object[0]);
        }
        switch (c) {
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 95: 
            case 126: {
                return c;
            }
        }
        this.fatal("illegal character escape value: \\%c", c);
        return 0;
    }

    private final int readUnicode4Escape() {
        return this.readHexSequence(4);
    }

    private final int readUnicode8Escape() {
        int ch8 = this.readHexSequence(8);
        if (!Character.isValidCodePoint(ch8)) {
            this.fatal("Illegal code point from \\U sequence value: 0x%08X", ch8);
        }
        return ch8;
    }

    private final int readHexSequence(int N) {
        int x = 0;
        for (int i = 0; i < N; ++i) {
            int d = this.readHexChar();
            if (d < 0) {
                return -1;
            }
            x = (x << 4) + d;
        }
        return x;
    }

    private final int readHexChar() {
        int x;
        int ch = this.reader.readChar();
        if (ch == -1) {
            this.fatal("Not a hexadecimal character (end of file)", new Object[0]);
        }
        if ((x = RiotChars.valHexChar(ch)) != -1) {
            return x;
        }
        this.fatal("Not a hexadecimal character: '%c'", Character.valueOf((char)ch));
        return -1;
    }

    private boolean expect(String str2) {
        for (int i = 0; i < str2.length(); ++i) {
            char want = str2.charAt(i);
            if (this.reader.eof()) {
                this.fatal("End of input during expected string: %s", str2);
                return false;
            }
            int inChar = this.reader.peekChar();
            if (inChar != want) {
                this.fatal("expected \"%s\"", str2);
                return false;
            }
            this.reader.readChar();
        }
        return true;
    }

    private void warning(String message, Object ... args) {
        String msg = String.format(message, args);
        this.errorHandler.warning(msg, this.reader.getLineNum(), this.reader.getColNum());
    }

    private void error(String message, Object ... args) {
        String msg = String.format(message, args);
        this.errorHandler.error(msg, this.reader.getLineNum(), this.reader.getColNum());
    }

    private void fatal(String message, Object ... args) {
        String msg = String.format(message, args);
        long line = this.reader.getLineNum();
        long col = this.reader.getColNum();
        this.errorHandler.fatal(msg, line, col);
        throw new RiotParseException(message, line, col);
    }

    private void checkBlankNode(String blankNodeLabel) {
        if (this.checker != null) {
            this.checker.checkBlankNode(blankNodeLabel);
        }
    }

    private void checkLiteralLang(String lexicalForm, String langTag) {
        if (this.checker != null) {
            this.checker.checkLiteralLang(lexicalForm, langTag);
        }
    }

    private void checkLiteralDT(String lexicalForm, Token datatype) {
        if (this.checker != null) {
            this.checker.checkLiteralDT(lexicalForm, datatype);
        }
    }

    private void checkString(String string) {
        if (this.checker != null) {
            this.checker.checkString(string);
        }
    }

    private void checkURI(String uriStr) {
        if (this.checker != null) {
            this.checker.checkURI(uriStr);
        }
    }

    private void checkNumber(String image, String datatype) {
        if (this.checker != null) {
            this.checker.checkNumber(image, datatype);
        }
    }

    private void checkVariable(String tokenImage) {
        if (this.checker != null) {
            this.checker.checkVariable(tokenImage);
        }
    }

    private void checkDirective(String directive) {
        if (this.checker != null) {
            this.checker.checkDirective(directive);
        }
    }

    private void checkKeyword(String tokenImage) {
        if (this.checker != null) {
            this.checker.checkKeyword(tokenImage);
        }
    }

    private void checkPrefixedName(String tokenImage, String tokenImage2) {
        if (this.checker != null) {
            this.checker.checkPrefixedName(tokenImage, tokenImage2);
        }
    }

    private void checkControl(int code) {
        if (this.checker != null) {
            this.checker.checkControl(code);
        }
    }
}

