/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import java.util.ArrayList;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpExtendAssign;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;

public class TransformRemoveAssignment
extends TransformCopy {
    private Var var;
    private Expr expr;
    private boolean topmostOnly = true;
    private boolean aboveExtend = false;

    public TransformRemoveAssignment(Var var, Expr expr, boolean topmostOnly) {
        this.var = var;
        this.expr = expr;
        this.topmostOnly = topmostOnly;
    }

    public TransformRemoveAssignment(Var var, Expr expr) {
        this(var, expr, true);
    }

    @Override
    public Op transform(OpAssign opAssign, Op subOp) {
        VarExprList assignments = this.processAssignments(opAssign);
        if (assignments == null) {
            return super.transform(opAssign, subOp);
        }
        if (this.topmostOnly) {
            if (assignments.size() > 0) {
                return OpAssign.assign(opAssign.getSubOp(), assignments);
            }
            return opAssign.getSubOp();
        }
        if (assignments.size() > 0) {
            return OpAssign.assign(subOp, assignments);
        }
        return subOp;
    }

    private VarExprList processAssignments(OpExtendAssign opAssign) {
        VarExprList orig = opAssign.getVarExprList();
        if (!orig.contains(this.var)) {
            return null;
        }
        if (!orig.getExpr(this.var).equals(this.expr)) {
            return null;
        }
        VarExprList modified = new VarExprList();
        for (Var v : orig.getVars()) {
            if (v.equals(this.var)) continue;
            modified.add(v, orig.getExpr(v));
        }
        if (modified.size() > 0 && modified.size() == orig.size()) {
            return null;
        }
        return modified;
    }

    @Override
    public Op transform(OpExtend opExtend, Op subOp) {
        VarExprList assignments = this.processAssignments(opExtend);
        if (assignments == null) {
            return super.transform(opExtend, subOp);
        }
        this.aboveExtend = true;
        if (this.topmostOnly) {
            if (assignments.size() > 0) {
                return OpExtend.create(opExtend.getSubOp(), assignments);
            }
            return opExtend.getSubOp();
        }
        if (assignments.size() > 0) {
            return OpExtend.create(subOp, assignments);
        }
        return subOp;
    }

    @Override
    public Op transform(OpProject opProject, Op subOp) {
        if (!opProject.getVars().contains(this.var)) {
            return super.transform(opProject, subOp);
        }
        ArrayList<Var> newVars = new ArrayList<Var>(opProject.getVars());
        newVars.remove(this.var);
        if (this.topmostOnly) {
            if (this.aboveExtend) {
                return new OpProject(subOp, newVars);
            }
            return opProject;
        }
        return new OpProject(subOp, newVars);
    }
}

