/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.hnsw;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.UpdateableRandomVectorScorer;

public class DefaultFlatVectorScorer
implements FlatVectorsScorer {
    public static final DefaultFlatVectorScorer INSTANCE = new DefaultFlatVectorScorer();

    @Override
    public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues) throws IOException {
        switch (vectorValues.getEncoding()) {
            case FLOAT32: {
                return new FloatScoringSupplier((FloatVectorValues)vectorValues, similarityFunction);
            }
            case BYTE: {
                return new ByteScoringSupplier((ByteVectorValues)vectorValues, similarityFunction);
            }
        }
        throw new IllegalArgumentException("vectorValues must be an instance of FloatVectorValues or ByteVectorValues, got a " + vectorValues.getClass().getName());
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, float[] target) throws IOException {
        assert (vectorValues instanceof FloatVectorValues);
        if (target.length != vectorValues.dimension()) {
            throw new IllegalArgumentException("vector query dimension: " + target.length + " differs from field dimension: " + vectorValues.dimension());
        }
        return new FloatVectorScorer((FloatVectorValues)vectorValues, target, similarityFunction);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, byte[] target) throws IOException {
        assert (vectorValues instanceof ByteVectorValues);
        if (target.length != vectorValues.dimension()) {
            throw new IllegalArgumentException("vector query dimension: " + target.length + " differs from field dimension: " + vectorValues.dimension());
        }
        return new ByteVectorScorer((ByteVectorValues)vectorValues, target, similarityFunction);
    }

    public String toString() {
        return "DefaultFlatVectorScorer()";
    }

    private static final class FloatScoringSupplier
    implements RandomVectorScorerSupplier {
        private final FloatVectorValues vectors;
        private final FloatVectorValues targetVectors;
        private final VectorSimilarityFunction similarityFunction;

        private FloatScoringSupplier(FloatVectorValues vectors, VectorSimilarityFunction similarityFunction) throws IOException {
            this.vectors = vectors;
            this.targetVectors = vectors.copy();
            this.similarityFunction = similarityFunction;
        }

        @Override
        public UpdateableRandomVectorScorer scorer() throws IOException {
            final float[] vector = new float[this.vectors.dimension()];
            return new UpdateableRandomVectorScorer.AbstractUpdateableRandomVectorScorer(this.vectors){

                @Override
                public float score(int node) throws IOException {
                    return similarityFunction.compare(vector, targetVectors.vectorValue(node));
                }

                @Override
                public void setScoringOrdinal(int node) throws IOException {
                    System.arraycopy(targetVectors.vectorValue(node), 0, vector, 0, vector.length);
                }
            };
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new FloatScoringSupplier(this.vectors, this.similarityFunction);
        }

        public String toString() {
            return "FloatScoringSupplier(similarityFunction=" + String.valueOf((Object)this.similarityFunction) + ")";
        }
    }

    private static final class ByteScoringSupplier
    implements RandomVectorScorerSupplier {
        private final ByteVectorValues vectors;
        private final ByteVectorValues targetVectors;
        private final VectorSimilarityFunction similarityFunction;

        private ByteScoringSupplier(ByteVectorValues vectors, VectorSimilarityFunction similarityFunction) throws IOException {
            this.vectors = vectors;
            this.targetVectors = vectors.copy();
            this.similarityFunction = similarityFunction;
        }

        @Override
        public UpdateableRandomVectorScorer scorer() throws IOException {
            final byte[] vector = new byte[this.vectors.dimension()];
            return new UpdateableRandomVectorScorer.AbstractUpdateableRandomVectorScorer(this.vectors){

                @Override
                public void setScoringOrdinal(int node) throws IOException {
                    System.arraycopy(targetVectors.vectorValue(node), 0, vector, 0, vector.length);
                }

                @Override
                public float score(int node) throws IOException {
                    return similarityFunction.compare(vector, targetVectors.vectorValue(node));
                }
            };
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new ByteScoringSupplier(this.vectors, this.similarityFunction);
        }

        public String toString() {
            return "ByteScoringSupplier(similarityFunction=" + String.valueOf((Object)this.similarityFunction) + ")";
        }
    }

    private static class FloatVectorScorer
    extends RandomVectorScorer.AbstractRandomVectorScorer {
        private final FloatVectorValues values;
        private final float[] query;
        private final VectorSimilarityFunction similarityFunction;

        public FloatVectorScorer(FloatVectorValues values, float[] query2, VectorSimilarityFunction similarityFunction) {
            super(values);
            this.values = values;
            this.query = query2;
            this.similarityFunction = similarityFunction;
        }

        @Override
        public float score(int node) throws IOException {
            return this.similarityFunction.compare(this.query, this.values.vectorValue(node));
        }
    }

    private static class ByteVectorScorer
    extends RandomVectorScorer.AbstractRandomVectorScorer {
        private final ByteVectorValues values;
        private final byte[] query;
        private final VectorSimilarityFunction similarityFunction;

        public ByteVectorScorer(ByteVectorValues values, byte[] query2, VectorSimilarityFunction similarityFunction) {
            super(values);
            this.values = values;
            this.query = query2;
            this.similarityFunction = similarityFunction;
        }

        @Override
        public float score(int node) throws IOException {
            return this.similarityFunction.compare(this.query, this.values.vectorValue(node));
        }
    }
}

