/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.MultiDoubleValues;
import org.apache.lucene.facet.MultiDoubleValuesSource;
import org.apache.lucene.facet.range.DoubleRange;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeCounter;
import org.apache.lucene.facet.range.RangeFacetCounts;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;

public class DoubleRangeFacetCounts
extends RangeFacetCounts {
    public DoubleRangeFacetCounts(String field, FacetsCollector hits, DoubleRange ... ranges) throws IOException {
        this(field, (DoubleValuesSource)null, hits, ranges);
    }

    public DoubleRangeFacetCounts(String field, DoubleValuesSource valueSource, FacetsCollector hits, DoubleRange ... ranges) throws IOException {
        this(field, valueSource, hits, (Query)null, ranges);
    }

    public DoubleRangeFacetCounts(String field, MultiDoubleValuesSource valuesSource, FacetsCollector hits, DoubleRange ... ranges) throws IOException {
        this(field, valuesSource, hits, (Query)null, ranges);
    }

    public DoubleRangeFacetCounts(String field, DoubleValuesSource valueSource, FacetsCollector hits, Query fastMatchQuery, DoubleRange ... ranges) throws IOException {
        super(field, ranges, fastMatchQuery);
        if (valueSource != null) {
            this.count(valueSource, hits.getMatchingDocs());
        } else {
            this.count(field, hits.getMatchingDocs());
        }
    }

    public DoubleRangeFacetCounts(String field, MultiDoubleValuesSource valuesSource, FacetsCollector hits, Query fastMatchQuery, DoubleRange ... ranges) throws IOException {
        super(field, ranges, fastMatchQuery);
        if (valuesSource != null) {
            DoubleValuesSource singleValues = MultiDoubleValuesSource.unwrapSingleton(valuesSource);
            if (singleValues != null) {
                this.count(singleValues, hits.getMatchingDocs());
            } else {
                this.count(valuesSource, hits.getMatchingDocs());
            }
        } else {
            this.count(field, hits.getMatchingDocs());
        }
    }

    private void count(DoubleValuesSource valueSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        LongRangeCounter counter = null;
        int missingCount = 0;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            DocIdSetIterator it;
            if (hits.totalHits() == 0 || (it = this.createIterator(hits, new DocIdSetIterator[0])) == null) continue;
            if (counter == null) {
                counter = this.setupCounter();
            }
            DoubleValues fv = valueSource.getValues(hits.context(), null);
            this.totCount += hits.totalHits();
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (fv.advanceExact(doc)) {
                    counter.addSingleValued(NumericUtils.doubleToSortableLong(fv.doubleValue()));
                } else {
                    ++missingCount;
                }
                doc = it.nextDoc();
            }
        }
        if (counter != null) {
            this.totCount -= (missingCount += counter.finish());
        }
    }

    private void count(MultiDoubleValuesSource valueSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        LongRangeCounter counter = null;
        int missingCount = 0;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            DocIdSetIterator it;
            if (hits.totalHits() == 0 || (it = this.createIterator(hits, new DocIdSetIterator[0])) == null) continue;
            if (counter == null) {
                counter = this.setupCounter();
            }
            MultiDoubleValues multiValues = valueSource.getValues(hits.context());
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (multiValues.advanceExact(doc)) {
                    long limit = multiValues.getValueCount();
                    if (limit == 1L) {
                        counter.addSingleValued(NumericUtils.doubleToSortableLong(multiValues.nextValue()));
                        ++this.totCount;
                    } else {
                        counter.startMultiValuedDoc();
                        long previous = 0L;
                        int i = 0;
                        while ((long)i < limit) {
                            long val = NumericUtils.doubleToSortableLong(multiValues.nextValue());
                            if (i == 0 || val != previous) {
                                counter.addMultiValued(val);
                                previous = val;
                            }
                            ++i;
                        }
                        if (counter.endMultiValuedDoc()) {
                            ++this.totCount;
                        }
                    }
                }
                doc = it.nextDoc();
            }
        }
        if (counter != null) {
            this.totCount -= (missingCount += counter.finish());
        }
    }

    @Override
    protected LongRange[] getLongRanges() {
        DoubleRange[] ranges = (DoubleRange[])this.ranges;
        LongRange[] longRanges = new LongRange[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            DoubleRange range = ranges[i];
            longRanges[i] = new LongRange(range.label, NumericUtils.doubleToSortableLong(range.min), true, NumericUtils.doubleToSortableLong(range.max), true);
        }
        return longRanges;
    }

    @Override
    protected long mapDocValue(long l) {
        return NumericUtils.sortableDoubleBits(l);
    }
}

