/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.Context;
import org.apache.juneau.annotation.ExternalDocs;
import org.apache.juneau.annotation.ExternalDocsAnnotation;
import org.apache.juneau.annotation.Items;
import org.apache.juneau.annotation.ItemsAnnotation;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.annotation.SubItemsAnnotation;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.annotation.AppliedOnClassAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.jsonschema.SchemaUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.svl.VarResolverSession;

public class SchemaAnnotation {
    public static final Schema DEFAULT = SchemaAnnotation.create().build();

    public static JsonMap asMap(Schema a) throws ParseException {
        if (a == null) {
            return JsonMap.EMPTY_MAP;
        }
        JsonMap m = new JsonMap();
        if (SchemaAnnotation.empty(a)) {
            return m;
        }
        Predicate<String> ne = Utils::ne;
        Predicate<Collection> nec = Utils::ne;
        Predicate<Map> nem = Utils::ne;
        Predicate<Boolean> nf = Utils::isTrue;
        Predicate<Long> nm1 = Utils::nm1;
        return m.appendIf(nem, "additionalProperties", SchemaUtils.parseMap(a.additionalProperties())).appendIf(ne, "allOf", SchemaUtils.joinnl(new String[][]{a.allOf()})).appendFirst(ne, "collectionFormat", a.collectionFormat(), a.cf()).appendIf(ne, "default", SchemaUtils.joinnl(a.default_(), a.df())).appendIf(ne, "discriminator", a.discriminator()).appendIf(ne, "description", SchemaUtils.joinnl(a.description(), a.d())).appendFirst(nec, "enum", SchemaUtils.parseSet(a.enum_()), SchemaUtils.parseSet(a.e())).appendIf(ne, "exclusiveMaximum", ne.test(a.exclusiveMaximumValue()) ? a.exclusiveMaximumValue() : (a.exclusiveMaximum() || a.emax() ? "true" : null)).appendIf(ne, "exclusiveMinimum", ne.test(a.exclusiveMinimumValue()) ? a.exclusiveMinimumValue() : (a.exclusiveMinimum() || a.emin() ? "true" : null)).appendIf(nem, "externalDocs", ExternalDocsAnnotation.merge(m.getMap("externalDocs"), a.externalDocs())).appendFirst(ne, "format", a.format(), a.f()).appendIf(ne, "ignore", a.ignore() ? "true" : null).appendIf(nem, "items", SchemaAnnotation.merge(m.getMap("items"), a.items())).appendFirst(ne, "maximum", a.maximum(), a.max()).appendFirst(nm1, "maxItems", a.maxItems(), a.maxi()).appendFirst(nm1, "maxLength", a.maxLength(), a.maxl()).appendFirst(nm1, "maxProperties", a.maxProperties(), a.maxp()).appendFirst(ne, "minimum", a.minimum(), a.min()).appendFirst(nm1, "minItems", a.minItems(), a.mini()).appendFirst(nm1, "minLength", a.minLength(), a.minl()).appendFirst(nm1, "minProperties", a.minProperties(), a.minp()).appendFirst(ne, "multipleOf", a.multipleOf(), a.mo()).appendFirst(ne, "pattern", a.pattern(), a.p()).appendIf(nem, "properties", SchemaUtils.parseMap(a.properties())).appendIf(nf, "readOnly", a.readOnly() || a.ro()).appendIf(nf, "required", a.required() || a.r()).appendIf(ne, "title", a.title()).appendFirst(ne, "type", a.type(), a.t()).appendIf(nf, "uniqueItems", a.uniqueItems() || a.ui()).appendIf(ne, "xml", SchemaUtils.joinnl(new String[][]{a.xml()})).appendIf(ne, "$ref", a.$ref()).appendIf(ne, "const", SchemaUtils.joinnl(new String[][]{a.const_()})).appendIf(nec, "examples", a.examples().length == 0 ? null : CollectionUtils.l((java.lang.Object[])a.examples())).appendIf(ne, "$comment", SchemaUtils.joinnl(new String[][]{a.$comment()})).appendIf(nf, "deprecated", a.deprecatedProperty()).appendIf(ne, "contentMediaType", a.contentMediaType()).appendIf(ne, "contentEncoding", a.contentEncoding()).appendIf(ne, "prefixItems", SchemaUtils.joinnl(new String[][]{a.prefixItems()})).appendIf(ne, "unevaluatedItems", SchemaUtils.joinnl(new String[][]{a.unevaluatedItems()})).appendIf(ne, "unevaluatedProperties", SchemaUtils.joinnl(new String[][]{a.unevaluatedProperties()})).appendIf(ne, "dependentSchemas", SchemaUtils.joinnl(new String[][]{a.dependentSchemas()})).appendIf(ne, "dependentRequired", SchemaUtils.joinnl(new String[][]{a.dependentRequired()})).appendIf(ne, "if", SchemaUtils.joinnl(new String[][]{a.if_()})).appendIf(ne, "then", SchemaUtils.joinnl(new String[][]{a.then_()})).appendIf(ne, "else", SchemaUtils.joinnl(new String[][]{a.else_()})).appendIf(ne, "$defs", SchemaUtils.joinnl(new String[][]{a.$defs()})).appendIf(ne, "$id", a.$id());
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return SchemaAnnotation.create().on(on);
    }

    public static Builder create(String ... on) {
        return SchemaAnnotation.create().on(on);
    }

    public static boolean empty(Schema a) {
        return a == null || DEFAULT.equals(a);
    }

    private static JsonMap merge(JsonMap m, Items a) throws ParseException {
        if (ItemsAnnotation.empty(a)) {
            return m;
        }
        Predicate<String> ne = Utils::ne;
        Predicate<Collection> nec = Utils::ne;
        Predicate<Map> nem = Utils::ne;
        Predicate<Boolean> nf = Utils::isTrue;
        Predicate<Long> nm1 = Utils::nm1;
        return m.appendFirst(ne, "collectionFormat", a.collectionFormat(), a.cf()).appendIf(ne, "default", SchemaUtils.joinnl(a.default_(), a.df())).appendFirst(nec, "enum", SchemaUtils.parseSet(a.enum_()), SchemaUtils.parseSet(a.e())).appendFirst(ne, "format", a.format(), a.f()).appendIf(nf, "exclusiveMaximum", a.exclusiveMaximum() || a.emax()).appendIf(nf, "exclusiveMinimum", a.exclusiveMinimum() || a.emin()).appendIf(nem, "items", SubItemsAnnotation.merge(m.getMap("items"), a.items())).appendFirst(ne, "maximum", a.maximum(), a.max()).appendFirst(nm1, "maxItems", a.maxItems(), a.maxi()).appendFirst(nm1, "maxLength", a.maxLength(), a.maxl()).appendFirst(ne, "minimum", a.minimum(), a.min()).appendFirst(nm1, "minItems", a.minItems(), a.mini()).appendFirst(nm1, "minLength", a.minLength(), a.minl()).appendFirst(ne, "multipleOf", a.multipleOf(), a.mo()).appendFirst(ne, "pattern", a.pattern(), a.p()).appendIf(nf, "uniqueItems", a.uniqueItems() || a.ui()).appendFirst(ne, "type", a.type(), a.t()).appendIf(ne, "$ref", a.$ref());
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderTMF {
        private boolean aev;
        private boolean allowEmptyValue;
        private boolean emax;
        private boolean emin;
        private boolean exclusiveMaximum;
        private boolean exclusiveMinimum;
        private boolean ignore;
        private boolean r;
        private boolean readOnly;
        private boolean required;
        private boolean ro;
        private boolean sie;
        private boolean skipIfEmpty;
        private boolean ui;
        private boolean uniqueItems;
        private ExternalDocs externalDocs = ExternalDocsAnnotation.DEFAULT;
        private Items items = ItemsAnnotation.DEFAULT;
        private long maxi = -1L;
        private long maxItems = -1L;
        private long maxl = -1L;
        private long maxLength = -1L;
        private long maxp = -1L;
        private long maxProperties = -1L;
        private long mini = -1L;
        private long minItems = -1L;
        private long minl = -1L;
        private long minLength = -1L;
        private long minp = -1L;
        private long minProperties = -1L;
        private String $ref = "";
        private String cf = "";
        private String collectionFormat = "";
        private String discriminator = "";
        private String f = "";
        private String format = "";
        private String max = "";
        private String maximum = "";
        private String min = "";
        private String minimum = "";
        private String mo = "";
        private String multipleOf = "";
        private String p = "";
        private String pattern = "";
        private String t = "";
        private String title = "";
        private String type = "";
        private String[] default_ = new String[0];
        private String[] enum_ = new String[0];
        private String[] additionalProperties = new String[0];
        private String[] allOf = new String[0];
        private String[] d = new String[0];
        private String[] description = new String[0];
        private String[] df = new String[0];
        private String[] e = new String[0];
        private String[] properties = new String[0];
        private String[] xml = new String[0];
        private boolean deprecatedProperty;
        private String $id = "";
        private String contentMediaType = "";
        private String contentEncoding = "";
        private String exclusiveMaximumValue = "";
        private String exclusiveMinimumValue = "";
        private String[] const_ = new String[0];
        private String[] examples = new String[0];
        private String[] $comment = new String[0];
        private String[] prefixItems = new String[0];
        private String[] unevaluatedItems = new String[0];
        private String[] unevaluatedProperties = new String[0];
        private String[] dependentSchemas = new String[0];
        private String[] dependentRequired = new String[0];
        private String[] if_ = new String[0];
        private String[] then_ = new String[0];
        private String[] else_ = new String[0];
        private String[] $defs = new String[0];

        protected Builder() {
            super(Schema.class);
        }

        public Builder const_(String ... value) {
            this.const_ = value;
            return this;
        }

        public Builder default_(String ... value) {
            this.default_ = value;
            return this;
        }

        public Builder else_(String ... value) {
            this.else_ = value;
            return this;
        }

        public Builder enum_(String ... value) {
            this.enum_ = value;
            return this;
        }

        public Builder if_(String ... value) {
            this.if_ = value;
            return this;
        }

        public Builder then_(String ... value) {
            this.then_ = value;
            return this;
        }

        public Builder $comment(String ... value) {
            this.$comment = value;
            return this;
        }

        public Builder $defs(String ... value) {
            this.$defs = value;
            return this;
        }

        public Builder $id(String value) {
            this.$id = value;
            return this;
        }

        public Builder $ref(String value) {
            this.$ref = value;
            return this;
        }

        public Builder additionalProperties(String ... value) {
            this.additionalProperties = value;
            return this;
        }

        public Builder aev(boolean value) {
            this.aev = value;
            return this;
        }

        public Builder allOf(String ... value) {
            this.allOf = value;
            return this;
        }

        public Builder allowEmptyValue(boolean value) {
            this.allowEmptyValue = value;
            return this;
        }

        public Schema build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder cf(String value) {
            this.cf = value;
            return this;
        }

        public Builder collectionFormat(String value) {
            this.collectionFormat = value;
            return this;
        }

        public Builder contentEncoding(String value) {
            this.contentEncoding = value;
            return this;
        }

        public Builder contentMediaType(String value) {
            this.contentMediaType = value;
            return this;
        }

        public Builder d(String ... value) {
            this.d = value;
            return this;
        }

        public Builder dependentRequired(String ... value) {
            this.dependentRequired = value;
            return this;
        }

        public Builder dependentSchemas(String ... value) {
            this.dependentSchemas = value;
            return this;
        }

        public Builder deprecatedProperty(boolean value) {
            this.deprecatedProperty = value;
            return this;
        }

        public Builder df(String ... value) {
            this.df = value;
            return this;
        }

        public Builder discriminator(String value) {
            this.discriminator = value;
            return this;
        }

        public Builder e(String ... value) {
            this.e = value;
            return this;
        }

        public Builder emax(boolean value) {
            this.emax = value;
            return this;
        }

        public Builder emin(boolean value) {
            this.emin = value;
            return this;
        }

        public Builder examples(String ... value) {
            this.examples = value;
            return this;
        }

        public Builder exclusiveMaximum(boolean value) {
            this.exclusiveMaximum = value;
            return this;
        }

        public Builder exclusiveMaximumValue(String value) {
            this.exclusiveMaximumValue = value;
            return this;
        }

        public Builder exclusiveMinimum(boolean value) {
            this.exclusiveMinimum = value;
            return this;
        }

        public Builder exclusiveMinimumValue(String value) {
            this.exclusiveMinimumValue = value;
            return this;
        }

        public Builder externalDocs(ExternalDocs value) {
            this.externalDocs = value;
            return this;
        }

        public Builder f(String value) {
            this.f = value;
            return this;
        }

        public Builder format(String value) {
            this.format = value;
            return this;
        }

        public Builder ignore(boolean value) {
            this.ignore = value;
            return this;
        }

        public Builder items(Items value) {
            this.items = value;
            return this;
        }

        public Builder max(String value) {
            this.max = value;
            return this;
        }

        public Builder maxi(long value) {
            this.maxi = value;
            return this;
        }

        public Builder maximum(String value) {
            this.maximum = value;
            return this;
        }

        public Builder maxItems(long value) {
            this.maxItems = value;
            return this;
        }

        public Builder maxl(long value) {
            this.maxl = value;
            return this;
        }

        public Builder maxLength(long value) {
            this.maxLength = value;
            return this;
        }

        public Builder maxp(long value) {
            this.maxp = value;
            return this;
        }

        public Builder maxProperties(long value) {
            this.maxProperties = value;
            return this;
        }

        public Builder min(String value) {
            this.min = value;
            return this;
        }

        public Builder mini(long value) {
            this.mini = value;
            return this;
        }

        public Builder minimum(String value) {
            this.minimum = value;
            return this;
        }

        public Builder minItems(long value) {
            this.minItems = value;
            return this;
        }

        public Builder minl(long value) {
            this.minl = value;
            return this;
        }

        public Builder minLength(long value) {
            this.minLength = value;
            return this;
        }

        public Builder minp(long value) {
            this.minp = value;
            return this;
        }

        public Builder minProperties(long value) {
            this.minProperties = value;
            return this;
        }

        public Builder mo(String value) {
            this.mo = value;
            return this;
        }

        public Builder multipleOf(String value) {
            this.multipleOf = value;
            return this;
        }

        public Builder p(String value) {
            this.p = value;
            return this;
        }

        public Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        public Builder prefixItems(String ... value) {
            this.prefixItems = value;
            return this;
        }

        public Builder properties(String ... value) {
            this.properties = value;
            return this;
        }

        public Builder r(boolean value) {
            this.r = value;
            return this;
        }

        public Builder readOnly(boolean value) {
            this.readOnly = value;
            return this;
        }

        public Builder required(boolean value) {
            this.required = value;
            return this;
        }

        public Builder ro(boolean value) {
            this.ro = value;
            return this;
        }

        public Builder sie(boolean value) {
            this.sie = value;
            return this;
        }

        public Builder skipIfEmpty(boolean value) {
            this.skipIfEmpty = value;
            return this;
        }

        public Builder t(String value) {
            this.t = value;
            return this;
        }

        public Builder title(String value) {
            this.title = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder ui(boolean value) {
            this.ui = value;
            return this;
        }

        public Builder unevaluatedItems(String ... value) {
            this.unevaluatedItems = value;
            return this;
        }

        public Builder unevaluatedProperties(String ... value) {
            this.unevaluatedProperties = value;
            return this;
        }

        public Builder uniqueItems(boolean value) {
            this.uniqueItems = value;
            return this;
        }

        public Builder xml(String ... value) {
            this.xml = value;
            return this;
        }

        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        public Builder on(ClassInfo ... value) {
            super.on(value);
            return this;
        }

        public Builder onClass(ClassInfo ... value) {
            super.onClass(value);
            return this;
        }

        public Builder on(FieldInfo ... value) {
            super.on(value);
            return this;
        }

        public Builder on(MethodInfo ... value) {
            super.on(value);
            return this;
        }
    }

    private static class Object
    extends AppliedOnClassAnnotationObject
    implements Schema {
        private final String[] description;
        private final boolean aev;
        private final boolean allowEmptyValue;
        private final boolean exclusiveMaximum;
        private final boolean emax;
        private final boolean exclusiveMinimum;
        private final boolean emin;
        private final boolean uniqueItems;
        private final boolean ui;
        private final boolean required;
        private final boolean r;
        private final boolean readOnly;
        private final boolean ro;
        private final boolean sie;
        private final boolean skipIfEmpty;
        private final boolean ignore;
        private final ExternalDocs externalDocs;
        private final Items items;
        private final long maxLength;
        private final long maxl;
        private final long minLength;
        private final long minl;
        private final long maxItems;
        private final long maxi;
        private final long minItems;
        private final long mini;
        private final long maxProperties;
        private final long maxp;
        private final long minProperties;
        private final long minp;
        private final String $ref;
        private final String format;
        private final String f;
        private final String title;
        private final String multipleOf;
        private final String mo;
        private final String maximum;
        private final String max;
        private final String minimum;
        private final String min;
        private final String pattern;
        private final String p;
        private final String type;
        private final String t;
        private final String collectionFormat;
        private final String cf;
        private final String discriminator;
        private final String[] d;
        private final String[] default_;
        private final String[] df;
        private final String[] enum_;
        private final String[] e;
        private final String[] allOf;
        private final String[] properties;
        private final String[] additionalProperties;
        private final String[] xml;
        private final boolean deprecatedProperty;
        private final String $id;
        private final String contentMediaType;
        private final String contentEncoding;
        private final String exclusiveMaximumValue;
        private final String exclusiveMinimumValue;
        private final String[] const_;
        private final String[] examples;
        private final String[] $comment;
        private final String[] prefixItems;
        private final String[] unevaluatedItems;
        private final String[] unevaluatedProperties;
        private final String[] dependentSchemas;
        private final String[] dependentRequired;
        private final String[] if_;
        private final String[] then_;
        private final String[] else_;
        private final String[] $defs;

        Object(Builder b) {
            super((AppliedAnnotationObject.BuilderT)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.$ref = b.$ref;
            this.default_ = (String[])CollectionUtils.copyOf((java.lang.Object[])b.default_);
            this.enum_ = (String[])CollectionUtils.copyOf((java.lang.Object[])b.enum_);
            this.additionalProperties = (String[])CollectionUtils.copyOf((java.lang.Object[])b.additionalProperties);
            this.allOf = (String[])CollectionUtils.copyOf((java.lang.Object[])b.allOf);
            this.aev = b.aev;
            this.allowEmptyValue = b.allowEmptyValue;
            this.cf = b.cf;
            this.collectionFormat = b.collectionFormat;
            this.d = (String[])CollectionUtils.copyOf((java.lang.Object[])b.d);
            this.df = (String[])CollectionUtils.copyOf((java.lang.Object[])b.df);
            this.discriminator = b.discriminator;
            this.e = (String[])CollectionUtils.copyOf((java.lang.Object[])b.e);
            this.emax = b.emax;
            this.emin = b.emin;
            this.exclusiveMaximum = b.exclusiveMaximum;
            this.exclusiveMinimum = b.exclusiveMinimum;
            this.externalDocs = b.externalDocs;
            this.f = b.f;
            this.format = b.format;
            this.ignore = b.ignore;
            this.items = b.items;
            this.max = b.max;
            this.maxi = b.maxi;
            this.maximum = b.maximum;
            this.maxItems = b.maxItems;
            this.maxl = b.maxl;
            this.maxLength = b.maxLength;
            this.maxp = b.maxp;
            this.maxProperties = b.maxProperties;
            this.min = b.min;
            this.mini = b.mini;
            this.minimum = b.minimum;
            this.minItems = b.minItems;
            this.minl = b.minl;
            this.minLength = b.minLength;
            this.minp = b.minp;
            this.minProperties = b.minProperties;
            this.mo = b.mo;
            this.multipleOf = b.multipleOf;
            this.p = b.p;
            this.pattern = b.pattern;
            this.properties = (String[])CollectionUtils.copyOf((java.lang.Object[])b.properties);
            this.r = b.r;
            this.readOnly = b.readOnly;
            this.required = b.required;
            this.ro = b.ro;
            this.sie = b.sie;
            this.skipIfEmpty = b.skipIfEmpty;
            this.t = b.t;
            this.title = b.title;
            this.type = b.type;
            this.ui = b.ui;
            this.uniqueItems = b.uniqueItems;
            this.xml = (String[])CollectionUtils.copyOf((java.lang.Object[])b.xml);
            this.deprecatedProperty = b.deprecatedProperty;
            this.$id = b.$id;
            this.contentMediaType = b.contentMediaType;
            this.contentEncoding = b.contentEncoding;
            this.exclusiveMaximumValue = b.exclusiveMaximumValue;
            this.exclusiveMinimumValue = b.exclusiveMinimumValue;
            this.const_ = (String[])CollectionUtils.copyOf((java.lang.Object[])b.const_);
            this.examples = (String[])CollectionUtils.copyOf((java.lang.Object[])b.examples);
            this.$comment = (String[])CollectionUtils.copyOf((java.lang.Object[])b.$comment);
            this.prefixItems = (String[])CollectionUtils.copyOf((java.lang.Object[])b.prefixItems);
            this.unevaluatedItems = (String[])CollectionUtils.copyOf((java.lang.Object[])b.unevaluatedItems);
            this.unevaluatedProperties = (String[])CollectionUtils.copyOf((java.lang.Object[])b.unevaluatedProperties);
            this.dependentSchemas = (String[])CollectionUtils.copyOf((java.lang.Object[])b.dependentSchemas);
            this.dependentRequired = (String[])CollectionUtils.copyOf((java.lang.Object[])b.dependentRequired);
            this.if_ = (String[])CollectionUtils.copyOf((java.lang.Object[])b.if_);
            this.then_ = (String[])CollectionUtils.copyOf((java.lang.Object[])b.then_);
            this.else_ = (String[])CollectionUtils.copyOf((java.lang.Object[])b.else_);
            this.$defs = (String[])CollectionUtils.copyOf((java.lang.Object[])b.$defs);
        }

        @Override
        public String[] const_() {
            return this.const_;
        }

        @Override
        public String[] default_() {
            return this.default_;
        }

        @Override
        public String[] else_() {
            return this.else_;
        }

        @Override
        public String[] enum_() {
            return this.enum_;
        }

        @Override
        public String[] if_() {
            return this.if_;
        }

        @Override
        public String[] then_() {
            return this.then_;
        }

        @Override
        public String[] $comment() {
            return this.$comment;
        }

        @Override
        public String[] $defs() {
            return this.$defs;
        }

        @Override
        public String $id() {
            return this.$id;
        }

        @Override
        public String $ref() {
            return this.$ref;
        }

        @Override
        public String[] additionalProperties() {
            return this.additionalProperties;
        }

        @Override
        public boolean aev() {
            return this.aev;
        }

        @Override
        public String[] allOf() {
            return this.allOf;
        }

        @Override
        public boolean allowEmptyValue() {
            return this.allowEmptyValue;
        }

        @Override
        public String cf() {
            return this.cf;
        }

        @Override
        public String collectionFormat() {
            return this.collectionFormat;
        }

        @Override
        public String contentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public String contentMediaType() {
            return this.contentMediaType;
        }

        @Override
        public String[] d() {
            return this.d;
        }

        @Override
        public String[] dependentRequired() {
            return this.dependentRequired;
        }

        @Override
        public String[] dependentSchemas() {
            return this.dependentSchemas;
        }

        @Override
        public boolean deprecatedProperty() {
            return this.deprecatedProperty;
        }

        @Override
        public String[] df() {
            return this.df;
        }

        @Override
        public String discriminator() {
            return this.discriminator;
        }

        @Override
        public String[] e() {
            return this.e;
        }

        @Override
        public boolean emax() {
            return this.emax;
        }

        @Override
        public boolean emin() {
            return this.emin;
        }

        @Override
        public String[] examples() {
            return this.examples;
        }

        @Override
        public boolean exclusiveMaximum() {
            return this.exclusiveMaximum;
        }

        @Override
        public String exclusiveMaximumValue() {
            return this.exclusiveMaximumValue;
        }

        @Override
        public boolean exclusiveMinimum() {
            return this.exclusiveMinimum;
        }

        @Override
        public String exclusiveMinimumValue() {
            return this.exclusiveMinimumValue;
        }

        @Override
        public ExternalDocs externalDocs() {
            return this.externalDocs;
        }

        @Override
        public String f() {
            return this.f;
        }

        @Override
        public String format() {
            return this.format;
        }

        @Override
        public boolean ignore() {
            return this.ignore;
        }

        @Override
        public Items items() {
            return this.items;
        }

        @Override
        public String max() {
            return this.max;
        }

        @Override
        public long maxi() {
            return this.maxi;
        }

        @Override
        public String maximum() {
            return this.maximum;
        }

        @Override
        public long maxItems() {
            return this.maxItems;
        }

        @Override
        public long maxl() {
            return this.maxl;
        }

        @Override
        public long maxLength() {
            return this.maxLength;
        }

        @Override
        public long maxp() {
            return this.maxp;
        }

        @Override
        public long maxProperties() {
            return this.maxProperties;
        }

        @Override
        public String min() {
            return this.min;
        }

        @Override
        public long mini() {
            return this.mini;
        }

        @Override
        public String minimum() {
            return this.minimum;
        }

        @Override
        public long minItems() {
            return this.minItems;
        }

        @Override
        public long minl() {
            return this.minl;
        }

        @Override
        public long minLength() {
            return this.minLength;
        }

        @Override
        public long minp() {
            return this.minp;
        }

        @Override
        public long minProperties() {
            return this.minProperties;
        }

        @Override
        public String mo() {
            return this.mo;
        }

        @Override
        public String multipleOf() {
            return this.multipleOf;
        }

        @Override
        public String p() {
            return this.p;
        }

        @Override
        public String pattern() {
            return this.pattern;
        }

        @Override
        public String[] prefixItems() {
            return this.prefixItems;
        }

        @Override
        public String[] properties() {
            return this.properties;
        }

        @Override
        public boolean r() {
            return this.r;
        }

        @Override
        public boolean readOnly() {
            return this.readOnly;
        }

        @Override
        public boolean required() {
            return this.required;
        }

        @Override
        public boolean ro() {
            return this.ro;
        }

        @Override
        public boolean sie() {
            return this.sie;
        }

        @Override
        public boolean skipIfEmpty() {
            return this.skipIfEmpty;
        }

        @Override
        public String t() {
            return this.t;
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public boolean ui() {
            return this.ui;
        }

        @Override
        public String[] unevaluatedItems() {
            return this.unevaluatedItems;
        }

        @Override
        public String[] unevaluatedProperties() {
            return this.unevaluatedProperties;
        }

        @Override
        public boolean uniqueItems() {
            return this.uniqueItems;
        }

        @Override
        public String[] xml() {
            return this.xml;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Schema[] value();
    }

    public static class Apply
    extends AnnotationApplier<Schema, Context.Builder> {
        public Apply(VarResolverSession vr) {
            super(Schema.class, Context.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Schema> ai, Context.Builder b) {
            Schema a = (Schema)ai.inner();
            if (CollectionUtils.isEmptyArray((java.lang.Object[])a.on()) && CollectionUtils.isEmptyArray((java.lang.Object[])a.onClass())) {
                return;
            }
            b.annotations(a);
        }
    }
}

