/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit.generator;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.audit.generator.AccessorDefinition;
import org.apache.logging.log4j.audit.generator.ConstructorDefinition;
import org.apache.logging.log4j.audit.generator.MethodDefinition;
import org.apache.logging.log4j.audit.generator.VariableDefinition;
import org.apache.logging.log4j.audit.util.NamingUtils;

public final class ClassGenerator {
    private static final Logger LOGGER = LogManager.getLogger(ClassGenerator.class);
    protected List<AccessorDefinition> beanMethods = new ArrayList<AccessorDefinition>();
    private boolean isClass = true;
    private String className;
    private String parentClassName;
    private String packageName;
    private String baseFolder;
    private String javadocComment;
    private boolean verbose;
    private List<String> implementsDeclarations = new ArrayList<String>();
    private Set<String> importsDeclarations = new HashSet<String>();
    private List<VariableDefinition> localVariables = new ArrayList<VariableDefinition>();
    private List<ConstructorDefinition> constructors = new ArrayList<ConstructorDefinition>();
    private List<MethodDefinition> methods = new ArrayList<MethodDefinition>();
    private boolean runPrewrite = false;
    private boolean isAbstract = false;
    private String visability = "public";
    private String annotations = null;
    private String code = null;
    private String typeStatement = null;

    public ClassGenerator(String className, String baseFolder) {
        this.className = className;
        this.baseFolder = baseFolder;
    }

    public String getTypeStatement() {
        return this.typeStatement;
    }

    public void setTypeStatement(String typeStatement) {
        this.typeStatement = typeStatement;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void addBeanMethods(AccessorDefinition beanDefinition) {
        this.beanMethods.add(beanDefinition);
    }

    public void addConstructor(ConstructorDefinition constructorDefinition) {
        this.constructors.add(constructorDefinition);
    }

    public void addLocalVariable(VariableDefinition definition) {
        this.localVariables.add(definition);
    }

    public void addMethod(MethodDefinition definition) {
        this.methods.add(definition);
    }

    public void addSingelton(String name, List<String> parameters) {
        if (Character.isUpperCase(name.charAt(0))) {
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        VariableDefinition definition = new VariableDefinition("private", this.getClassName(), name, null);
        definition.setMakeStatic(true);
        this.addLocalVariable(definition);
        this.addMethod(MethodDefinition.getStandardSingleton(this.getClassName(), name, parameters));
    }

    public String getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(String annotations) {
        this.annotations = annotations;
    }

    public List<AccessorDefinition> getBeanMethods() {
        return this.beanMethods;
    }

    public String getClassName() {
        return this.className;
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    public void setParentClassName(String parentClassName) {
        this.parentClassName = parentClassName;
    }

    public List<String> getImplements() {
        return this.implementsDeclarations;
    }

    public Set<String> getImports() {
        return this.importsDeclarations;
    }

    public List<MethodDefinition> getMethodDefinitions() {
        return this.methods;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public List<VariableDefinition> getVariableDefinitions() {
        return this.localVariables;
    }

    public String getVisability() {
        return this.visability;
    }

    public void setVisability(String visability) {
        this.visability = visability;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public void setClass(boolean isClass) {
        this.isClass = isClass;
    }

    public void preWrite() {
    }

    public void generate() throws Exception {
        StringBuilder sb = new StringBuilder(this.baseFolder);
        if (this.getPackageName() != null) {
            sb.append("/").append(this.getPackageName().replaceAll("\\.", "/"));
        }
        sb.append("/").append(NamingUtils.upperFirst(this.getClassName())).append(".java");
        String fullPath = sb.toString();
        if (this.verbose) {
            LOGGER.info(fullPath);
        }
        File file = new File(fullPath);
        DataOutputStream out = new DataOutputStream(this.openOutputStream(file));
        out.writeBytes(this.getClassContents());
        out.close();
    }

    public String getClassContents() throws Exception {
        if (this.getClassName() == null) {
            throw new Exception("Class name has to be set");
        }
        if (!this.runPrewrite) {
            this.preWrite();
            this.runPrewrite = true;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(this.getPackageName()).append(";\n\n");
        if (this.getImports() != null) {
            ArrayList<String> list = new ArrayList<String>(this.getImports());
            Collections.sort(list);
            for (String element : list) {
                sb.append("import ").append(element).append(";\n");
            }
            sb.append("\n");
        }
        sb.append("/**\n");
        if (this.getJavadocComment() != null) {
            sb.append(" * ").append(this.getJavadocComment());
        }
        sb.append("\n * @author generated");
        sb.append("\n */\n");
        if (this.annotations != null) {
            sb.append(this.annotations);
            sb.append("\n");
        }
        sb.append(this.getVisability());
        if (this.isClass()) {
            sb.append(" class ");
        } else {
            sb.append(" interface ");
        }
        sb.append(this.getClassName());
        if (this.typeStatement != null) {
            sb.append(" <").append(this.typeStatement).append("> ");
        }
        if (this.getParentClassName() != null && this.getParentClassName().length() > 0) {
            sb.append(" extends ").append(this.getParentClassName());
        }
        if (this.getImplements() != null && this.getImplements().size() > 0) {
            sb.append(" implements ");
            boolean first = true;
            for (String element : this.getImplements()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(element);
                first = false;
            }
        }
        sb.append(" {\n\n");
        if (this.localVariables != null) {
            Collections.sort(this.localVariables);
            for (VariableDefinition variableDefinition : this.localVariables) {
                sb.append(variableDefinition).append("\n");
            }
        }
        if (this.constructors != null) {
            Collections.sort(this.constructors);
            for (ConstructorDefinition constructorDefinition : this.constructors) {
                sb.append(constructorDefinition).append("\n\n");
            }
        }
        if (this.beanMethods.size() > 0 && this.isClass()) {
            MethodDefinition definition = new MethodDefinition("String", "toString");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\tStringBuilder sb = new StringBuilder();");
            stringBuilder.append("\n\tsb.append(super.toString());");
            for (AccessorDefinition element : this.beanMethods) {
                stringBuilder.append("\n\tsb.append(\", ");
                stringBuilder.append(element.getName()).append("=\").append(").append(NamingUtils.getAccessorName(element.getName(), element.getType())).append("());");
            }
            stringBuilder.append("\n\treturn sb.toString();");
            definition.setContent(stringBuilder.toString());
            this.methods.add(definition);
        }
        if (this.methods != null) {
            Collections.sort(this.methods);
            for (MethodDefinition methodDefinition : this.methods) {
                sb.append(methodDefinition).append("\n\n");
            }
        }
        if (this.code != null) {
            sb.append(this.code).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public String getJavadocComment() {
        return this.javadocComment;
    }

    public void setJavadocComment(String javadocComment) {
        this.javadocComment = javadocComment;
    }

    private OutputStream openOutputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, false);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

