/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit.generator;

public class VariableDefinition
implements Comparable<VariableDefinition> {
    private String visability;
    private boolean makeStatic = false;
    private boolean makeFinal = false;
    private boolean createGetter = false;
    private boolean createSetter = false;
    private String type;
    private String name;
    private String initialValue;
    private String annotation = null;

    public VariableDefinition(String visability, String type, String name, String initialValue) {
        this.visability = visability;
        this.type = type;
        this.name = name;
        this.initialValue = initialValue;
    }

    public VariableDefinition(String visability, String type, String name, String initialValue, String annotation) {
        this.visability = visability;
        this.type = type;
        this.name = name;
        this.initialValue = initialValue;
        this.annotation = annotation;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getVisability() {
        return this.visability;
    }

    public boolean isCreateGetter() {
        return this.createGetter;
    }

    public boolean isCreateSetter() {
        return this.createSetter;
    }

    public boolean isMakeFinal() {
        return this.makeFinal;
    }

    public boolean isMakeStatic() {
        return this.makeStatic;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public void setCreateGetter(boolean createGetter) {
        this.createGetter = createGetter;
    }

    public void setCreateSetter(boolean createSetter) {
        this.createSetter = createSetter;
    }

    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    public void setMakeFinal(boolean makeFinal) {
        this.makeFinal = makeFinal;
    }

    public void setMakeStatic(boolean makeStatic) {
        this.makeStatic = makeStatic;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVisability(String visability) {
        this.visability = visability;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getAnnotation() != null) {
            sb.append(this.getAnnotation());
            sb.append("\n");
        }
        sb.append(this.visability).append(" ");
        if (this.isMakeStatic()) {
            sb.append("static ");
        }
        if (this.isMakeFinal()) {
            sb.append("final ");
        }
        sb.append(this.type).append(" ").append(this.name);
        if (this.initialValue != null && this.initialValue.length() > 0) {
            sb.append(" = ").append(this.initialValue);
        }
        sb.append(";");
        return sb.toString();
    }

    @Override
    public int compareTo(VariableDefinition arg0) {
        return this.getName().compareTo(arg0.getName());
    }
}

