/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public final class JsonObjectMapperFactory {
    public static final String LOCAL_DATE_TIME_FORMAT = "yyyyMMddHHmmss.SSS";
    public static final DateTimeFormatter LOCAL_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss.SSS");
    public static final String LOCAL_DATE_FORMAT = "yyyyMMdd";
    public static final DateTimeFormatter LOCAL_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final String ZONED_DATE_TIME_FORMAT = "yyyyMMddHHmmss.SSSZ";
    public static final DateTimeFormatter ZONED_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss.SSSZ");

    private JsonObjectMapperFactory() {
    }

    public static ObjectMapper createMapper() {
        ObjectMapper mapper = Jackson2ObjectMapperBuilder.json().build();
        final DateTimeFormatter dateTimeFormatter = LOCAL_DATE_TIME_FORMATTER;
        final DateTimeFormatter dateFormatter = LOCAL_DATE_FORMATTER;
        final DateTimeFormatter zonedTimeFormatter = ZONED_DATE_TIME_FORMATTER;
        SimpleModule module = new SimpleModule();
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new JsonSerializer<LocalDateTime>(){

            public void serialize(LocalDateTime localDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                jsonGenerator.writeString(dateTimeFormatter.format(localDateTime));
            }
        });
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new JsonDeserializer<LocalDateTime>(){

            public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                try {
                    return LocalDateTime.parse(string, dateTimeFormatter);
                }
                catch (DateTimeException e) {
                    throw JsonMappingException.from((JsonParser)parser, (String)String.format("Failed to deserialize %s: (%s) %s", this.handledType().getName(), e.getClass().getName(), e.getMessage()), (Throwable)e);
                }
            }
        });
        module.addSerializer(ZonedDateTime.class, (JsonSerializer)new JsonSerializer<ZonedDateTime>(){

            public void serialize(ZonedDateTime zonedDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                jsonGenerator.writeString(zonedTimeFormatter.format(zonedDateTime));
            }
        });
        module.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new JsonDeserializer<ZonedDateTime>(){

            public ZonedDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                try {
                    return ZonedDateTime.parse(string, zonedTimeFormatter);
                }
                catch (DateTimeException e) {
                    throw JsonMappingException.from((JsonParser)parser, (String)String.format("Failed to deserialize %s: (%s) %s", this.handledType().getName(), e.getClass().getName(), e.getMessage()), (Throwable)e);
                }
            }
        });
        module.addSerializer(LocalDate.class, (JsonSerializer)new JsonSerializer<LocalDate>(){

            public void serialize(LocalDate localDate, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                jsonGenerator.writeString(dateFormatter.format(localDate));
            }
        });
        module.addDeserializer(LocalDate.class, (JsonDeserializer)new JsonDeserializer<LocalDate>(){

            public LocalDate deserialize(JsonParser parser, DeserializationContext context) throws IOException {
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                try {
                    return LocalDate.parse(string, dateFormatter);
                }
                catch (DateTimeException e) {
                    throw JsonMappingException.from((JsonParser)parser, (String)String.format("Failed to deserialize %s: (%s) %s", this.handledType().getName(), e.getClass().getName(), e.getMessage()), (Throwable)e);
                }
            }
        });
        mapper.registerModule((Module)module);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }
}

