/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.api.dao;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.api.CatalogData;
import org.apache.logging.log4j.catalog.api.dao.AbstractCatalogReader;
import org.apache.logging.log4j.util.LoaderUtil;

public class ClassPathCatalogReader
extends AbstractCatalogReader {
    private static final Logger LOGGER = LogManager.getLogger(ClassPathCatalogReader.class);
    private static final String BASEDIR = "baseDir";
    private static final String CATALOG_ATTRIBUTE_NAME = "catalogFile";
    private static final String DEFAULT_CATALOG_FILE = "catalog.json";
    private final String catalog;
    private final LocalDateTime lastUpdated;

    public ClassPathCatalogReader(Map<String, String> attributes) throws IOException {
        URL catalogURL;
        String catalogFile = attributes != null ? attributes.getOrDefault(CATALOG_ATTRIBUTE_NAME, DEFAULT_CATALOG_FILE) : DEFAULT_CATALOG_FILE;
        Collection catalogs = LoaderUtil.findResources((String)catalogFile);
        if (catalogs.size() == 0) {
            LOGGER.error("No catalog named {} could be found on the class path", (Object)catalogFile);
            throw new FileNotFoundException("No catalog named " + catalogFile + " could be found");
        }
        if (catalogs.size() > 1) {
            catalogURL = (URL)catalogs.stream().findFirst().get();
            LOGGER.warn("Multiple catalogs named {} were found. Using {}", (Object)catalogFile, (Object)catalogURL.toString());
        } else {
            catalogURL = (URL)catalogs.stream().findFirst().get();
        }
        this.catalog = this.readCatalog(catalogURL);
        LocalDateTime localDateTime = null;
        try {
            URLConnection connection = catalogURL.openConnection();
            localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(connection.getLastModified()), ZoneId.systemDefault());
        }
        catch (IOException ioe) {
            LOGGER.warn("Unable to open connection to {}", (Object)catalogURL.toString());
        }
        this.lastUpdated = localDateTime;
        JsonFactory factory = new JsonFactory();
        factory.enable(JsonParser.Feature.ALLOW_COMMENTS);
        ObjectMapper objectMapper = new ObjectMapper(factory);
        this.catalogData = (CatalogData)objectMapper.readValue(this.catalog, CatalogData.class);
    }

    private String readCatalog(URL catalogUrl) throws IOException {
        try (InputStream is = catalogUrl.openStream();){
            int length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            String string = baos.toString("UTF-8");
            return string;
        }
    }

    public ClassPathCatalogReader() throws IOException {
        this(null);
    }

    @Override
    public String readCatalog() {
        return this.catalog;
    }

    @Override
    public LocalDateTime getLastUpdated() {
        return this.lastUpdated;
    }
}

