/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.api.dao.CatalogDao;
import org.apache.logging.log4j.catalog.api.util.CatalogEventFilter;
import org.apache.logging.log4j.catalog.config.ConfigurationService;
import org.apache.logging.log4j.catalog.config.JsonObjectMapperFactory;
import org.apache.logging.log4j.catalog.config.WebMvcAppContext;
import org.apache.logging.log4j.catalog.git.dao.GitCatalogDao;
import org.apache.logging.log4j.catalog.security.LocalAuthorizationInterceptor;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ComponentScan(basePackages={"org.apache.logging.log4j.catalog"})
public class WebMvcAppContext
extends WebMvcConfigurerAdapter
implements ApplicationContextAware {
    private static final Logger LOGGER = LogManager.getLogger(WebMvcAppContext.class);
    @Autowired
    ConfigurationService configurationService;
    private ApplicationContext applicationContext;
    @Value(value="${gitUserName")
    private String gitUserName;
    @Value(value="${gitPassword:#{null}}")
    private String gitPassword;
    @Value(value="${gitPassPhrase:#{null}}")
    private String gitPassPhrase;
    @Value(value="${localRepoUrl:#{null}}")
    private String localRepoUrl;
    @Value(value="${branch:#{null}}")
    private String branch;
    @Value(value="${privateKeyPath:#{null}}")
    private String privateKeyPath;
    @Value(value="${remoteRepoUrl}")
    private String remoteRepoUrl;
    @Value(value="${remoteRepoCatalogPath:#{null}}")
    private String remoteRepoCatalogPath;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
        configurer.enable();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        super.addResourceHandlers(registry);
        registry.addResourceHandler(new String[]{"/images/**"}).addResourceLocations(new String[]{"classpath:/static/images/"});
        registry.addResourceHandler(new String[]{"/css/**"}).addResourceLocations(new String[]{"classpath:/static/css/"});
        registry.addResourceHandler(new String[]{"/js/**"}).addResourceLocations(new String[]{"classpath:/static/js/"});
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("products").setViewName("products");
        registry.addViewController("categories").setViewName("categories");
        registry.addViewController("events").setViewName("events");
        registry.addViewController("attributes").setViewName("attributes");
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)this.jsonMessageConverter());
    }

    @Bean
    public DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator proxyCreator = new DefaultAdvisorAutoProxyCreator();
        proxyCreator.setProxyTargetClass(true);
        return proxyCreator;
    }

    @Bean
    public MessageSource messageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename("messages");
        return messageSource;
    }

    @Bean
    public LocalAuthorizationInterceptor localAuthorizationInterceptor() {
        return new LocalAuthorizationInterceptor(this.configurationService.getCatalogServiceAuthToken());
    }

    public ObjectMapper objectMapper() {
        LOGGER.debug("Creating custom ObjectMapper");
        ObjectMapper mapper = JsonObjectMapperFactory.createMapper();
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.addFilter("catalogEvent", (SimpleBeanPropertyFilter)new CatalogEventFilter());
        mapper.setFilterProvider((FilterProvider)filterProvider);
        return mapper;
    }

    public MappingJackson2HttpMessageConverter jsonMessageConverter() {
        return new MappingJackson2HttpMessageConverter(this.objectMapper());
    }

    @Bean
    public CatalogDao catalogDao() {
        GitCatalogDao dataSource = new GitCatalogDao();
        if (StringUtils.isNotBlank((CharSequence)this.gitUserName) && StringUtils.isNotBlank((CharSequence)this.gitPassword)) {
            dataSource.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.gitUserName, this.gitPassword));
        }
        if (StringUtils.isNotBlank((CharSequence)this.remoteRepoUrl)) {
            try {
                URI uri = new URI(this.remoteRepoUrl);
                if (uri.getScheme().equalsIgnoreCase("SSH")) {
                    1 transportConfigCallback = new /* Unavailable Anonymous Inner Class!! */;
                    dataSource.setTransportConfigCallback((TransportConfigCallback)transportConfigCallback);
                }
            }
            catch (URISyntaxException ex) {
                LOGGER.error("Invalid URI {}:", (Object)this.remoteRepoUrl, (Object)ex);
            }
        } else {
            LOGGER.error("No remote repo URL provided.");
        }
        if (StringUtils.isNotBlank((CharSequence)this.branch)) {
            dataSource.setBranch(this.branch);
        }
        if (StringUtils.isNotBlank((CharSequence)this.localRepoUrl)) {
            dataSource.setLocalRepoPath(this.localRepoUrl);
        } else {
            String localRepoPath = System.getProperty("java.io.tmpdir") + "/audit/catalog";
            File file = new File(localRepoPath);
            File parent = file.getParentFile();
            parent.mkdirs();
            dataSource.setLocalRepoPath(localRepoPath);
        }
        dataSource.setRemoteRepoUri(this.remoteRepoUrl);
        if (StringUtils.isNotBlank((CharSequence)this.remoteRepoCatalogPath)) {
            dataSource.setCatalogPath(this.remoteRepoCatalogPath);
        }
        return dataSource;
    }

    static /* synthetic */ String access$000(WebMvcAppContext x0) {
        return x0.privateKeyPath;
    }

    static /* synthetic */ String access$100(WebMvcAppContext x0) {
        return x0.gitPassPhrase;
    }
}

