/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.logging.log4j.kit.env.Log4jProperty;
import org.apache.logging.log4j.status.StatusLogger;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@Log4jProperty(name="layout.jsonTemplate")
@NullMarked
public record JsonTemplateLayoutProperties(@Log4jProperty(defaultValue="UTF-8") Charset charset, @Log4jProperty(defaultValue="false") boolean locationInfoEnabled, @Log4jProperty(defaultValue="true") boolean stackTraceEnabled, @Log4jProperty(defaultValue="yyyy-MM-dd'T'HH:mm:ss.SSSZZZ") String timestampFormatPattern, @Log4jProperty(defaultValue="system") TimeZone timeZone, @Log4jProperty(defaultValue="system") Locale locale, @Nullable String eventTemplate, @Log4jProperty(defaultValue="classpath:EcsLayout.json") String eventTemplateUri, @Nullable String stackTraceElementTemplate, @Log4jProperty(defaultValue="classpath:StackTraceElementLayout.json") String stackTraceElementTemplateUri, @Nullable String eventTemplateRootObjectKey, @Nullable String eventDelimiter, boolean nullEventDelimiterEnabled, @Log4jProperty(defaultValue="16384") int maxStringLength, @Log4jProperty(defaultValue="\u2026") String truncatedStringSuffix) {
    private static final int DEFAULT_MAX_STRING_LENGTH = 16384;

    public JsonTemplateLayoutProperties(@Log4jProperty(defaultValue="UTF-8") Charset charset, @Log4jProperty(defaultValue="false") boolean locationInfoEnabled, @Log4jProperty(defaultValue="true") boolean stackTraceEnabled, @Log4jProperty(defaultValue="yyyy-MM-dd'T'HH:mm:ss.SSSZZZ") String timestampFormatPattern, @Log4jProperty(defaultValue="system") TimeZone timeZone, @Log4jProperty(defaultValue="system") Locale locale, @Nullable String eventTemplate, @Log4jProperty(defaultValue="classpath:EcsLayout.json") String eventTemplateUri, @Nullable String stackTraceElementTemplate, @Log4jProperty(defaultValue="classpath:StackTraceElementLayout.json") String stackTraceElementTemplateUri, @Nullable String eventTemplateRootObjectKey, @Nullable String eventDelimiter, boolean nullEventDelimiterEnabled, @Log4jProperty(defaultValue="16384") int maxStringLength, @Log4jProperty(defaultValue="\u2026") String truncatedStringSuffix) {
        eventDelimiter = eventDelimiter != null ? eventDelimiter : System.lineSeparator();
        maxStringLength = this.validateMaxStringLength(maxStringLength);
        this.charset = charset;
        this.locationInfoEnabled = locationInfoEnabled;
        this.stackTraceEnabled = stackTraceEnabled;
        this.timestampFormatPattern = timestampFormatPattern;
        this.timeZone = timeZone;
        this.locale = locale;
        this.eventTemplate = eventTemplate;
        this.eventTemplateUri = eventTemplateUri;
        this.stackTraceElementTemplate = stackTraceElementTemplate;
        this.stackTraceElementTemplateUri = stackTraceElementTemplateUri;
        this.eventTemplateRootObjectKey = eventTemplateRootObjectKey;
        this.eventDelimiter = eventDelimiter;
        this.nullEventDelimiterEnabled = nullEventDelimiterEnabled;
        this.maxStringLength = maxStringLength;
        this.truncatedStringSuffix = truncatedStringSuffix;
    }

    private int validateMaxStringLength(int maxStringLength) {
        if (maxStringLength <= 0) {
            StatusLogger.getLogger().warn("Invalid `maxStringLength` value {}, using default value {}.", (Object)maxStringLength, (Object)16384);
            return 16384;
        }
        return maxStringLength;
    }
}

