/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.kit.recycler.Recycler;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

public class CounterResolver
implements EventResolver {
    private final Consumer<JsonWriter> delegate;

    public CounterResolver(EventResolverContext context, TemplateResolverConfig config) {
        this.delegate = CounterResolver.createDelegate(context, config);
    }

    private static Consumer<JsonWriter> createDelegate(EventResolverContext context, TemplateResolverConfig config) {
        BigInteger start = CounterResolver.readStart(config);
        boolean overflowing = config.getBoolean("overflowing", true);
        boolean stringified = config.getBoolean("stringified", false);
        if (stringified) {
            Recycler<StringBuilder> stringBuilderRecycler = CounterResolver.createStringBuilderRecycler(context);
            return overflowing ? CounterResolver.createStringifiedLongResolver(start, stringBuilderRecycler) : CounterResolver.createStringifiedBigIntegerResolver(start, stringBuilderRecycler);
        }
        return overflowing ? CounterResolver.createLongResolver(start) : CounterResolver.createBigIntegerResolver(start);
    }

    private static BigInteger readStart(TemplateResolverConfig config) {
        Object start = config.getObject("start", Object.class);
        if (start == null) {
            return BigInteger.ZERO;
        }
        if (start instanceof Short || start instanceof Integer || start instanceof Long) {
            return BigInteger.valueOf(((Number)start).longValue());
        }
        if (start instanceof BigInteger) {
            return (BigInteger)start;
        }
        Class<?> clazz = start.getClass();
        String message = String.format("could not read start of type %s: %s", clazz, config);
        throw new IllegalArgumentException(message);
    }

    private static Consumer<JsonWriter> createLongResolver(BigInteger start) {
        long effectiveStart = start.longValue();
        AtomicLong counter = new AtomicLong(effectiveStart);
        return jsonWriter -> {
            long number = counter.getAndIncrement();
            jsonWriter.writeNumber(number);
        };
    }

    private static Consumer<JsonWriter> createBigIntegerResolver(BigInteger start) {
        AtomicBigInteger counter = new AtomicBigInteger(start);
        return jsonWriter -> {
            BigInteger number = counter.getAndIncrement();
            jsonWriter.writeNumber(number);
        };
    }

    private static Recycler<StringBuilder> createStringBuilderRecycler(EventResolverContext context) {
        return context.getConfiguration().getRecyclerFactory().create(StringBuilder::new, stringBuilder -> {
            int maxLength = context.getJsonWriter().getMaxStringLength();
            CounterResolver.trimStringBuilder(stringBuilder, maxLength);
        });
    }

    private static void trimStringBuilder(StringBuilder stringBuilder, int maxLength) {
        if (stringBuilder.length() > maxLength) {
            stringBuilder.setLength(maxLength);
            stringBuilder.trimToSize();
        }
        stringBuilder.setLength(0);
    }

    private static Consumer<JsonWriter> createStringifiedLongResolver(BigInteger start, Recycler<StringBuilder> stringBuilderRecycler) {
        long effectiveStart = start.longValue();
        AtomicLong counter = new AtomicLong(effectiveStart);
        return jsonWriter -> {
            long number = counter.getAndIncrement();
            StringBuilder stringBuilder = (StringBuilder)stringBuilderRecycler.acquire();
            try {
                stringBuilder.append(number);
                jsonWriter.writeString(stringBuilder);
            }
            finally {
                stringBuilderRecycler.release((Object)stringBuilder);
            }
        };
    }

    private static Consumer<JsonWriter> createStringifiedBigIntegerResolver(BigInteger start, Recycler<StringBuilder> stringBuilderRecycler) {
        AtomicBigInteger counter = new AtomicBigInteger(start);
        return jsonWriter -> {
            BigInteger number = counter.getAndIncrement();
            StringBuilder stringBuilder = (StringBuilder)stringBuilderRecycler.acquire();
            try {
                stringBuilder.append(number);
                jsonWriter.writeString(stringBuilder);
            }
            finally {
                stringBuilderRecycler.release((Object)stringBuilder);
            }
        };
    }

    static String getName() {
        return "counter";
    }

    @Override
    public void resolve(LogEvent ignored, JsonWriter jsonWriter) {
        this.delegate.accept(jsonWriter);
    }

    private static final class AtomicBigInteger {
        private final AtomicReference<BigInteger> lastNumber;

        private AtomicBigInteger(BigInteger start) {
            this.lastNumber = new AtomicReference<BigInteger>(start);
        }

        private BigInteger getAndIncrement() {
            BigInteger nextNumber;
            BigInteger prevNumber;
            while (!this.compareAndSetWithBackOff(prevNumber = this.lastNumber.get(), nextNumber = prevNumber.add(BigInteger.ONE))) {
            }
            return prevNumber;
        }

        private boolean compareAndSetWithBackOff(BigInteger prevNumber, BigInteger nextNumber) {
            if (this.lastNumber.compareAndSet(prevNumber, nextNumber)) {
                return true;
            }
            LockSupport.parkNanos(1L);
            return false;
        }
    }
}

