/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.util;

import java.util.Map;

public class StringUtils {
    public static final char[] NEWLINE = new char[]{'\r', '\n'};

    @Deprecated
    public StringUtils() {
    }

    public static final String replaceString(String source, String oldStr, String newStr) {
        StringBuilder sb = new StringBuilder(source.length());
        int sind = 0;
        int cind = 0;
        while ((cind = source.indexOf(oldStr, sind)) != -1) {
            sb.append(source.substring(sind, cind));
            sb.append(newStr);
            sind = cind + oldStr.length();
        }
        sb.append(source.substring(sind));
        return sb.toString();
    }

    public static final String replaceString(String source, Object[] args) {
        int startIndex = 0;
        int openIndex = source.indexOf(123, startIndex);
        if (openIndex == -1) {
            return source;
        }
        int closeIndex = source.indexOf(125, startIndex);
        if (closeIndex == -1 || openIndex > closeIndex) {
            return source;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(source.substring(startIndex, openIndex));
        while (true) {
            String intStr = source.substring(openIndex + 1, closeIndex);
            int index = Integer.parseInt(intStr);
            sb.append(args[index]);
            startIndex = closeIndex + 1;
            openIndex = source.indexOf(123, startIndex);
            if (openIndex == -1) {
                sb.append(source.substring(startIndex));
                break;
            }
            closeIndex = source.indexOf(125, startIndex);
            if (closeIndex == -1 || openIndex > closeIndex) {
                sb.append(source.substring(startIndex));
                break;
            }
            sb.append(source.substring(startIndex, openIndex));
        }
        return sb.toString();
    }

    public static final String replaceString(String source, Map<String, Object> args) {
        int startIndex = 0;
        int openIndex = source.indexOf(123, startIndex);
        if (openIndex == -1) {
            return source;
        }
        int closeIndex = source.indexOf(125, startIndex);
        if (closeIndex == -1 || openIndex > closeIndex) {
            return source;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(source.substring(startIndex, openIndex));
        while (true) {
            String key;
            Object val;
            if ((val = args.get(key = source.substring(openIndex + 1, closeIndex))) != null) {
                sb.append(val);
            }
            if ((openIndex = source.indexOf(123, startIndex = closeIndex + 1)) == -1) {
                sb.append(source.substring(startIndex));
                break;
            }
            closeIndex = source.indexOf(125, startIndex);
            if (closeIndex == -1 || openIndex > closeIndex) {
                sb.append(source.substring(startIndex));
                break;
            }
            sb.append(source.substring(startIndex, openIndex));
        }
        return sb.toString();
    }

    public static final String formatHtml(String source, boolean bReplaceNl, boolean bReplaceTag, boolean bReplaceQuote) {
        StringBuilder sb = new StringBuilder();
        int len = source.length();
        block8: for (int i = 0; i < len; ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '\"': {
                    if (bReplaceQuote) {
                        sb.append("&quot;");
                        continue block8;
                    }
                    sb.append(c);
                    continue block8;
                }
                case '<': {
                    if (bReplaceTag) {
                        sb.append("&lt;");
                        continue block8;
                    }
                    sb.append(c);
                    continue block8;
                }
                case '>': {
                    if (bReplaceTag) {
                        sb.append("&gt;");
                        continue block8;
                    }
                    sb.append(c);
                    continue block8;
                }
                case '\n': {
                    if (bReplaceNl) {
                        if (bReplaceTag) {
                            sb.append("&lt;br&gt;");
                            continue block8;
                        }
                        sb.append("<br>");
                        continue block8;
                    }
                    sb.append(c);
                    continue block8;
                }
                case '\r': {
                    continue block8;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static final String pad(String src, char padChar, boolean rightPad, int totalLength) {
        int srcLength = src.length();
        if (srcLength >= totalLength) {
            return src;
        }
        int padLength = totalLength - srcLength;
        StringBuilder sb = new StringBuilder(padLength);
        for (int i = 0; i < padLength; ++i) {
            sb.append(padChar);
        }
        if (rightPad) {
            return src + sb.toString();
        }
        return sb.toString() + src;
    }

    public static final String toHexString(byte[] res) {
        StringBuilder sb = new StringBuilder(res.length << 1);
        for (int i = 0; i < res.length; ++i) {
            String digit = Integer.toHexString(0xFF & res[i]);
            if (digit.length() == 1) {
                sb.append('0');
            }
            sb.append(digit);
        }
        return sb.toString().toUpperCase();
    }

    public static final byte[] toByteArray(String hexString) {
        int arrLength = hexString.length() >> 1;
        byte[] buff = new byte[arrLength];
        for (int i = 0; i < arrLength; ++i) {
            int index = i << 1;
            String digit = hexString.substring(index, index + 2);
            buff[i] = (byte)Integer.parseInt(digit, 16);
        }
        return buff;
    }
}

