/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ApplicationConfigurationPopulator;
import javax.faces.context.ExternalContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.myfaces.config.ConfigFilesXmlValidationUtils;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.annotation.AnnotationConfigurator;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.myfaces.config.element.FacesFlowDefinition;
import org.apache.myfaces.config.element.facelets.FaceletTagLibrary;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigUnmarshallerImpl;
import org.apache.myfaces.config.impl.digester.elements.FacesConfigImpl;
import org.apache.myfaces.config.impl.digester.elements.FacesFlowDefinitionImpl;
import org.apache.myfaces.config.impl.digester.elements.FacesFlowReturnImpl;
import org.apache.myfaces.config.impl.digester.elements.FactoryImpl;
import org.apache.myfaces.config.impl.digester.elements.NavigationCaseImpl;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.FastWriter;
import org.apache.myfaces.shared.util.WebConfigParamUtils;
import org.apache.myfaces.spi.FaceletConfigResourceProvider;
import org.apache.myfaces.spi.FaceletConfigResourceProviderFactory;
import org.apache.myfaces.spi.FacesConfigResourceProvider;
import org.apache.myfaces.spi.FacesConfigResourceProviderFactory;
import org.apache.myfaces.spi.FacesConfigurationProvider;
import org.apache.myfaces.spi.ServiceProviderFinder;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.view.facelets.compiler.TagLibraryConfigUnmarshallerImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DefaultFacesConfigurationProvider
extends FacesConfigurationProvider {
    private static final String STANDARD_FACES_CONFIG_RESOURCE = "META-INF/standard-faces-config.xml";
    private static final String DEFAULT_FACES_CONFIG = "/WEB-INF/faces-config.xml";
    private static final Set<String> FACTORY_NAMES = new HashSet<String>();
    private static final String PARAM_LIBRARIES_DEPRECATED = "facelets.LIBRARIES";
    private static final String[] PARAMS_LIBRARIES;
    private static final Logger log;
    private FacesConfigUnmarshaller<? extends FacesConfig> _unmarshaller;
    private AnnotationConfigurator _annotationConfigurator;

    protected void setUnmarshaller(ExternalContext ectx, FacesConfigUnmarshaller<? extends FacesConfig> unmarshaller) {
        this._unmarshaller = unmarshaller;
    }

    protected FacesConfigUnmarshaller<? extends FacesConfig> getUnmarshaller(ExternalContext ectx) {
        if (this._unmarshaller == null) {
            this._unmarshaller = new DigesterFacesConfigUnmarshallerImpl(ectx);
        }
        return this._unmarshaller;
    }

    protected void setAnnotationConfigurator(AnnotationConfigurator configurator) {
        this._annotationConfigurator = configurator;
    }

    protected AnnotationConfigurator getAnnotationConfigurator() {
        if (this._annotationConfigurator == null) {
            this._annotationConfigurator = new AnnotationConfigurator();
        }
        return this._annotationConfigurator;
    }

    @Override
    public FacesConfig getStandardFacesConfig(ExternalContext ectx) {
        try {
            InputStream stream;
            URL url;
            if (MyfacesConfig.getCurrentInstance(ectx).isValidateXML() && (url = ClassUtils.getResource(STANDARD_FACES_CONFIG_RESOURCE)) != null) {
                this.validateFacesConfig(ectx, url);
            }
            if ((stream = ClassUtils.getResourceAsStream(STANDARD_FACES_CONFIG_RESOURCE)) == null) {
                throw new FacesException("Standard faces config META-INF/standard-faces-config.xml not found");
            }
            if (log.isLoggable(Level.INFO)) {
                log.info("Reading standard config META-INF/standard-faces-config.xml");
            }
            FacesConfig facesConfig = this.getUnmarshaller(ectx).getFacesConfig(stream, STANDARD_FACES_CONFIG_RESOURCE);
            stream.close();
            return facesConfig;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        catch (SAXException e) {
            throw new FacesException((Throwable)e);
        }
    }

    @Override
    public FacesConfig getAnnotationsFacesConfig(ExternalContext ectx, boolean metadataComplete) {
        return this.getAnnotationConfigurator().createFacesConfig(ectx, metadataComplete);
    }

    @Override
    public FacesConfig getMetaInfServicesFacesConfig(ExternalContext ectx) {
        try {
            FacesConfigImpl facesConfig = new FacesConfigImpl();
            FactoryImpl factory = new FactoryImpl();
            facesConfig.addFactory(factory);
            for (String factoryName : FACTORY_NAMES) {
                List<String> classList = ServiceProviderFinderFactory.getServiceProviderFinder(ectx).getServiceProviderList(factoryName);
                for (String className : classList) {
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Found " + factoryName + " factory implementation: " + className);
                    }
                    if (factoryName.equals("javax.faces.application.ApplicationFactory")) {
                        factory.addApplicationFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.ExceptionHandlerFactory")) {
                        factory.addExceptionHandlerFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.ExternalContextFactory")) {
                        factory.addExternalContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.FacesContextFactory")) {
                        factory.addFacesContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.lifecycle.LifecycleFactory")) {
                        factory.addLifecycleFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.render.RenderKitFactory")) {
                        factory.addRenderkitFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.view.facelets.TagHandlerDelegateFactory")) {
                        factory.addTagHandlerDelegateFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.PartialViewContextFactory")) {
                        factory.addPartialViewContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.component.visit.VisitContextFactory")) {
                        factory.addVisitContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.view.ViewDeclarationLanguageFactory")) {
                        factory.addViewDeclarationLanguageFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.FlashFactory")) {
                        factory.addFlashFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.flow.FlowHandlerFactory")) {
                        factory.addFlowHandlerFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.lifecycle.ClientWindowFactory")) {
                        factory.addClientWindowFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.view.facelets.FaceletCacheFactory")) {
                        factory.addFaceletCacheFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.component.search.SearchExpressionContextFactory")) {
                        factory.addSearchExpressionContextFactory(className);
                        continue;
                    }
                    throw new IllegalStateException("Unexpected factory name " + factoryName);
                }
            }
            return facesConfig;
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FacesConfig> getClassloaderFacesConfig(ExternalContext ectx) {
        ArrayList<FacesConfig> appConfigResources = new ArrayList<FacesConfig>();
        try {
            FacesConfigResourceProvider provider = FacesConfigResourceProviderFactory.getFacesConfigResourceProviderFactory(ectx).createFacesConfigResourceProvider(ectx);
            Collection<URL> facesConfigs = provider.getMetaInfConfigurationResources(ectx);
            for (URL url : facesConfigs) {
                if (MyfacesConfig.getCurrentInstance(ectx).isValidateXML()) {
                    this.validateFacesConfig(ectx, url);
                }
                InputStream stream = null;
                try {
                    stream = this.openStreamWithoutCache(url);
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Reading config : " + url.toExternalForm());
                    }
                    appConfigResources.add(this.getUnmarshaller(ectx).getFacesConfig(stream, url.toExternalForm()));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
        return appConfigResources;
    }

    @Override
    public List<FacesConfig> getContextSpecifiedFacesConfig(ExternalContext ectx) {
        ArrayList<FacesConfig> appConfigResources = new ArrayList<FacesConfig>();
        try {
            for (String systemId : this.getConfigFilesList(ectx)) {
                InputStream stream;
                URL url;
                if (MyfacesConfig.getCurrentInstance(ectx).isValidateXML() && (url = ectx.getResource(systemId)) != null) {
                    this.validateFacesConfig(ectx, url);
                }
                if ((stream = ectx.getResourceAsStream(systemId)) == null) {
                    log.severe("Faces config resource " + systemId + " not found");
                    continue;
                }
                if (log.isLoggable(Level.INFO)) {
                    log.info("Reading config " + systemId);
                }
                appConfigResources.add(this.getUnmarshaller(ectx).getFacesConfig(stream, systemId));
                stream.close();
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
        return appConfigResources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FacesConfig getWebAppFacesConfig(ExternalContext ectx) {
        try {
            InputStream stream2;
            URL url;
            try (InputStream stream = ectx.getResourceAsStream(DEFAULT_FACES_CONFIG);){
                if (stream != null) {
                    int length;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((length = stream.read(buffer)) != -1) {
                        out.write(buffer, 0, length);
                    }
                    out.flush();
                    String content = new String(out.toByteArray());
                    if (content.trim().isEmpty()) {
                        FacesConfigImpl facesConfigImpl = new FacesConfigImpl();
                        return facesConfigImpl;
                    }
                }
            }
            FacesConfig webAppConfig = null;
            if (MyfacesConfig.getCurrentInstance(ectx).isValidateXML() && (url = ectx.getResource(DEFAULT_FACES_CONFIG)) != null) {
                this.validateFacesConfig(ectx, url);
            }
            if ((stream2 = ectx.getResourceAsStream(DEFAULT_FACES_CONFIG)) == null) return webAppConfig;
            if (log.isLoggable(Level.INFO)) {
                log.info("Reading config /WEB-INF/faces-config.xml");
            }
            webAppConfig = this.getUnmarshaller(ectx).getFacesConfig(stream2, DEFAULT_FACES_CONFIG);
            stream2.close();
            return webAppConfig;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        catch (SAXException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private InputStream openStreamWithoutCache(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }

    private List<String> getConfigFilesList(ExternalContext ectx) {
        String configFiles = ectx.getInitParameter("javax.faces.CONFIG_FILES");
        ArrayList<String> configFilesList = new ArrayList<String>();
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                if (DEFAULT_FACES_CONFIG.equals(systemId)) {
                    if (!log.isLoggable(Level.WARNING)) continue;
                    log.warning("/WEB-INF/faces-config.xml has been specified in the javax.faces.CONFIG_FILES context parameter of the deployment descriptor. This will automatically be removed, if we wouldn't do this, it would be loaded twice.  See JSF spec 1.1, 10.3.2");
                    continue;
                }
                configFilesList.add(systemId);
            }
        }
        return configFilesList;
    }

    private void validateFacesConfig(ExternalContext ectx, URL url) throws IOException, SAXException {
        String version = ConfigFilesXmlValidationUtils.getFacesConfigVersion(url);
        if ("1.2".equals(version) || "2.0".equals(version) || "2.1".equals(version) || "2.2".equals(version) || "2.3".equals(version)) {
            ConfigFilesXmlValidationUtils.validateFacesConfigFile(url, ectx, version);
        }
    }

    @Override
    public List<FacesConfig> getApplicationConfigurationResourceDocumentPopulatorFacesConfig(ExternalContext ectx) {
        ServiceProviderFinder spff = ServiceProviderFinderFactory.getServiceProviderFinder(ectx);
        ServiceLoader<ApplicationConfigurationPopulator> instances = spff.load(ApplicationConfigurationPopulator.class);
        if (instances != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = null;
            DOMImplementation domImpl = null;
            try {
                builder = factory.newDocumentBuilder();
                domImpl = builder.getDOMImplementation();
            }
            catch (ParserConfigurationException ex) {
                log.log(Level.SEVERE, "Cannot create dom document builder, skipping it", ex);
            }
            if (builder != null) {
                ArrayList<FacesConfig> facesConfigList = new ArrayList<FacesConfig>();
                ArrayList<Document> documentList = new ArrayList<Document>();
                for (ApplicationConfigurationPopulator populator : instances) {
                    Document document = domImpl.createDocument("http://java.sun.com/xml/ns/javaee", "faces-config", null);
                    populator.populateApplicationConfiguration(document);
                    documentList.add(document);
                }
                Transformer trans = null;
                try {
                    trans = TransformerFactory.newInstance().newTransformer();
                    trans.setOutputProperty("indent", "no");
                    trans.setOutputProperty("method", "xml");
                    trans.setOutputProperty("version", "1.0");
                    trans.setOutputProperty("encoding", "UTF-8");
                }
                catch (TransformerConfigurationException ex) {
                    Logger.getLogger(DefaultFacesConfigurationProvider.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (trans != null) {
                    FastWriter xmlAsWriter = new FastWriter();
                    for (int i = 0; i < documentList.size(); ++i) {
                        Document document = (Document)documentList.get(i);
                        xmlAsWriter.reset();
                        try {
                            DOMSource source = new DOMSource(document);
                            StreamResult result = new StreamResult(xmlAsWriter);
                            trans.transform(source, result);
                            StringReader xmlReader = new StringReader(xmlAsWriter.toString());
                            FacesConfig facesConfig = this.getUnmarshaller(ectx).getFacesConfig(xmlReader);
                            facesConfigList.add(facesConfig);
                            continue;
                        }
                        catch (IOException ex) {
                            log.log(Level.SEVERE, "Error while reading faces-config from populator", ex);
                            continue;
                        }
                        catch (SAXException ex) {
                            log.log(Level.SEVERE, "Error while reading faces-config from populator", ex);
                            continue;
                        }
                        catch (TransformerConfigurationException ex) {
                            log.log(Level.SEVERE, "Error while reading faces-config from populator", ex);
                            continue;
                        }
                        catch (TransformerException ex) {
                            log.log(Level.SEVERE, "Error while reading faces-config from populator", ex);
                        }
                    }
                    return facesConfigList;
                }
                log.log(Level.SEVERE, "Cannot create xml transformer, skipping it");
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<FacesConfig> getFacesFlowFacesConfig(ExternalContext ectx) {
        Set directoryPaths = ectx.getResourcePaths("/");
        if (directoryPaths == null) {
            return Collections.emptyList();
        }
        ArrayList<FacesConfig> configFilesList = new ArrayList<FacesConfig>();
        List<String> contextSpecifiedList = this.getConfigFilesList(ectx);
        for (String dirPath : directoryPaths) {
            if (dirPath.equals("/WEB-INF/")) {
                Set webDirectoryPaths = ectx.getResourcePaths(dirPath);
                for (String webDirPath : webDirectoryPaths) {
                    if (!webDirPath.endsWith("/") || webDirPath.equals("/WEB-INF/classes/")) continue;
                    String flowName = webDirPath.substring(9, webDirPath.length() - 1);
                    String filePath = webDirPath + flowName + "-flow.xml";
                    if (contextSpecifiedList.contains(filePath)) continue;
                    try {
                        FacesConfig fc;
                        URL url = ectx.getResource(filePath);
                        if (url == null || (fc = this.parseFacesConfig(ectx, filePath, url)) == null) continue;
                        configFilesList.add(fc);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                continue;
            }
            if (dirPath.startsWith("/META-INF") || !dirPath.endsWith("/")) continue;
            String flowName = dirPath.substring(1, dirPath.length() - 1);
            String filePath = dirPath + flowName + "-flow.xml";
            if (contextSpecifiedList.contains(filePath)) continue;
            try {
                FacesConfig fc;
                URL url = ectx.getResource(filePath);
                if (url == null || (fc = this.parseFacesConfig(ectx, filePath, url)) == null) continue;
                configFilesList.add(fc);
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return configFilesList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FacesConfig parseFacesConfig(ExternalContext ectx, String systemId, URL url) {
        try {
            if (MyfacesConfig.getCurrentInstance(ectx).isValidateXML()) {
                this.validateFacesConfig(ectx, url);
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        catch (SAXException e) {
            throw new FacesException((Throwable)e);
        }
        InputStream stream = ectx.getResourceAsStream(systemId);
        PushbackInputStream pbstream = new PushbackInputStream(stream, 10);
        try {
            if (stream == null) {
                log.severe("Faces config resource " + systemId + " not found");
                FacesConfig facesConfig = null;
                return facesConfig;
            }
            String flowName = systemId.substring(systemId.lastIndexOf(47) + 1, systemId.lastIndexOf("-flow.xml"));
            int c = pbstream.read();
            if (c == -1) {
                FacesConfigImpl facesConfig = new FacesConfigImpl();
                FacesFlowDefinitionImpl flow = new FacesFlowDefinitionImpl();
                flow.setId(flowName);
                flow.setDefiningDocumentId(systemId);
                String startNodePath = systemId.substring(0, systemId.lastIndexOf(47) + 1) + flowName + ".xhtml";
                flow.setStartNode(startNodePath);
                FacesFlowReturnImpl returnNode = new FacesFlowReturnImpl();
                returnNode.setId(flowName + "-return");
                NavigationCaseImpl returnNavCase = new NavigationCaseImpl();
                returnNavCase.setFromOutcome("/" + flowName + "-return");
                returnNode.setNavigationCase(returnNavCase);
                flow.addReturn(returnNode);
                facesConfig.addFacesFlowDefinition(flow);
                FacesConfigImpl facesConfigImpl = facesConfig;
                return facesConfigImpl;
            }
            pbstream.unread(c);
            if (log.isLoggable(Level.INFO)) {
                log.info("Reading config " + systemId);
            }
            FacesConfigImpl facesConfig = (FacesConfigImpl)this.getUnmarshaller(ectx).getFacesConfig(pbstream, systemId);
            for (FacesFlowDefinition definition : facesConfig.getFacesFlowDefinitions()) {
                FacesFlowDefinitionImpl flow;
                if (!flowName.equals(definition.getId()) || (flow = (FacesFlowDefinitionImpl)definition).getStartNode() != null) continue;
                String startNodePath = systemId.substring(0, systemId.lastIndexOf(47) + 1) + flowName + ".xhtml";
                flow.setStartNode(startNodePath);
            }
            FacesConfigImpl facesConfigImpl = facesConfig;
            return facesConfigImpl;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        catch (SAXException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public List<FacesConfig> getFaceletTaglibFacesConfig(ExternalContext externalContext) {
        ArrayList<FacesConfig> facesConfigFilesList = new ArrayList<FacesConfig>();
        String param = WebConfigParamUtils.getStringInitParameter(externalContext, PARAMS_LIBRARIES);
        if (param != null) {
            for (String library : param.split(";")) {
                try {
                    URL src = externalContext.getResource(library.trim());
                    if (src == null) {
                        throw new FileNotFoundException(library);
                    }
                    FaceletTagLibrary tl = TagLibraryConfigUnmarshallerImpl.create(externalContext, src);
                    if (tl != null) {
                        FacesConfigImpl config = new FacesConfigImpl();
                        config.addFaceletTagLibrary(tl);
                        facesConfigFilesList.add(config);
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Successfully loaded library: " + library);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Error Loading library: " + library, e);
                }
            }
        }
        try {
            FaceletConfigResourceProvider provider = FaceletConfigResourceProviderFactory.getFacesConfigResourceProviderFactory(externalContext).createFaceletConfigResourceProvider(externalContext);
            Collection<URL> urls = provider.getFaceletTagLibConfigurationResources(externalContext);
            for (URL url : urls) {
                try {
                    FaceletTagLibrary tl = TagLibraryConfigUnmarshallerImpl.create(externalContext, url);
                    if (tl != null) {
                        FacesConfigImpl config = new FacesConfigImpl();
                        config.addFaceletTagLibrary(tl);
                        facesConfigFilesList.add(config);
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Added Library from: " + url);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error Loading Library: " + url, e);
                }
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Compiler Initialization Error", e);
        }
        return facesConfigFilesList;
    }

    static {
        FACTORY_NAMES.add("javax.faces.application.ApplicationFactory");
        FACTORY_NAMES.add("javax.faces.lifecycle.ClientWindowFactory");
        FACTORY_NAMES.add("javax.faces.context.ExceptionHandlerFactory");
        FACTORY_NAMES.add("javax.faces.context.ExternalContextFactory");
        FACTORY_NAMES.add("javax.faces.view.facelets.FaceletCacheFactory");
        FACTORY_NAMES.add("javax.faces.context.FacesContextFactory");
        FACTORY_NAMES.add("javax.faces.context.FlashFactory");
        FACTORY_NAMES.add("javax.faces.flow.FlowHandlerFactory");
        FACTORY_NAMES.add("javax.faces.lifecycle.LifecycleFactory");
        FACTORY_NAMES.add("javax.faces.render.RenderKitFactory");
        FACTORY_NAMES.add("javax.faces.view.facelets.TagHandlerDelegateFactory");
        FACTORY_NAMES.add("javax.faces.context.PartialViewContextFactory");
        FACTORY_NAMES.add("javax.faces.component.visit.VisitContextFactory");
        FACTORY_NAMES.add("javax.faces.view.ViewDeclarationLanguageFactory");
        FACTORY_NAMES.add("javax.faces.component.search.SearchExpressionContextFactory");
        PARAMS_LIBRARIES = new String[]{"javax.faces.FACELETS_LIBRARIES", PARAM_LIBRARIES_DEPRECATED};
        log = Logger.getLogger(DefaultFacesConfigurationProvider.class.getName());
    }
}

