/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.util.List;
import java.util.Map;
import org.apache.nifi.provenance.ProvenanceEventType;

public interface ProvenanceEventRecord {
    public static final String REMOTE_INPUT_PORT_TYPE = "Remote Input Port";
    public static final String REMOTE_OUTPUT_PORT_TYPE = "Remote Output Port";

    public long getEventId();

    public long getEventTime();

    public long getFlowFileEntryDate();

    public long getLineageStartDate();

    public long getFileSize();

    public Long getPreviousFileSize();

    public long getEventDuration();

    public ProvenanceEventType getEventType();

    public Map<String, String> getAttributes();

    default public String getAttribute(String attributeName) {
        return this.getAttributes().get(attributeName);
    }

    public Map<String, String> getPreviousAttributes();

    public Map<String, String> getUpdatedAttributes();

    public String getComponentId();

    public String getComponentType();

    default public boolean isRemotePortType() {
        String componentType = this.getComponentType();
        return REMOTE_INPUT_PORT_TYPE.equals(componentType) || REMOTE_OUTPUT_PORT_TYPE.equals(componentType);
    }

    public String getTransitUri();

    public String getSourceSystemFlowFileIdentifier();

    public String getFlowFileUuid();

    public List<String> getParentUuids();

    public List<String> getChildUuids();

    public String getAlternateIdentifierUri();

    public String getDetails();

    public String getRelationship();

    public String getSourceQueueIdentifier();

    public String getContentClaimSection();

    public String getPreviousContentClaimSection();

    public String getContentClaimContainer();

    public String getPreviousContentClaimContainer();

    public String getContentClaimIdentifier();

    public String getPreviousContentClaimIdentifier();

    public Long getContentClaimOffset();

    public Long getPreviousContentClaimOffset();

    public String getBestEventIdentifier();
}

