/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.javapoet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.javapoet.CodeBlock;
import org.springframework.lang.CheckReturnValue;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class LordOfTheStrings {
    public static CodeBlockBuilder builder() {
        return new CodeBlockBuilder(CodeBlock.builder());
    }

    public static CodeBlockBuilder builder(CodeBlock.Builder builder) {
        return new CodeBlockBuilder(builder);
    }

    public static CodeBlockBuilder builder(String format, Object ... args) {
        return new CodeBlockBuilder(CodeBlock.builder().add(format, args));
    }

    public static InvocationBuilder invoke(String methodCall, Object ... arguments) {
        return new InvocationBuilder(methodCall, arguments);
    }

    public static TypedReturnBuilder returning(ResolvableType returnType) {
        return new TypedReturnBuilder(returnType);
    }

    public static TypedReturnBuilder returning(Class<?> returnType) {
        return new TypedReturnBuilder(ResolvableType.forType(returnType));
    }

    private LordOfTheStrings() {
    }

    public static class CodeBlockBuilder {
        private final CodeBlock.Builder builder;

        CodeBlockBuilder(CodeBlock.Builder builder) {
            this.builder = builder;
        }

        public boolean isEmpty() {
            return this.builder.isEmpty();
        }

        @Contract(value="_, _ -> this")
        public CodeBlockBuilder add(String format, Object ... args) {
            this.builder.add(format, args);
            return this;
        }

        @Contract(value="_ -> this")
        public CodeBlockBuilder addStatement(CodeBlock codeBlock) {
            this.builder.addStatement(codeBlock);
            return this;
        }

        @Contract(value="null -> fail; _ -> this")
        public CodeBlockBuilder addStatement(Consumer<StatementBuilder> consumer) {
            Assert.notNull(consumer, (String)"Consumer must not be null");
            StatementBuilder statementBuilder = new StatementBuilder();
            consumer.accept(statementBuilder);
            if (!statementBuilder.isEmpty()) {
                this.add("$[", new Object[0]);
                for (CodeBlock block : statementBuilder.blocks) {
                    this.builder.add(block);
                }
                this.add(";\n$]", new Object[0]);
            }
            return this;
        }

        @Contract(value="_ -> this")
        public CodeBlockBuilder add(CodeBlock codeBlock) {
            this.builder.add(codeBlock);
            return this;
        }

        @Contract(value="_, _ -> this")
        public CodeBlockBuilder addStatement(String format, Object ... args) {
            this.builder.addStatement(format, args);
            return this;
        }

        @Contract(value="_, _ -> this")
        public CodeBlockBuilder addNamed(String format, Map<String, ?> arguments) {
            this.builder.addNamed(format, arguments);
            return this;
        }

        @Contract(value="_, _ -> this")
        public CodeBlockBuilder beginControlFlow(String controlFlow, Object ... args) {
            this.builder.beginControlFlow(controlFlow, args);
            return this;
        }

        @Contract(value="_, _ -> this")
        public CodeBlockBuilder endControlFlow(String controlFlow, Object ... args) {
            this.builder.endControlFlow(controlFlow, args);
            return this;
        }

        @Contract(value="-> this")
        public CodeBlockBuilder endControlFlow() {
            this.builder.endControlFlow();
            return this;
        }

        @Contract(value="_, _ -> this")
        public CodeBlockBuilder nextControlFlow(String controlFlow, Object ... args) {
            this.builder.nextControlFlow(controlFlow, args);
            return this;
        }

        @Contract(value="-> this")
        public CodeBlockBuilder indent() {
            this.builder.indent();
            return this;
        }

        @Contract(value="-> this")
        public CodeBlockBuilder unindent() {
            this.builder.unindent();
            return this;
        }

        @CheckReturnValue
        public CodeBlock build() {
            return this.builder.build();
        }

        @Contract(value="-> this")
        public CodeBlockBuilder clear() {
            this.builder.clear();
            return this;
        }
    }

    public static class InvocationBuilder {
        private final String name;
        private final List<Object> nameArguments;
        private final List<CodeTuple> arguments = new ArrayList<CodeTuple>();
        private boolean hasArguments = false;

        InvocationBuilder(String name, Object ... arguments) {
            this.name = name;
            this.nameArguments = List.of(arguments);
        }

        @Contract(value="null ->fail; _ -> this")
        public InvocationBuilder argument(String argument) {
            Assert.hasText((String)argument, (String)"Argument must not be null or empty");
            return this.argument("$L", argument);
        }

        @Contract(value="_ -> this")
        public InvocationBuilder arguments(Iterable<?> arguments) {
            this.hasArguments = true;
            for (Object argument : arguments) {
                this.argument("$L", argument);
            }
            return this;
        }

        @Contract(value="_, _ -> this")
        public <T> InvocationBuilder arguments(Iterable<? extends T> arguments, Function<? super T, CodeBlock> consumer) {
            this.hasArguments = true;
            for (T argument : arguments) {
                this.argument(consumer.apply(argument));
            }
            return this;
        }

        @Contract(value="null -> fail; _ -> this")
        public InvocationBuilder argument(CodeBlock argument) {
            Assert.notNull((Object)argument, (String)"CodeBlock must not be null");
            this.hasArguments = true;
            if (argument.isEmpty()) {
                return this;
            }
            return this.argument("$L", argument);
        }

        @Contract(value="null, _ -> fail; _, _ -> this")
        public InvocationBuilder argument(String format, Object ... args) {
            Assert.hasText((String)format, (String)"Format must not be null or empty");
            this.hasArguments = true;
            this.arguments.add(new CodeTuple(format, args));
            return this;
        }

        @CheckReturnValue
        public CodeBlock build() {
            CodeBlock.Builder builder = CodeBlock.builder();
            this.buildCall(builder);
            return builder.build();
        }

        @CheckReturnValue
        public CodeBlock assignTo(String format, Object ... args) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add(format.trim() + " = ", args);
            this.buildCall(builder);
            return builder.build();
        }

        private void buildCall(CodeBlock.Builder builder) {
            boolean first = true;
            CodeBlock.Builder argsBuilder = CodeBlock.builder();
            for (CodeTuple argument : this.arguments) {
                if (first) {
                    first = false;
                } else {
                    argsBuilder.add(", ", new Object[0]);
                }
                argsBuilder.add(argument.format(), argument.args());
            }
            ArrayList<Object> allArguments = new ArrayList<Object>(this.nameArguments);
            if (this.hasArguments) {
                allArguments.add(argsBuilder.build());
            }
            builder.add(this.name, allArguments.toArray());
        }
    }

    public static class TypedReturnBuilder
    extends ReturnBuilderSupport {
        private final ResolvableType returnType;

        TypedReturnBuilder(ResolvableType returnType) {
            Assert.notNull((Object)returnType, (String)"Return type must not be null");
            this.returnType = returnType;
            this.whenBoxed(Void.class, "null", new Object[0]);
            this.when(ReflectionUtils.isVoid(returnType.toClass()), "", new Object[0]);
        }

        @Contract(value="_ -> this")
        public TypedReturnBuilder number(String resultToReturn) {
            return this.whenBoxedLong("$1L != null ? $1L.longValue() : null", resultToReturn).whenLong("$1L != null ? $1L.longValue() : 0L", resultToReturn).whenBoxedInteger("$1L != null ? $1L.intValue() : null", resultToReturn).whenInt("$1L != null ? $1L.intValue() : 0", resultToReturn).whenBoxed(Byte.class, "$1L != null ? $1L.byteValue() : null", resultToReturn).when(Byte.TYPE, "$1L != null ? $1L.byteValue() : 0", resultToReturn).whenBoxed(Short.class, "$1L != null ? $1L.shortValue() : null", resultToReturn).when(Short.TYPE, "$1L != null ? $1L.shortValue() : 0", resultToReturn).whenBoxed(Double.class, "$1L != null ? $1L.doubleValue() : null", resultToReturn).when(Double.TYPE, "$1L != null ? $1L.doubleValue() : 0", resultToReturn).whenBoxed(Float.class, "$1L != null ? $1L.floatValue() : null", resultToReturn).when(Float.TYPE, "$1L != null ? $1L.floatValue() : 0f", resultToReturn);
        }

        @Contract(value="_ -> this")
        public TypedReturnBuilder nonNullableNumber(String resultToReturn) {
            return this.whenPrimitiveOrBoxed(Long.TYPE, "$1L.longValue()", resultToReturn).whenPrimitiveOrBoxed(Integer.TYPE, "$1L.intValue()", resultToReturn).whenPrimitiveOrBoxed(Short.TYPE, "$1L.shortValue()", resultToReturn).whenPrimitiveOrBoxed(Byte.TYPE, "$1L.byteValue()", resultToReturn).whenPrimitiveOrBoxed(Float.TYPE, "$1L.floatValue()", resultToReturn).whenPrimitiveOrBoxed(Double.TYPE, "$1L.doubleValue()", resultToReturn);
        }

        @Contract(value="_, _ -> this")
        public TypedReturnBuilder whenBoolean(String format, Object ... args) {
            return this.when(this.returnType.isAssignableFrom(Boolean.TYPE) || this.returnType.isAssignableFrom(Boolean.class), format, args);
        }

        @Contract(value="_, _ -> this")
        public TypedReturnBuilder whenBoxedLong(String format, Object ... args) {
            return this.whenBoxed(Long.TYPE, format, args);
        }

        @Contract(value="_, _ -> this")
        public TypedReturnBuilder whenLong(String format, Object ... args) {
            return this.when(this.returnType.toClass() == Long.TYPE, format, args);
        }

        @Contract(value="_, _ -> this")
        public TypedReturnBuilder whenBoxedInteger(String format, Object ... args) {
            return this.whenBoxed(Integer.TYPE, format, args);
        }

        @Contract(value="_, _ -> this")
        public TypedReturnBuilder whenInt(String format, Object ... args) {
            return this.when(this.returnType.toClass() == Integer.TYPE, format, args);
        }

        @Contract(value="null, _, _ -> fail; _, _, _ -> this")
        public TypedReturnBuilder whenBoxed(Class<?> primitiveOrWrapper, String format, Object ... args) {
            Class primitiveWrapper = ClassUtils.resolvePrimitiveIfNecessary(primitiveOrWrapper);
            return this.when(this.returnType.toClass() == primitiveWrapper, format, args);
        }

        @Contract(value="null, _, _ -> fail; _, _, _ -> this")
        public TypedReturnBuilder whenPrimitiveOrBoxed(Class<?> primitiveType, String format, Object ... args) {
            Class primitiveWrapper = ClassUtils.resolvePrimitiveIfNecessary(primitiveType);
            return this.when(ClassUtils.isAssignable((Class)ClassUtils.resolvePrimitiveIfNecessary((Class)this.returnType.toClass()), (Class)primitiveWrapper), format, args);
        }

        @Contract(value="null, _, _ -> fail; _, _, _ -> this")
        public TypedReturnBuilder when(Class<?> returnType, String format, Object ... args) {
            Assert.notNull(returnType, (String)"Return type must not be null");
            return this.when(this.returnType.isAssignableFrom(returnType), format, args);
        }

        @Override
        @Contract(value="_, _, _ -> this")
        public TypedReturnBuilder when(boolean condition, String format, Object ... args) {
            super.when(condition, format, args);
            return this;
        }

        @Contract(value="_ -> this")
        public TypedReturnBuilder optional(CodeBlock codeBlock) {
            return this.optional("$L", codeBlock);
        }

        @Contract(value="null, _ -> fail; _, _ -> this")
        public TypedReturnBuilder optional(String format, Object ... args) {
            if (Optional.class.isAssignableFrom(this.returnType.toClass())) {
                Assert.hasText((String)format, (String)"Format must not be null or empty");
                if (format.startsWith("return")) {
                    throw new IllegalArgumentException("Return value format '%s' must not contain 'return'".formatted(format));
                }
                this.otherwise((CodeBlock.Builder builder) -> {
                    builder.add("$T.ofNullable(", new Object[]{Optional.class});
                    builder.add(format, args);
                    builder.add(")", new Object[0]);
                });
                return this;
            }
            return this.otherwise(format, args);
        }

        @Contract(value="_ -> this")
        public TypedReturnBuilder otherwise(CodeBlock codeBlock) {
            return this.otherwise("$L", codeBlock);
        }

        @Override
        @Contract(value="_, _ -> this")
        public TypedReturnBuilder otherwise(String format, Object ... args) {
            super.otherwise(format, args);
            return this;
        }
    }

    record CodeTuple(String format, @Nullable Object[] args) {
    }

    record ReturnRule(boolean condition, String format, @Nullable Object[] args, @Nullable Consumer<// Could not load outer class - annotation placement on inner may be incorrect
    CodeBlock.Builder> builderCustomizer) {
        public void accept(CodeBlock.Builder builder) {
            if (StringUtils.hasText((String)this.format()) || this.builderCustomizer() != null) {
                builder.add(" ", new Object[0]);
                if (StringUtils.hasText((String)this.format())) {
                    builder.add(this.format(), this.args());
                }
                if (this.builderCustomizer() != null) {
                    this.builderCustomizer().accept(builder);
                }
            }
        }
    }

    public static abstract class ReturnBuilderSupport {
        private final List<ReturnRule> rules = new ArrayList<ReturnRule>();
        private final List<ReturnRule> fallback = new ArrayList<ReturnRule>();

        ReturnBuilderSupport() {
        }

        @Contract(value="_, _, _ -> this")
        public ReturnBuilderSupport when(boolean condition, String format, Object ... args) {
            this.rules.add(ReturnBuilderSupport.ruleOf(condition, format, args));
            return this;
        }

        @Contract(value="_, _ -> this")
        public ReturnBuilderSupport otherwise(String format, Object ... args) {
            this.fallback.add(ReturnBuilderSupport.ruleOf(true, format, args));
            return this;
        }

        ReturnBuilderSupport otherwise(Consumer<CodeBlock.Builder> builderConsumer) {
            this.fallback.add(new ReturnRule(true, "", new Object[0], builderConsumer));
            return this;
        }

        @CheckReturnValue
        public CodeBlock build() {
            CodeBlock.Builder builder = CodeBlock.builder();
            for (ReturnRule rule : () -> Stream.concat(this.rules.stream(), this.fallback.stream()).iterator()) {
                if (!rule.condition()) continue;
                builder.add("return", new Object[0]);
                rule.accept(builder);
                return builder.build();
            }
            return builder.build();
        }

        static ReturnRule ruleOf(boolean condition, String format, Object ... args) {
            Assert.notNull((Object)format, (String)"Format must not be null");
            if (format.startsWith("return")) {
                throw new IllegalArgumentException("Return value format '%s' must not contain 'return'".formatted(format));
            }
            return new ReturnRule(condition, format, args, null);
        }
    }

    public static class StatementBuilder {
        private final List<CodeBlock> blocks = new ArrayList<CodeBlock>();

        StatementBuilder() {
        }

        public boolean isEmpty() {
            return this.blocks.isEmpty();
        }

        public ConditionalStatementStep when(boolean state) {
            return this.whenNot(!state);
        }

        public ConditionalStatementStep whenNot(boolean state) {
            return (format, args) -> {
                if (!state) {
                    this.add(format, args);
                }
                return this;
            };
        }

        @Contract(value="_, _ -> this")
        public StatementBuilder add(String format, Object ... args) {
            return this.add(CodeBlock.of((String)format, (Object[])args));
        }

        @Contract(value="null -> fail; _ -> this")
        public StatementBuilder add(CodeBlock codeBlock) {
            Assert.notNull((Object)codeBlock, (String)"CodeBlock must not be null");
            this.blocks.add(codeBlock);
            return this;
        }

        @Contract(value="null, _ -> fail; _, _ -> this")
        public <T> StatementBuilder addAll(Iterable<? extends T> elements, String delim, Function<? super T, CodeBlock> mapper) {
            return this.addAll(elements, (? super T t) -> delim, mapper);
        }

        @Contract(value="null, _, _ -> fail; _, _, _ -> this")
        public <T> StatementBuilder addAll(Iterable<? extends T> elements, Function<? super T, String> delim, Function<? super T, CodeBlock> mapper) {
            Assert.notNull(elements, (String)"Elements must not be null");
            boolean first = true;
            for (T element : elements) {
                if (first) {
                    first = false;
                } else {
                    this.blocks.add(CodeBlock.of((String)delim.apply(element), (Object[])new Object[0]));
                }
                this.add(mapper.apply(element));
            }
            return this;
        }

        public static interface ConditionalStatementStep {
            public StatementBuilder then(String var1, Object ... var2);
        }
    }
}

