/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.ProcessGroupClient;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;

public class PGDelete
extends AbstractNiFiCommand<StringResult> {
    public PGDelete() {
        super("pg-delete", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Deletes the given process group. Deleting a process group requires, stopping all Processors, disabling all Controller Services, and emptying all Queues.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        ProcessGroupClient pgClient = client.getProcessGroupClient();
        ProcessGroupEntity pgEntity = pgClient.getProcessGroup(pgId);
        if (pgEntity == null) {
            throw new NiFiClientException("Process group with id " + pgId + " not found.");
        }
        pgClient.deleteProcessGroup(pgEntity);
        return new StringResult(pgId, this.isInteractive());
    }
}

