/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.extension;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.extension.manifest.ExtensionType;
import org.apache.nifi.registry.client.ExtensionClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.extension.component.ExtensionFilterParams;
import org.apache.nifi.registry.extension.component.ExtensionMetadata;
import org.apache.nifi.registry.extension.component.ExtensionMetadataContainer;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.registry.ExtensionMetadataResult;
import org.apache.nifi.util.StringUtils;

public class ListExtensions
extends AbstractNiFiRegistryCommand<ExtensionMetadataResult> {
    public ListExtensions() {
        super("list-extensions", ExtensionMetadataResult.class);
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.EXT_TAGS.createOption());
        this.addOption(CommandOption.EXT_TYPE.createOption());
    }

    @Override
    public String getDescription() {
        return "Lists info for extensions, optionally filtering by one or more tags. If specifying tags, multiple tags can be specified with a comma-separated list, and each tag will be OR'd together.";
    }

    @Override
    public ExtensionMetadataResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        String tags = this.getArg(properties, CommandOption.EXT_TAGS);
        String extensionType = this.getArg(properties, CommandOption.EXT_TYPE);
        ExtensionClient extensionClient = client.getExtensionClient();
        ExtensionFilterParams filterParams = this.getFilterParams(tags, extensionType);
        ExtensionMetadataContainer metadataContainer = extensionClient.findExtensions(filterParams);
        ArrayList<ExtensionMetadata> metadataList = new ArrayList<ExtensionMetadata>(metadataContainer.getExtensions());
        return new ExtensionMetadataResult(this.getResultType(properties), metadataList);
    }

    private ExtensionFilterParams getFilterParams(String tagsArg, String extensionTypeArg) throws NiFiRegistryException {
        ExtensionFilterParams.Builder builder = new ExtensionFilterParams.Builder();
        if (!StringUtils.isBlank((String)tagsArg)) {
            String[] splitTags = tagsArg.split("[,]");
            Set cleanedTags = Arrays.stream(splitTags).map(t -> t.trim()).collect(Collectors.toSet());
            if (cleanedTags.isEmpty()) {
                throw new IllegalArgumentException("Invalid tag argument");
            }
            builder.addTags(cleanedTags).build();
        }
        if (!StringUtils.isEmpty((String)extensionTypeArg)) {
            try {
                ExtensionType extensionType = ExtensionType.valueOf((String)extensionTypeArg);
                builder.extensionType(extensionType);
            }
            catch (Exception e) {
                String supportedTypes = Arrays.stream(ExtensionType.values()).map(Enum::toString).collect(Collectors.joining(", "));
                throw new NiFiRegistryException("Invalid extension type, should be one of " + supportedTypes);
            }
        }
        return builder.build();
    }
}

