/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.explain;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.opensearch.action.ActionResponse;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.xcontent.ConstructingObjectParser;
import org.opensearch.common.xcontent.ContextParser;
import org.opensearch.common.xcontent.StatusToXContentObject;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.index.get.GetResult;
import org.opensearch.rest.RestStatus;

public class ExplainResponse
extends ActionResponse
implements StatusToXContentObject {
    private static final ParseField _INDEX = new ParseField("_index", new String[0]);
    private static final ParseField _TYPE = new ParseField("_type", new String[0]);
    private static final ParseField _ID = new ParseField("_id", new String[0]);
    private static final ParseField MATCHED = new ParseField("matched", new String[0]);
    private static final ParseField EXPLANATION = new ParseField("explanation", new String[0]);
    private static final ParseField VALUE = new ParseField("value", new String[0]);
    private static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    private static final ParseField DETAILS = new ParseField("details", new String[0]);
    private static final ParseField GET = new ParseField("get", new String[0]);
    private String index;
    private String type;
    private String id;
    private boolean exists;
    private Explanation explanation;
    private GetResult getResult;
    private static final ConstructingObjectParser<ExplainResponse, Boolean> PARSER = new ConstructingObjectParser("explain", true, (arg, exists) -> new ExplainResponse((String)arg[0], (String)arg[1], (String)arg[2], (boolean)exists, (Explanation)arg[3], (GetResult)arg[4]));

    ExplainResponse() {
    }

    public ExplainResponse(String index, String type, String id, boolean exists) {
        this.index = index;
        this.type = type;
        this.id = id;
        this.exists = exists;
    }

    public ExplainResponse(String index, String type, String id, boolean exists, Explanation explanation) {
        this(index, type, id, exists);
        this.explanation = explanation;
    }

    public ExplainResponse(String index, String type, String id, boolean exists, Explanation explanation, GetResult getResult) {
        this(index, type, id, exists, explanation);
        this.getResult = getResult;
    }

    public ExplainResponse(StreamInput in) throws IOException {
        super(in);
        this.index = in.readString();
        this.type = in.readString();
        this.id = in.readString();
        this.exists = in.readBoolean();
        if (in.readBoolean()) {
            this.explanation = Lucene.readExplanation(in);
        }
        if (in.readBoolean()) {
            this.getResult = new GetResult(in);
        }
    }

    public String getIndex() {
        return this.index;
    }

    @Deprecated
    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public Explanation getExplanation() {
        return this.explanation;
    }

    public boolean isMatch() {
        return this.explanation != null && this.explanation.isMatch();
    }

    public boolean hasExplanation() {
        return this.explanation != null;
    }

    public boolean isExists() {
        return this.exists;
    }

    public GetResult getGetResult() {
        return this.getResult;
    }

    @Override
    public RestStatus status() {
        return this.exists ? RestStatus.OK : RestStatus.NOT_FOUND;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeBoolean(this.exists);
        if (this.explanation == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Lucene.writeExplanation(out, this.explanation);
        }
        if (this.getResult == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.getResult.writeTo(out);
        }
    }

    public static ExplainResponse fromXContent(XContentParser parser, boolean exists) {
        return (ExplainResponse)PARSER.apply(parser, (Object)exists);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(_INDEX.getPreferredName(), this.index);
        builder.field(_TYPE.getPreferredName(), this.type);
        builder.field(_ID.getPreferredName(), this.id);
        builder.field(MATCHED.getPreferredName(), this.isMatch());
        if (this.hasExplanation()) {
            builder.startObject(EXPLANATION.getPreferredName());
            this.buildExplanation(builder, this.explanation);
            builder.endObject();
        }
        if (this.getResult != null) {
            builder.startObject(GET.getPreferredName());
            this.getResult.toXContentEmbedded(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private void buildExplanation(XContentBuilder builder, Explanation explanation) throws IOException {
        builder.field(VALUE.getPreferredName(), (Object)explanation.getValue());
        builder.field(DESCRIPTION.getPreferredName(), explanation.getDescription());
        Explanation[] innerExps = explanation.getDetails();
        if (innerExps != null) {
            builder.startArray(DETAILS.getPreferredName());
            for (Explanation exp : innerExps) {
                builder.startObject();
                this.buildExplanation(builder, exp);
                builder.endObject();
            }
            builder.endArray();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExplainResponse other = (ExplainResponse)obj;
        return this.index.equals(other.index) && this.type.equals(other.type) && this.id.equals(other.id) && Objects.equals(this.explanation, other.explanation) && this.getResult.isExists() == other.getResult.isExists() && Objects.equals(this.getResult.sourceAsMap(), other.getResult.sourceAsMap()) && Objects.equals(this.getResult.getFields(), other.getResult.getFields());
    }

    public int hashCode() {
        return Objects.hash(this.index, this.type, this.id, this.explanation, this.getResult.isExists(), this.getResult.sourceAsMap(), this.getResult.getFields());
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), _INDEX);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), _TYPE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), _ID);
        ConstructingObjectParser explanationParser = new ConstructingObjectParser("explanation", true, arg -> {
            if (((Float)arg[0]).floatValue() > 0.0f) {
                return Explanation.match((Number)Float.valueOf(((Float)arg[0]).floatValue()), (String)((String)arg[1]), (Collection)((Collection)arg[2]));
            }
            return Explanation.noMatch((String)((String)arg[1]), (Collection)((Collection)arg[2]));
        });
        explanationParser.declareFloat(ConstructingObjectParser.constructorArg(), VALUE);
        explanationParser.declareString(ConstructingObjectParser.constructorArg(), DESCRIPTION);
        explanationParser.declareObjectArray(ConstructingObjectParser.constructorArg(), (ContextParser)explanationParser, DETAILS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)explanationParser, EXPLANATION);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> GetResult.fromXContentEmbedded(p), GET);
    }
}

