/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.geo.builders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.spatial4j.context.SpatialContext;
import org.opensearch.common.geo.GeoShapeType;
import org.opensearch.common.geo.XShapeCollection;
import org.opensearch.common.geo.builders.ShapeBuilder;
import org.opensearch.common.geo.parsers.ShapeParser;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.geometry.MultiPoint;
import org.opensearch.geometry.Point;

public class MultiPointBuilder
extends ShapeBuilder<XShapeCollection<org.locationtech.spatial4j.shape.Point>, MultiPoint, MultiPointBuilder> {
    public static final GeoShapeType TYPE = GeoShapeType.MULTIPOINT;

    public MultiPointBuilder(List<Coordinate> coordinates) {
        super(coordinates);
    }

    public MultiPointBuilder() {
    }

    public MultiPointBuilder(StreamInput in) throws IOException {
        super(in);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ShapeParser.FIELD_TYPE.getPreferredName(), TYPE.shapeName());
        builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
        super.coordinatesToXcontent(builder, false);
        builder.endObject();
        return builder;
    }

    @Override
    public XShapeCollection<org.locationtech.spatial4j.shape.Point> buildS4J() {
        ArrayList<org.locationtech.spatial4j.shape.Point> shapes = new ArrayList<org.locationtech.spatial4j.shape.Point>(this.coordinates.size());
        for (Coordinate coord : this.coordinates) {
            shapes.add(SPATIAL_CONTEXT.makePoint(coord.x, coord.y));
        }
        XShapeCollection<org.locationtech.spatial4j.shape.Point> multiPoints = new XShapeCollection<org.locationtech.spatial4j.shape.Point>(shapes, (SpatialContext)SPATIAL_CONTEXT);
        multiPoints.setPointsOnly(true);
        return multiPoints;
    }

    @Override
    public MultiPoint buildGeometry() {
        if (this.coordinates.isEmpty()) {
            return MultiPoint.EMPTY;
        }
        return new MultiPoint(this.coordinates.stream().map(coord -> new Point(coord.x, coord.y)).collect(Collectors.toList()));
    }

    @Override
    public GeoShapeType type() {
        return TYPE;
    }

    @Override
    public int numDimensions() {
        if (this.coordinates == null || this.coordinates.isEmpty()) {
            throw new IllegalStateException("unable to get number of dimensions, LineString has not yet been initialized");
        }
        return Double.isNaN(((Coordinate)this.coordinates.get((int)0)).z) ? 2 : 3;
    }
}

