/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import com.carrotsearch.hppc.BitMixer;
import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;

public class RandomScoreFunction
extends ScoreFunction {
    private final int originalSeed;
    private final int saltedSeed;
    private final IndexFieldData<?> fieldData;

    public RandomScoreFunction(int seed, int salt, IndexFieldData<?> uidFieldData) {
        super(CombineFunction.MULTIPLY);
        this.originalSeed = seed;
        this.saltedSeed = BitMixer.mix((int)seed, (int)salt);
        this.fieldData = uidFieldData;
    }

    @Override
    public LeafScoreFunction getLeafScoreFunction(final LeafReaderContext ctx) {
        SortedBinaryDocValues values;
        if (this.fieldData != null) {
            Object leafData = this.fieldData.load(ctx);
            values = leafData.getBytesValues();
            if (values == null) {
                throw new NullPointerException("failed to get fielddata");
            }
        } else {
            values = null;
        }
        return new LeafScoreFunction(){

            @Override
            public double score(int docId, float subQueryScore) throws IOException {
                int hash = values == null ? BitMixer.mix((int)(ctx.docBase + docId), (int)RandomScoreFunction.this.saltedSeed) : (values.advanceExact(docId) ? StringHelper.murmurhash3_x86_32((BytesRef)values.nextValue(), (int)RandomScoreFunction.this.saltedSeed) : RandomScoreFunction.this.saltedSeed);
                return (float)(hash & 0xFFFFFF) / 1.6777216E7f;
            }

            @Override
            public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                String field = RandomScoreFunction.this.fieldData == null ? null : RandomScoreFunction.this.fieldData.getFieldName();
                return Explanation.match((Number)Float.valueOf((float)this.score(docId, subQueryScore.getValue().floatValue())), (String)("random score function (seed: " + RandomScoreFunction.this.originalSeed + ", field: " + field + ")"), (Explanation[])new Explanation[0]);
            }
        };
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    protected boolean doEquals(ScoreFunction other) {
        RandomScoreFunction randomScoreFunction = (RandomScoreFunction)other;
        return this.originalSeed == randomScoreFunction.originalSeed && this.saltedSeed == randomScoreFunction.saltedSeed;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.originalSeed, this.saltedSeed);
    }
}

