/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse.metatags;

import java.lang.invoke.MethodHandles;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.parse.HTMLMetaTags;
import org.apache.nutch.parse.HtmlParseFilter;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseResult;
import org.apache.nutch.protocol.Content;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DocumentFragment;

public class MetaTagsParser
implements HtmlParseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Configuration conf;
    private Set<String> metatagset = new HashSet<String>();

    public void setConf(Configuration conf) {
        String[] values;
        this.conf = conf;
        for (String val : values = conf.getStrings("metatags.names", new String[]{"*"})) {
            this.metatagset.add(val.toLowerCase(Locale.ROOT));
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    private void addIndexedMetatags(Metadata metadata, String metatag, String value) {
        String lcMetatag = metatag.toLowerCase(Locale.ROOT);
        if (this.metatagset.contains("*") || this.metatagset.contains(lcMetatag)) {
            LOG.debug("Found meta tag: {}\t{}", (Object)lcMetatag, (Object)value);
            metadata.add("metatag." + lcMetatag, value);
        }
    }

    private void addIndexedMetatags(Metadata metadata, String metatag, String[] values) {
        String lcMetatag = metatag.toLowerCase(Locale.ROOT);
        if (this.metatagset.contains("*") || this.metatagset.contains(lcMetatag)) {
            String key = "metatag." + lcMetatag;
            for (String value : values) {
                LOG.debug("Found meta tag: {}\t{}", (Object)lcMetatag, (Object)value);
                metadata.add(key, value);
            }
        }
    }

    public ParseResult filter(Content content, ParseResult parseResult, HTMLMetaTags metaTags, DocumentFragment doc) {
        Parse parse = parseResult.get(content.getUrl());
        Metadata metadata = parse.getData().getParseMeta();
        Metadata generalMetaTags = metaTags.getGeneralTags();
        for (String tagName : generalMetaTags.names()) {
            this.addIndexedMetatags(metadata, tagName, generalMetaTags.getValues(tagName));
        }
        Properties httpequiv = metaTags.getHttpEquivTags();
        Enumeration<?> tagNames = httpequiv.propertyNames();
        while (tagNames.hasMoreElements()) {
            String name = (String)tagNames.nextElement();
            String value = httpequiv.getProperty(name);
            this.addIndexedMetatags(metadata, name, value);
        }
        return parseResult;
    }
}

